/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2;

import java.io.File;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.symfony2.Bundle;
import org.netbeans.modules.php.symfony2.preferences.SymfonyPreferences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class SymfonyVersion {
    final PhpModule phpModule;

    SymfonyVersion(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    @CheckForNull
    public static SymfonyVersion forPhpModule(PhpModule phpModule) {
        Sf3 sf3 = new Sf3(phpModule);
        FileObject console = sf3.getConsole();
        if (console != null && console.isData()) {
            return sf3;
        }
        Sf2 sf2 = new Sf2(phpModule);
        console = sf2.getConsole();
        if (console != null && console.isData()) {
            return sf2;
        }
        return null;
    }

    @CheckForNull
    public abstract FileObject getConsole();

    @NonNull
    public abstract String getFrameworkName(boolean var1);

    @CheckForNull
    public abstract FileObject getTests();

    @CheckForNull
    public abstract File getCacheDir();

    @CheckForNull
    FileObject getConsole(String relativeParentDir) {
        FileObject sourceDirectory = this.phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        FileObject appDir = sourceDirectory.getFileObject(relativeParentDir);
        if (appDir == null) {
            return null;
        }
        File appDirFile = FileUtil.toFile((FileObject)appDir);
        if (appDirFile != null) {
            File file = new File(appDirFile, "console");
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        return null;
    }

    private static final class Sf3
    extends SymfonyVersion {
        private static final String BIN_DIR_PATH = "bin";
        private static final String TEST_DIR_PATH = "tests";
        private static final String CACHE_DIR_PATH = "var/cache";

        Sf3(PhpModule phpModule) {
            super(phpModule);
        }

        @Override
        public String getFrameworkName(boolean shortName) {
            if (shortName) {
                return Bundle.Sf3_name_short();
            }
            return Bundle.Sf3_name_long();
        }

        @Override
        @CheckForNull
        public FileObject getConsole() {
            return this.getConsole(BIN_DIR_PATH);
        }

        @Override
        public FileObject getTests() {
            return this.phpModule.getProjectDirectory().getFileObject(TEST_DIR_PATH);
        }

        @Override
        public File getCacheDir() {
            FileObject sourceDirectory = this.phpModule.getSourceDirectory();
            if (sourceDirectory == null) {
                return null;
            }
            return new File(FileUtil.toFile((FileObject)sourceDirectory), CACHE_DIR_PATH.replace('/', File.separatorChar));
        }
    }

    private static final class Sf2
    extends SymfonyVersion {
        private static final String TEST_DIR_PATH = "src/AppBundle/Tests";
        private static final String CACHE_DIR_NAME = "cache";
        private static final String DEFAULT_CACHE_DIR_PATH = "app/cache";

        Sf2(PhpModule phpModule) {
            super(phpModule);
        }

        @Override
        public String getFrameworkName(boolean shortName) {
            if (shortName) {
                return Bundle.Sf2_name_short();
            }
            return Bundle.Sf2_name_long();
        }

        @Override
        @CheckForNull
        public FileObject getConsole() {
            return this.getConsole(SymfonyPreferences.getAppDir(this.phpModule));
        }

        @Override
        public FileObject getTests() {
            return this.phpModule.getProjectDirectory().getFileObject(TEST_DIR_PATH);
        }

        @Override
        public File getCacheDir() {
            FileObject sourceDirectory = this.phpModule.getSourceDirectory();
            if (sourceDirectory == null) {
                return null;
            }
            File defaultCacheDir = new File(FileUtil.toFile((FileObject)sourceDirectory), DEFAULT_CACHE_DIR_PATH.replace('/', File.separatorChar));
            FileObject appDir = sourceDirectory.getFileObject(SymfonyPreferences.getAppDir(this.phpModule));
            if (appDir == null) {
                return defaultCacheDir;
            }
            FileObject cacheFo = appDir.getFileObject(CACHE_DIR_NAME);
            if (cacheFo != null && cacheFo.isFolder()) {
                return FileUtil.toFile((FileObject)cacheFo);
            }
            return defaultCacheDir;
        }
    }
}

