/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.universe.TestEntry;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SourceForBinaryImpl
implements SourceForBinaryQueryImplementation {
    private final NbModuleProject project;
    private URL classesUrl;
    private final Map<String, URL> testClassesUrl = new HashMap<String, URL>();
    private Map<URL, SourceForBinaryQuery.Result> cache = new HashMap<URL, SourceForBinaryQuery.Result>();

    public SourceForBinaryImpl(NbModuleProject project) {
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        SourceForBinaryQuery.Result res = this.cache.get(binaryRoot);
        if (res == null) {
            FileObject srcDir;
            File binaryJarF = FileUtil.archiveOrDirForURL((URL)binaryRoot);
            if (binaryJarF != null) {
                srcDir = null;
                Object var5_5 = null;
                if (binaryJarF.getAbsolutePath().endsWith(this.project.evaluator().getProperty("module.jar").replace('/', File.separatorChar))) {
                    srcDir = this.project.getSourceDirectory();
                    File file = this.project.getGeneratedClassesDirectory();
                } else {
                    TestEntry entry = TestEntry.get(binaryJarF);
                    if (entry != null && this.project.getCodeNameBase().equals(entry.getCodeNameBase())) {
                        String type = entry.getTestType();
                        srcDir = this.project.getTestSourceDirectory(type);
                        File file = this.project.getTestGeneratedClassesDirectory(type);
                    } else {
                        String n = binaryJarF.getName();
                        if (n.endsWith(".jar")) {
                            File jFolder = new File(binaryJarF.getParentFile(), n.substring(0, n.length() - ".jar".length()) + "-src");
                            if (jFolder.isDirectory()) {
                                res = new Result(FileUtil.toFileObject((File)jFolder), null);
                                this.cache.put(binaryRoot, res);
                                return res;
                            }
                            File jZip = new File(jFolder.getAbsolutePath() + ".zip");
                            if (jZip.isFile()) {
                                res = new Result(FileUtil.getArchiveRoot((FileObject)FileUtil.toFileObject((File)jZip)), null);
                                this.cache.put(binaryRoot, res);
                                return res;
                            }
                        }
                    }
                }
                if (srcDir != null) {
                    void var5_8;
                    res = new Result(srcDir, (File)var5_8);
                    this.cache.put(binaryRoot, res);
                    return res;
                }
            }
            if (binaryRoot.equals(this.getClassesUrl())) {
                srcDir = this.project.getSourceDirectory();
                if (srcDir != null) {
                    res = new Result(srcDir, this.project.getGeneratedClassesDirectory());
                }
            } else {
                for (String string : this.project.supportedTestTypes()) {
                    FileObject testSrcDir;
                    if (!binaryRoot.equals(this.getTestClassesUrl(string)) || (testSrcDir = this.project.getTestSourceDirectory(string)) == null) continue;
                    res = new Result(testSrcDir, this.project.getTestGeneratedClassesDirectory(string));
                    break;
                }
                if (res == null) {
                    block1: for (Map.Entry entry : this.project.getExtraCompilationUnits().entrySet()) {
                        for (Element kid : XMLUtil.findSubElements((Element)((Element)entry.getValue()))) {
                            if (!kid.getLocalName().equals("built-to")) continue;
                            String rawtext = XMLUtil.findText((Node)kid);
                            assert (rawtext != null) : "Null content for <built-to> in " + this.project;
                            String text = this.project.evaluator().evaluate(rawtext);
                            if (text == null) continue;
                            File loc = this.project.getHelper().resolveFile(text);
                            URL u = FileUtil.urlForArchiveOrDir((File)loc);
                            if (u == null) {
                                Logger.getLogger(SourceForBinaryImpl.class.getName()).log(Level.WARNING, "In " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()) + " " + loc + " is neither a directory nor a JAR");
                                continue;
                            }
                            if (!u.equals(binaryRoot)) continue;
                            res = new Result((FileObject)entry.getKey(), null);
                            break block1;
                        }
                    }
                }
            }
            if (res != null) {
                this.cache.put(binaryRoot, res);
            }
        }
        return res;
    }

    private URL getClassesUrl() {
        if (this.classesUrl == null) {
            this.classesUrl = FileUtil.urlForArchiveOrDir((File)this.project.getClassesDirectory());
        }
        return this.classesUrl;
    }

    private URL getTestClassesUrl(String testType) {
        if (!this.testClassesUrl.containsKey(testType) && this.project.supportedTestTypes().contains(testType)) {
            File testClassesDir = this.project.getTestClassesDirectory(testType);
            this.testClassesUrl.put(testType, FileUtil.urlForArchiveOrDir((File)testClassesDir));
        }
        return this.testClassesUrl.get(testType);
    }

    private static class Result
    implements SourceForBinaryQuery.Result {
        private FileObject[] res;

        public Result(FileObject res, File other) {
            assert (res != null);
            FileObject otherFO = other != null ? FileUtil.toFileObject((File)other) : null;
            this.res = otherFO != null ? new FileObject[]{res, otherFO} : new FileObject[]{res};
        }

        public FileObject[] getRoots() {
            return this.res;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

