/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.netbeans.lib.profiler.ui.swing.renderer.BaseRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.RelativeRenderer;

public abstract class MultiRenderer
extends BaseRenderer
implements RelativeRenderer {
    private Dimension preferredSize;

    protected int renderersGap() {
        return 0;
    }

    protected abstract ProfilerRenderer[] valueRenderers();

    @Override
    public void setDiffMode(boolean diffMode) {
        ProfilerRenderer[] valueRenderers = this.valueRenderers();
        if (valueRenderers == null) {
            return;
        }
        for (ProfilerRenderer renderer : valueRenderers) {
            if (!(renderer instanceof RelativeRenderer)) continue;
            ((RelativeRenderer)((Object)renderer)).setDiffMode(diffMode);
        }
    }

    @Override
    public boolean isDiffMode() {
        ProfilerRenderer[] valueRenderers = this.valueRenderers();
        if (valueRenderers == null) {
            return false;
        }
        for (ProfilerRenderer renderer : valueRenderers) {
            if (!(renderer instanceof RelativeRenderer)) continue;
            return ((RelativeRenderer)((Object)renderer)).isDiffMode();
        }
        return false;
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        ProfilerRenderer[] valueRenderers = this.valueRenderers();
        if (valueRenderers == null) {
            return;
        }
        for (ProfilerRenderer renderer : valueRenderers) {
            renderer.getComponent().setOpaque(isOpaque);
        }
    }

    @Override
    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        ProfilerRenderer[] valueRenderers = this.valueRenderers();
        if (valueRenderers == null) {
            return;
        }
        for (ProfilerRenderer renderer : valueRenderers) {
            renderer.getComponent().setForeground(foreground);
        }
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        ProfilerRenderer[] valueRenderers = this.valueRenderers();
        if (valueRenderers == null) {
            return;
        }
        for (ProfilerRenderer renderer : valueRenderers) {
            renderer.getComponent().setBackground(background);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension();
        } else {
            this.preferredSize.setSize(0, 0);
        }
        ProfilerRenderer[] valueRenderers = this.valueRenderers();
        if (valueRenderers != null) {
            int visible = 0;
            for (ProfilerRenderer renderer : valueRenderers) {
                JComponent component = renderer.getComponent();
                if (!component.isVisible()) continue;
                Dimension rendererSize = component.getPreferredSize();
                this.preferredSize.width += rendererSize.width;
                this.preferredSize.height = Math.max(this.preferredSize.height, rendererSize.height);
                ++visible;
            }
            this.preferredSize.width += this.renderersGap() * (visible - 1);
        }
        return this.sharedDimension(this.preferredSize);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int alignment = this.getHorizontalAlignment();
        int renderersGap = this.renderersGap();
        if (alignment == 10 || alignment == 2) {
            int xx = this.location.x;
            for (ProfilerRenderer renderer : this.valueRenderers()) {
                JComponent component = renderer.getComponent();
                if (!component.isVisible()) continue;
                int componentWidth = component.getPreferredSize().width;
                component.setSize(componentWidth, this.size.height);
                renderer.move(xx, this.location.y);
                component.paint(g);
                xx += componentWidth + renderersGap;
            }
        } else {
            int xx = this.location.x + this.size.width;
            ProfilerRenderer[] valueRenderers = this.valueRenderers();
            for (int i = valueRenderers.length - 1; i >= 0; --i) {
                ProfilerRenderer renderer = valueRenderers[i];
                JComponent component = renderer.getComponent();
                if (!component.isVisible()) continue;
                int componentWidth = component.getPreferredSize().width;
                component.setSize(componentWidth, this.size.height);
                renderer.move(xx -= componentWidth, this.location.y);
                component.paint(g);
                xx -= renderersGap;
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        ProfilerRenderer[] renderers = this.valueRenderers();
        if (renderers != null) {
            for (ProfilerRenderer renderer : renderers) {
                sb.append(renderer.toString());
            }
        }
        return sb.toString();
    }
}

