/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.xy.synchronous;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;

public class SynchronousXYChart
extends ChartComponent {
    private static final int[] VISIBLE_NONE = new int[]{-1, -1};
    private final Timeline timeline;
    private int[] firstVisibleIndex;
    private int[] lastVisibleIndex;
    private Map<Rectangle, int[][]> indexesCache;
    private boolean visibleIndexesDirty;
    private boolean contentsWidthChanged;
    private int oldBoundsWidth;
    private int newBoundsWidth;
    private long oldOffsetX;
    private long newOffsetX;
    private double oldScaleX;
    private double newScaleX;

    private SynchronousXYChart() {
        throw new UnsupportedOperationException("new SynchronousXYChart() not supported");
    }

    public SynchronousXYChart(SynchronousXYItemsModel itemsModel, PaintersModel paintersModel) {
        this.timeline = itemsModel.getTimeline();
        this.indexesCache = new HashMap<Rectangle, int[][]>();
        this.firstVisibleIndex = VISIBLE_NONE;
        this.lastVisibleIndex = VISIBLE_NONE;
        this.visibleIndexesDirty = true;
        this.setItemsModel(itemsModel);
        this.setPaintersModel(paintersModel);
        this.addConfigurationListener(new VisibleBoundsListener());
    }

    @Override
    protected Context createChartContext() {
        return new Context(this);
    }

    private int[] findFirstVisibleL(int[] startIndex, int viewStart, int viewEnd) {
        int[] nArray;
        int timestampsCount = this.timeline.getTimestampsCount();
        if (timestampsCount == 0 || startIndex == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        double dataStart = this.getDataX(viewStart);
        int index = startIndex[0];
        if (index == -1 && (double)this.timeline.getTimestamp(index = startIndex[1]) < dataStart) {
            return this.findFirstVisibleR(startIndex, viewStart, viewEnd);
        }
        while (index > 0) {
            long data = this.timeline.getTimestamp(index - 1);
            if ((double)data < dataStart) {
                return new int[]{index, -1};
            }
            --index;
        }
        if ((double)this.timeline.getTimestamp(index) >= dataStart) {
            int[] nArray2 = new int[2];
            nArray2[0] = index;
            nArray = nArray2;
            nArray2[1] = -1;
        } else {
            nArray = VISIBLE_NONE;
        }
        return nArray;
    }

    private int[] findLastVisibleL(int[] startIndex, int viewStart, int viewEnd) {
        int timestampsCount = this.timeline.getTimestampsCount();
        if (timestampsCount == 0 || startIndex == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        int index = startIndex[0];
        if (index == -1) {
            index = startIndex[1];
        }
        double dataStart = this.getDataX(viewStart);
        double dataEnd = this.getDataX(viewEnd);
        if ((double)this.timeline.getTimestamp(index) < dataStart) {
            return this.findLastVisibleR(startIndex, viewStart, viewEnd);
        }
        while (index >= 0) {
            long data = this.timeline.getTimestamp(index);
            if ((double)data <= dataEnd) {
                return new int[]{index, -1};
            }
            --index;
        }
        return VISIBLE_NONE;
    }

    private int[] findFirstVisibleR(int[] startIndex, int viewStart, int viewEnd) {
        int timestampsCount = this.timeline.getTimestampsCount();
        if (timestampsCount == 0 || startIndex == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        int index = startIndex[0];
        if (index == -1) {
            index = startIndex[1];
        }
        double dataStart = this.getDataX(viewStart);
        double dataEnd = this.getDataX(viewEnd);
        if ((double)this.timeline.getTimestamp(index) > dataEnd) {
            return this.findLastVisibleL(startIndex, viewStart, viewEnd);
        }
        int maxIndex = timestampsCount - 1;
        while (index <= maxIndex) {
            long data = this.timeline.getTimestamp(index);
            if ((double)data >= dataStart) {
                return new int[]{index, -1};
            }
            ++index;
        }
        return VISIBLE_NONE;
    }

    private int[] findLastVisibleR(int[] startIndex, int viewStart, int viewEnd) {
        int[] nArray;
        int timestampsCount = this.timeline.getTimestampsCount();
        if (timestampsCount == 0 || startIndex == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        double dataEnd = this.getDataX(viewEnd);
        int index = startIndex[0];
        if (index == -1 && (double)this.timeline.getTimestamp(index = startIndex[1]) > dataEnd) {
            return this.findLastVisibleL(startIndex, viewStart, viewEnd);
        }
        int maxIndex = timestampsCount - 1;
        while (index < maxIndex) {
            long data = this.timeline.getTimestamp(index + 1);
            if ((double)data > dataEnd) {
                return new int[]{index, -1};
            }
            ++index;
        }
        if ((double)this.timeline.getTimestamp(index) <= dataEnd) {
            int[] nArray2 = new int[2];
            nArray2[0] = index;
            nArray = nArray2;
            nArray2[1] = -1;
        } else {
            nArray = VISIBLE_NONE;
        }
        return nArray;
    }

    private void recomputeVisibleBounds() {
        int timestampsCount = this.timeline.getTimestampsCount();
        if (timestampsCount == 0) {
            this.firstVisibleIndex = VISIBLE_NONE;
            this.lastVisibleIndex = VISIBLE_NONE;
        } else {
            this.firstVisibleIndex = new int[]{0, -1};
            this.lastVisibleIndex = new int[]{timestampsCount - 1, -1};
            if (!this.fitsWidth()) {
                this.firstVisibleIndex = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
            }
        }
    }

    @Override
    protected void reshaped(Rectangle oldBounds, Rectangle newBounds) {
        if (!this.fitsWidth() && oldBounds.width != newBounds.width) {
            this.visibleIndexesDirty = true;
            this.oldBoundsWidth = oldBounds.width;
            this.newBoundsWidth = newBounds.width;
        }
        super.reshaped(oldBounds, newBounds);
    }

    private void updateVisibleIndexes() {
        if (!this.visibleIndexesDirty) {
            return;
        }
        this.indexesCache.clear();
        if (this.fitsWidth()) {
            this.recomputeVisibleBounds();
        } else if (this.contentsWidthChanged) {
            this.recomputeVisibleBounds();
        } else if (this.firstVisibleIndex == VISIBLE_NONE) {
            this.recomputeVisibleBounds();
        } else if (this.oldBoundsWidth != this.newBoundsWidth) {
            if (this.oldBoundsWidth < this.newBoundsWidth) {
                this.firstVisibleIndex = this.findFirstVisibleL(this.firstVisibleIndex, 0, this.getWidth());
                if (this.currentlyFollowingDataWidth()) {
                    this.lastVisibleIndex[0] = this.timeline.getTimestampsCount() - 1;
                    this.lastVisibleIndex[1] = -1;
                } else {
                    this.lastVisibleIndex = this.findLastVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                }
            } else {
                this.firstVisibleIndex = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                if (this.currentlyFollowingDataWidth()) {
                    this.lastVisibleIndex[0] = this.timeline.getTimestampsCount() - 1;
                    this.lastVisibleIndex[1] = -1;
                } else {
                    this.lastVisibleIndex = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
                }
            }
        } else if (this.oldScaleX != this.newScaleX) {
            if (this.oldScaleX < this.newScaleX) {
                this.firstVisibleIndex = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
            } else {
                this.firstVisibleIndex = this.findFirstVisibleL(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleR(this.lastVisibleIndex, 0, this.getWidth());
            }
        } else if (this.oldOffsetX != this.newOffsetX) {
            if (this.newOffsetX > this.oldOffsetX) {
                this.firstVisibleIndex = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleR(this.lastVisibleIndex, 0, this.getWidth());
            } else {
                this.firstVisibleIndex = this.findFirstVisibleL(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
            }
        }
        this.contentsWidthChanged = false;
        this.oldBoundsWidth = this.newBoundsWidth;
        this.oldScaleX = this.newScaleX;
        this.oldOffsetX = this.newOffsetX;
        this.visibleIndexesDirty = false;
    }

    private int[][] getVisibleBounds(Rectangle viewRect) {
        this.updateVisibleIndexes();
        if (this.fitsWidth() || viewRect.x == 0 && viewRect.width == this.getWidth()) {
            return new int[][]{this.firstVisibleIndex, this.lastVisibleIndex};
        }
        Rectangle rect = new Rectangle(viewRect.x, 0, viewRect.width, 0);
        Object bounds = this.indexesCache.get(rect);
        if (bounds == null) {
            int[] firstIndex = this.findFirstVisibleR(this.firstVisibleIndex, viewRect.x, viewRect.x + viewRect.width);
            int[] lastIndex = this.findLastVisibleL(this.lastVisibleIndex, viewRect.x, viewRect.x + viewRect.width);
            bounds = new int[][]{firstIndex, lastIndex};
            this.indexesCache.put(rect, (int[][])bounds);
        }
        return bounds;
    }

    public int getNearestTimestampIndex(int x, int y) {
        long distance;
        int timestampsCount = this.timeline.getTimestampsCount();
        if (timestampsCount == 0) {
            return -1;
        }
        if (timestampsCount == 1) {
            return 0;
        }
        long dataX = (long)this.getDataX(x);
        if (this.firstVisibleIndex == VISIBLE_NONE) {
            return -1;
        }
        int nearestIndex = this.firstVisibleIndex[0];
        if (nearestIndex == -1) {
            nearestIndex = this.firstVisibleIndex[1];
        }
        long itemDataX = this.timeline.getTimestamp(nearestIndex);
        long nearestDistance = Math.abs(dataX - itemDataX);
        int lastIndex = this.lastVisibleIndex[0];
        if (lastIndex == -1) {
            lastIndex = this.lastVisibleIndex[1];
        } else if (this.currentlyFollowingDataWidth()) {
            lastIndex = timestampsCount - 1;
        }
        while (nearestIndex + 1 <= lastIndex && (distance = Math.abs(dataX - (itemDataX = this.timeline.getTimestamp(nearestIndex + 1)))) < nearestDistance) {
            ++nearestIndex;
            nearestDistance = distance;
        }
        return nearestIndex;
    }

    protected static class Context
    extends ChartComponent.Context
    implements SynchronousXYChartContext {
        protected Context(SynchronousXYChart chart) {
            super(chart);
        }

        @Override
        protected SynchronousXYChart getChartComponent() {
            return (SynchronousXYChart)super.getChartComponent();
        }

        @Override
        public int[][] getVisibleBounds(Rectangle viewRect) {
            return this.getChartComponent().getVisibleBounds(viewRect);
        }

        @Override
        public int getNearestTimestampIndex(int x, int y) {
            return this.getChartComponent().getNearestTimestampIndex(x, y);
        }
    }

    private class VisibleBoundsListener
    extends ChartConfigurationListener.Adapter {
        private VisibleBoundsListener() {
        }

        @Override
        public void offsetChanged(long oldOffsetX, long oldOffsetY, long newOffsetX, long newOffsetY) {
            if (!SynchronousXYChart.this.fitsWidth() && oldOffsetX != newOffsetX) {
                SynchronousXYChart.this.visibleIndexesDirty = true;
                SynchronousXYChart.this.oldOffsetX = oldOffsetX;
                SynchronousXYChart.this.newOffsetX = newOffsetX;
            }
        }

        @Override
        public void dataBoundsChanged(long dataOffsetX, long dataOffsetY, long dataWidth, long dataHeight, long oldDataOffsetX, long oldDataOffsetY, long oldDataWidth, long oldDataHeight) {
            if (SynchronousXYChart.this.getContentsWidth() <= (long)SynchronousXYChart.this.getWidth()) {
                SynchronousXYChart.this.visibleIndexesDirty = true;
                SynchronousXYChart.this.contentsWidthChanged = true;
            }
        }

        @Override
        public void scaleChanged(double oldScaleX, double oldScaleY, double newScaleX, double newScaleY) {
            SynchronousXYChart.this.visibleIndexesDirty = true;
            if (!SynchronousXYChart.this.fitsWidth() && oldScaleX != newScaleX) {
                SynchronousXYChart.this.oldScaleX = oldScaleX;
                SynchronousXYChart.this.newScaleX = newScaleX;
            }
        }
    }
}

