/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.manager.WebServiceManager;
import org.netbeans.modules.websvc.manager.WebServicePersistenceManager;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.model.WebServiceGroup;
import org.netbeans.modules.websvc.manager.model.WebServiceGroupListener;
import org.netbeans.modules.websvc.manager.model.WebServiceListModelEvent;
import org.netbeans.modules.websvc.manager.model.WebServiceListModelListener;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class WebServiceListModel {
    public static final String DEFAULT_GROUP = "default";
    private static Random serviceRandom = new Random(System.currentTimeMillis());
    private static Random serviceGroupRandom = new Random(System.currentTimeMillis());
    public boolean isDirty = false;
    Set<WebServiceListModelListener> listeners = new HashSet<WebServiceListModelListener>();
    private List<WebServiceData> webServices = Collections.synchronizedList(new ArrayList());
    private List<WebServiceGroup> webServiceGroups = Collections.synchronizedList(new ArrayList());
    private Set<String> uniqueDisplayNames = Collections.synchronizedSet(new HashSet());
    private List<String> partnerServices = new ArrayList<String>();
    private static WebServiceListModel websvcNodeModel = new WebServiceListModel();
    private boolean initialized = false;
    private RestFolderListener partnerServiceListener;
    private List<WebServiceGroupListener> defaultGroupListeners = new ArrayList<WebServiceGroupListener>();

    private WebServiceListModel() {
    }

    public static WebServiceListModel getInstance() {
        return websvcNodeModel;
    }

    public static void resetInstance() {
        websvcNodeModel = new WebServiceListModel();
    }

    public void addWebServiceListModelListener(WebServiceListModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeWebServiceListModelListener(WebServiceListModelListener listener) {
        this.listeners.remove(listener);
    }

    public List<String> getPartnerServices() {
        return this.partnerServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsKey(List list, String key) {
        List list2 = list;
        synchronized (list2) {
            for (Object o : list) {
                WebServiceGroup wsGroup;
                if (o instanceof WebServiceData) {
                    WebServiceData wsData = (WebServiceData)o;
                    if (!wsData.getId().equals(key)) continue;
                    return true;
                }
                if (!(o instanceof WebServiceGroup) || !(wsGroup = (WebServiceGroup)o).getId().equals(key)) continue;
                return true;
            }
            return false;
        }
    }

    public String getUniqueWebServiceId() {
        this.initialize();
        String uniqueId = "webservice" + serviceRandom.nextLong();
        while (WebServiceListModel.containsKey(this.webServices, uniqueId)) {
            uniqueId = "webservice" + serviceRandom.nextLong();
        }
        return uniqueId;
    }

    public String getUniqueWebServiceGroupId() {
        this.initialize();
        String uniqueId = "webserviceGroup" + serviceGroupRandom.nextLong();
        while (WebServiceListModel.containsKey(this.webServiceGroups, uniqueId)) {
            uniqueId = "webserviceGroup" + serviceGroupRandom.nextLong();
        }
        return uniqueId;
    }

    public void addWebService(WebServiceData webService) {
        this.initialize();
        if (!this.webServices.contains(webService)) {
            WebServiceListModel.getInstance().setDirty(true);
            this.webServices.add(webService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServiceData getWebService(String webServiceId) {
        List<WebServiceData> list = this.webServices;
        synchronized (list) {
            this.initialize();
            for (WebServiceData wsData : this.webServices) {
                if (!wsData.getId().equals(webServiceId)) continue;
                return wsData;
            }
        }
        return null;
    }

    public void removeWebService(String webServiceId) {
        this.initialize();
        WebServiceData wsData = this.getWebService(webServiceId);
        if (wsData == null) {
            return;
        }
        WebServiceGroup group = this.getWebServiceGroup(wsData.getGroupId());
        WebServiceListModel.getInstance().setDirty(true);
        if (group != null) {
            group.remove(webServiceId);
        }
        this.webServices.remove(wsData);
    }

    public boolean webServiceExists(WebServiceData webService) {
        this.initialize();
        return WebServiceListModel.containsKey(this.webServices, webService.getId());
    }

    public String getUniqueDisplayName(String name) {
        this.initialize();
        String displayName = name;
        int i = 1;
        while (this.uniqueDisplayNames.contains(displayName)) {
            displayName = name + Integer.toString(i);
            ++i;
        }
        return displayName;
    }

    public boolean isDisplayNameUnique(String name) {
        return !this.uniqueDisplayNames.contains(name);
    }

    public List<WebServiceData> getWebServiceSet() {
        this.initialize();
        return this.webServices;
    }

    public void addWebServiceGroup(WebServiceGroup group) {
        this.initialize();
        if (!this.webServiceGroups.contains(group)) {
            WebServiceListModel.getInstance().setDirty(true);
            this.webServiceGroups.add(group);
            for (WebServiceListModelListener listener : this.listeners) {
                WebServiceListModelEvent evt = new WebServiceListModelEvent(group.getId());
                listener.webServiceGroupAdded(evt);
            }
        }
    }

    public void removeWebServiceGroup(String groupId) {
        this.initialize();
        WebServiceGroup group = this.getWebServiceGroup(groupId);
        if (group != null) {
            WebServiceListModel.getInstance().setDirty(true);
            String[] webserviceIds = this.getWebServiceGroup(groupId).getWebServiceIds().toArray(new String[0]);
            for (int ii = 0; null != webserviceIds && ii < webserviceIds.length; ++ii) {
                WebServiceManager.getInstance().removeWebService(this.getWebService(webserviceIds[ii]));
            }
            this.webServiceGroups.remove(group);
            Iterator<WebServiceListModelListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WebServiceListModelEvent evt = new WebServiceListModelEvent(groupId);
                iter.next().webServiceGroupRemoved(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServiceGroup getWebServiceGroup(String groupId) {
        List<WebServiceGroup> list = this.webServiceGroups;
        synchronized (list) {
            this.initialize();
            for (WebServiceGroup wsGroup : this.webServiceGroups) {
                if (!wsGroup.getId().equals(groupId)) continue;
                return wsGroup;
            }
        }
        return null;
    }

    public WebServiceData findWebServiceData(String wsdlUrl, String serviceName) {
        return this.findWebServiceData(wsdlUrl, serviceName, true);
    }

    public WebServiceData findWebServiceData(String wsdlUrl, String serviceName, boolean strict) {
        for (WebServiceData wsd : this.getWebServiceSet()) {
            if (!wsdlUrl.equals(wsd.getOriginalWsdl())) continue;
            return wsd;
        }
        return null;
    }

    public WebServiceData getWebServiceData(String wsdlUrl, String serviceName) {
        return this.getWebServiceData(wsdlUrl, serviceName, true);
    }

    public WebServiceData getWebServiceData(String wsdlUrl, String serviceName, boolean synchronous) {
        final WebServiceData target = this.findWebServiceData(wsdlUrl, serviceName, false);
        if (target != null && !target.isReady()) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        WebServiceManager.getInstance().addWebService(target, true);
                    }
                    catch (IOException ex) {
                        Logger.getGlobal().log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                }
            };
            RequestProcessor.Task t = RequestProcessor.getDefault().post(run);
            if (synchronous) {
                t.waitFinished();
            }
        }
        return target;
    }

    public List<WebServiceGroup> getWebServiceGroupSet() {
        this.initialize();
        return this.webServiceGroups;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private synchronized void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            WebServicePersistenceManager manager = new WebServicePersistenceManager();
            if (!WsdlUtil.hasProcessedImport()) {
                manager.setImported(false);
                manager.load();
                WsdlUtil.markImportProcessed();
            } else {
                manager.load();
            }
            this.partnerServiceListener = new RestFolderListener();
            FileObject restFolder = FileUtil.getConfigFile((String)"RestComponents");
            if (restFolder != null) {
                restFolder.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this.partnerServiceListener), (Object)restFolder));
            }
            for (WebServiceGroup wsGroup : this.webServiceGroups) {
                if (!wsGroup.getId().equals(DEFAULT_GROUP)) continue;
                for (WebServiceGroupListener defaultGroupListener : this.defaultGroupListeners) {
                    wsGroup.addWebServiceGroupListener(defaultGroupListener);
                }
                this.defaultGroupListeners = null;
                return;
            }
            WebServiceGroup defaultGroup = new WebServiceGroup(DEFAULT_GROUP);
            this.webServiceGroups.add(defaultGroup);
            for (WebServiceGroupListener defaultGroupListener : this.defaultGroupListeners) {
                defaultGroup.addWebServiceGroupListener(defaultGroupListener);
            }
            this.defaultGroupListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultGroupListener(WebServiceGroupListener listener) {
        List<WebServiceGroup> list = this.webServiceGroups;
        synchronized (list) {
            for (WebServiceGroup wsGroup : this.webServiceGroups) {
                if (!wsGroup.getId().equals(DEFAULT_GROUP)) continue;
                wsGroup.addWebServiceGroupListener(listener);
                return;
            }
            if (!this.defaultGroupListeners.contains(listener)) {
                this.defaultGroupListeners.add(listener);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private static final class RestFolderListener
    implements FileChangeListener {
        private RestFolderListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

