/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.actions;

import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.impl.StartManager;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;

public class StartAction
extends CookieAction {
    private static final Class[] COOKIE_CLASSES = new Class[]{DatabaseServer.class};

    public StartAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return Utils.getBundle().getString("LBL_StartAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(StartAction.class);
    }

    public boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        DatabaseServer server = (DatabaseServer)activatedNodes[0].getCookie(DatabaseServer.class);
        if (server == null) {
            return false;
        }
        DatabaseServer.ServerState state = server.getState();
        return state != DatabaseServer.ServerState.CONNECTED && !StartManager.getDefault().isStartRequested();
    }

    protected void performAction(Node[] activatedNodes) {
        DatabaseServer server = (DatabaseServer)activatedNodes[0].getCookie(DatabaseServer.class);
        String path = server.getStartPath();
        String message = Utils.getMessage("MSG_NoStartPath", new Object[0]);
        PropertiesDialog dialog = new PropertiesDialog(server);
        while (path == null || path.equals("")) {
            if (!Utils.displayConfirmDialog(message)) {
                return;
            }
            if (!dialog.displayDialog(PropertiesDialog.Tab.ADMIN)) {
                return;
            }
            path = server.getStartPath();
        }
        StartManager.getDefault().start(server);
    }

    protected int mode() {
        return 8;
    }

    protected Class<?>[] cookieClasses() {
        return COOKIE_CLASSES;
    }
}

