/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class CustomJavac
extends Javac {
    private Path processorPath;
    private boolean usingExplicitIncludes;
    private File generatedClassesDir;
    private String maybeFork;

    public void addProcessorPath(Path cp) {
        this.processorPath = cp;
    }

    public void setIncludes(String includes) {
        super.setIncludes(includes);
        this.usingExplicitIncludes = true;
    }

    public void setFork(boolean f) {
        super.setFork(f);
    }

    public void setExecutable(String forkExec) {
        this.maybeFork = forkExec;
    }

    public void execute() throws BuildException {
        String release = this.getRelease();
        if (release == null || release.isEmpty()) {
            String src;
            String tgr = this.getTarget();
            if (tgr.matches("\\d+")) {
                tgr = "1." + tgr;
            }
            if (!this.isBootclasspathOptionUsed()) {
                this.setRelease(tgr.substring(2));
            }
            if ((src = this.getSource()).matches("\\d+")) {
                src = "1." + src;
            }
            if (!JavaEnvUtils.isAtLeastJavaVersion((String)src)) {
                this.log("Cannot handle -source " + src + " from this VM; forking " + this.maybeFork, 1);
                super.setFork(true);
                super.setExecutable(this.maybeFork);
            }
        } else if (!JavaEnvUtils.isAtLeastJavaVersion((String)release)) {
            this.log("Cannot handle -release " + release + " from this VM; forking " + this.maybeFork, 1);
            super.setFork(true);
            super.setExecutable(this.maybeFork);
        }
        this.generatedClassesDir = new File(this.getDestdir().getParentFile(), this.getDestdir().getName() + "-generated");
        if (!this.usingExplicitIncludes) {
            this.cleanUpStaleClasses();
        }
        this.cleanUpDependDebris();
        super.execute();
    }

    protected void compile() {
        if (this.processorPath != null && this.processorPath.size() > 0) {
            this.createCompilerArg().setValue("-processorpath");
            this.createCompilerArg().setPath(this.processorPath);
        }
        this.createCompilerArg().setValue("-implicit:class");
        if (this.generatedClassesDir.isDirectory() || this.generatedClassesDir.mkdirs()) {
            this.createCompilerArg().setValue("-s");
            this.createCompilerArg().setFile(this.generatedClassesDir);
            if (this.generatedClassesDir.isDirectory()) {
                this.createSrc().setLocation(this.generatedClassesDir);
            }
        } else {
            this.log("Warning: could not create " + this.generatedClassesDir, 1);
        }
        super.compile();
    }

    private boolean isBootclasspathOptionUsed() {
        for (String arg : this.getCurrentCompilerArgs()) {
            if (!arg.contains("-Xbootclasspath")) continue;
            return true;
        }
        return false;
    }

    private void cleanUpStaleClasses() {
        Date startTime;
        File d = this.getDestdir();
        if (!d.isDirectory()) {
            return;
        }
        ArrayList<File> sources = new ArrayList<File>();
        for (String s : this.getSrcdir().list()) {
            sources.add(new File(s));
        }
        if (this.generatedClassesDir.isDirectory()) {
            sources.add(this.generatedClassesDir);
        }
        FileSet classes = new FileSet();
        classes.setDir(d);
        classes.setIncludes("**/*.class");
        classes.setExcludes("**/*$*.class");
        String startTimeProp = this.getProject().getProperty("module.build.started.time");
        try {
            startTime = startTimeProp != null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(startTimeProp) : null;
        }
        catch (ParseException x) {
            throw new BuildException((Throwable)x);
        }
        for (String clazz : classes.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
            if (startTime != null && new File(d, clazz).lastModified() > startTime.getTime()) continue;
            String java = clazz.substring(0, clazz.length() - ".class".length()) + ".java";
            boolean found = false;
            for (File source : sources) {
                if (!new File(source, java).isFile()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.log(new File(d, clazz) + " appears to be stale, rebuilding all module sources", 1);
            Delete delete = new Delete();
            delete.setProject(this.getProject());
            delete.setOwningTarget(this.getOwningTarget());
            delete.setLocation(this.getLocation());
            FileSet deletables = new FileSet();
            deletables.setDir(d);
            delete.addFileset(deletables);
            delete.init();
            delete.execute();
            break;
        }
    }

    public void setErrorProperty(String errorProperty) {
        throw new UnsupportedOperationException();
    }

    public void setUpdatedProperty(String updatedProperty) {
        throw new UnsupportedOperationException();
    }

    public void setFailonerror(boolean fail) {
        throw new UnsupportedOperationException();
    }

    private void cleanUpDependDebris() {
        File d = this.getDestdir();
        if (!d.isDirectory()) {
            return;
        }
        FileSet classes = new FileSet();
        classes.setDir(d);
        classes.setIncludes("**/*$*.class");
        String whiteListRaw = this.getProject().getProperty("nbjavac.ignore.missing.enclosing");
        String[] whiteList = whiteListRaw == null ? new String[]{} : whiteListRaw.split("\\s*,\\s*");
        for (String clazz : classes.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
            if (CustomJavac.isIgnored(whiteList, clazz)) {
                this.log(clazz + " ignored from the enclosing check due to ignore list", 3);
                continue;
            }
            int i = clazz.indexOf(36);
            File enclosing = new File(d, clazz.substring(0, i) + ".class");
            if (enclosing.isFile()) continue;
            File enclosed = new File(d, clazz);
            this.log(clazz + " will be deleted since " + enclosing.getName() + " is missing", 3);
            if (enclosed.delete()) continue;
            throw new BuildException("could not delete " + enclosed, this.getLocation());
        }
    }

    private static boolean isIgnored(String[] patterns, String resource) {
        for (String pattern : patterns) {
            if (!SelectorUtils.match((String)pattern, (String)resource)) continue;
            return true;
        }
        return false;
    }
}

