/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import java.awt.Color;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.micronaut.MicronautConfigUtilities;
import org.netbeans.modules.micronaut.completion.MicronautConfigCompletionTask;
import org.netbeans.modules.micronaut.completion.MicronautConfigDocumentation;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;

public class MicronautConfigCompletionProvider
implements CompletionProvider {
    public static final String PROPERTY_NAME_COLOR = MicronautConfigCompletionProvider.getHTMLColor(64, 64, 217);

    public static MicronautConfigCompletionProvider createYamlProvider() {
        return new MicronautConfigCompletionProvider();
    }

    public static MicronautConfigCompletionProvider createPropertiesProvider() {
        return new MicronautConfigCompletionProvider();
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        Project project;
        FileObject fo = EditorDocumentUtils.getFileObject((Document)component.getDocument());
        if (MicronautConfigUtilities.isMicronautConfigFile(fo) && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null && MicronautConfigProperties.hasConfigMetadata(project)) {
            switch (queryType) {
                case 1: 
                case 9: {
                    return new AsyncCompletionTask((AsyncCompletionQuery)new MicronautConfigCompletionQuery(project), component);
                }
                case 2: {
                    return new AsyncCompletionTask((AsyncCompletionQuery)new MicronautConfigDocumentationQuery(null), component);
                }
            }
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private static String getHTMLColor(int r, int g, int b) {
        Color c = LFCustoms.shiftColor((Color)new Color(r, g, b));
        return "<font color=#" + LFCustoms.getHexString((int)c.getRed()) + LFCustoms.getHexString((int)c.getGreen()) + LFCustoms.getHexString((int)c.getBlue()) + ">";
    }

    private static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private static class MicronautConfigDocumentationQuery
    extends AsyncCompletionQuery {
        private ConfigurationMetadataProperty element;

        private MicronautConfigDocumentationQuery(ConfigurationMetadataProperty element) {
            this.element = element;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            if (this.element == null) {
                this.element = MicronautConfigUtilities.resolveProperty(doc, caretOffset, null, null);
            }
            resultSet.setDocumentation((CompletionDocumentation)(this.element != null ? new MicronautConfigDocumentation(this.element) : null));
            resultSet.finish();
        }
    }

    private static class MicronautConfigCompletionQuery
    extends AsyncCompletionQuery {
        private static final String ICON = "org/netbeans/modules/editor/resources/completion/field_16.png";
        private static final Pattern FQN = Pattern.compile("(\\w+\\.)+(\\w+)");
        private final Project project;

        public MicronautConfigCompletionQuery(Project project) {
            this.project = project;
        }

        protected void query(final CompletionResultSet resultSet, Document doc, int caretOffset) {
            resultSet.addAllItems(new MicronautConfigCompletionTask().query(doc, caretOffset, this.project, new MicronautConfigCompletionTask.ItemFactory<CompletionItem>(){

                @Override
                public CompletionItem createPropertyItem(ConfigurationMetadataProperty property, int offset, int baseIndent, int indentLevelSize, int idx) {
                    resultSet.setAnchorOffset(offset);
                    String propName = property.getId();
                    String propType = property.getType();
                    CompletionUtilities.CompletionItemBuilder builder = CompletionUtilities.newCompletionItemBuilder((String)propName).iconResource(MicronautConfigCompletionQuery.ICON).leftHtmlText(property.isDeprecated() ? PROPERTY_NAME_COLOR + "<s>" + propName + "</s></font>" : PROPERTY_NAME_COLOR + propName + "</font>").sortPriority(property.isDeprecated() ? 30 : 20).documentationTask(() -> new AsyncCompletionTask((AsyncCompletionQuery)new MicronautConfigDocumentationQuery(property))).onSelect(ctx -> {
                        block17: {
                            try {
                                Document doc = ctx.getComponent().getDocument();
                                LineDocument lineDocument = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
                                if (lineDocument == null) break block17;
                                int caretOffset = ctx.getComponent().getCaretPosition();
                                int end = LineDocumentUtils.getWordEnd((LineDocument)lineDocument, (int)caretOffset);
                                if (ctx.isOverwrite() && LineDocumentUtils.getWordStart((LineDocument)lineDocument, (int)end) == offset) {
                                    String textEnd = doc.getText(end, 1);
                                    while (baseIndent < 0 && textEnd.endsWith(".")) {
                                        end = LineDocumentUtils.getWordEnd((LineDocument)lineDocument, (int)(end + 1));
                                        textEnd = doc.getText(end, 1);
                                    }
                                    if (baseIndent < 0 && textEnd.endsWith("=") || textEnd.endsWith(":")) {
                                        ++end;
                                    }
                                    doc.remove(offset, Math.max(caretOffset, end) - offset);
                                } else if (offset < caretOffset) {
                                    doc.remove(offset, caretOffset - offset);
                                }
                                StringBuilder sb = new StringBuilder();
                                String name = propName.substring(idx);
                                String[] parts = name.split("\\.");
                                if (baseIndent < 0) {
                                    int num = 1;
                                    for (int i = 0; i < parts.length; ++i) {
                                        String part = parts[i];
                                        if ("*".equals(part)) {
                                            sb.append("${PAR#" + num++ + " default=\"\"}");
                                        } else {
                                            sb.append(part);
                                        }
                                        if (i < parts.length - 1) {
                                            sb.append(".");
                                            continue;
                                        }
                                        sb.append("=${cursor}");
                                    }
                                } else {
                                    int lineStart = LineDocumentUtils.getLineStart((LineDocument)lineDocument, (int)caretOffset);
                                    int lineIndent = IndentUtils.lineIndent((Document)doc, (int)lineStart);
                                    ArrayUtilities.appendSpaces((StringBuilder)sb, (int)(baseIndent - lineIndent));
                                    int indent = baseIndent;
                                    int num = 1;
                                    for (int i = 0; i < parts.length; ++i) {
                                        String part = parts[i];
                                        if ("*".equals(part)) {
                                            sb.append("${PAR#" + num++ + " default=\"\"}");
                                        } else {
                                            sb.append(part);
                                        }
                                        if (i < parts.length - 1) {
                                            sb.append(":\n");
                                            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)(indent += indentLevelSize));
                                            continue;
                                        }
                                        sb.append(": ${cursor}");
                                    }
                                }
                                CodeTemplateManager.get((Document)doc).createTemporary(sb.toString()).insert(ctx.getComponent());
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                    if (propType != null) {
                        builder.rightHtmlText(MicronautConfigCompletionProvider.escape(FQN.matcher(propType).replaceAll("$2")));
                    }
                    return builder.build();
                }

                @Override
                public CompletionItem createTopLevelPropertyItem(String propName, int offset, int baseIndent, int indentLevelSize) {
                    resultSet.setAnchorOffset(offset);
                    return CompletionUtilities.newCompletionItemBuilder((String)propName).iconResource(MicronautConfigCompletionQuery.ICON).leftHtmlText(PROPERTY_NAME_COLOR + "<b>" + propName + "</b></font>").sortPriority(10).onSelect(ctx -> {
                        try {
                            Document doc = ctx.getComponent().getDocument();
                            LineDocument lineDocument = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
                            if (lineDocument != null) {
                                int caretOffset = ctx.getComponent().getCaretPosition();
                                int end = LineDocumentUtils.getWordEnd((LineDocument)lineDocument, (int)caretOffset);
                                if (ctx.isOverwrite() && LineDocumentUtils.getWordStart((LineDocument)lineDocument, (int)end) == offset) {
                                    String textEnd = doc.getText(end, 1);
                                    if (baseIndent < 0 && textEnd.endsWith(".") || textEnd.endsWith(":")) {
                                        ++end;
                                    }
                                    doc.remove(offset, Math.max(caretOffset, end) - offset);
                                } else if (offset < caretOffset) {
                                    doc.remove(offset, caretOffset - offset);
                                }
                                StringBuilder sb = new StringBuilder();
                                if (baseIndent < 0) {
                                    sb.append("*".equals(propName) ? "${PAR#1 default=\"\"}" : propName).append(".${cursor completionInvoke}");
                                } else {
                                    int lineStart = LineDocumentUtils.getLineStart((LineDocument)lineDocument, (int)caretOffset);
                                    int lineIndent = IndentUtils.lineIndent((Document)doc, (int)lineStart);
                                    ArrayUtilities.appendSpaces((StringBuilder)sb, (int)(baseIndent - lineIndent));
                                    sb.append("*".equals(propName) ? "${PAR#1 default=\"\"}" : propName).append(":\n");
                                    ArrayUtilities.appendSpaces((StringBuilder)sb, (int)(baseIndent + indentLevelSize));
                                    sb.append("${cursor completionInvoke}");
                                }
                                CodeTemplateManager.get((Document)doc).createTemporary(sb.toString()).insert(ctx.getComponent());
                            }
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }).build();
                }
            }));
            resultSet.finish();
        }
    }
}

