/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.profiler;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.nbimpl.actions.ProfilerLauncher;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.windows.InputOutput;

public class RunCheckerImpl
implements LateBoundPrerequisitesChecker {
    private static final Logger LOG = Logger.getLogger(RunCheckerImpl.class.getName());
    private static final String VM_ARGS = "vm.args";
    private static final String PROFILER_ARGS = "${profiler.args}";

    public boolean checkRunConfig(RunConfig config, ExecutionContext context) {
        Map configProperties = config.getProperties();
        String actionName = config.getActionName();
        if ("profile".equals(actionName) || "profile.test.single".equals(actionName) || actionName != null && actionName.startsWith("profile.single")) {
            ProfilerLauncher.Session session = ProfilerLauncher.getLastSession();
            if (session == null) {
                this.closeInputOuptut(context);
                return false;
            }
            Map sProps = session.getProperties();
            if (sProps == null) {
                this.closeInputOuptut(context);
                return false;
            }
            session.setAttribute("mvn-run-checker.config", (Object)config);
            String agentArg = (String)sProps.get("agent.jvmargs");
            String internalProfilerArgs = (String)sProps.get("profiler.info.jvmargs") + " " + agentArg;
            String prefixPublicArgs = "profiler.jvmargs";
            config.setProperty("profiler.jvmargs.all", internalProfilerArgs);
            for (Map.Entry entry : config.getProperties().entrySet()) {
                String string;
                int index;
                if (!((String)entry.getKey()).equals(VM_ARGS) || (index = (string = (String)entry.getValue()).indexOf(PROFILER_ARGS)) <= -1) continue;
                String string2 = string.replace(PROFILER_ARGS, internalProfilerArgs);
                config.setProperty((String)entry.getKey(), string2);
            }
            int idxArg = 0;
            for (Map.Entry entry : sProps.entrySet()) {
                if (!((String)entry.getKey()).startsWith("profiler.netbeansBindings.jvmarg.")) continue;
                config.setProperty("profiler.jvmargs.arg" + ++idxArg, (String)entry.getValue());
            }
            ProfilerLauncher.Session s = session;
            if (!NetBeansProfiler.getDefaultNB().startEx(s.getProfilingSettings(), s.getSessionSettings(), new AtomicBoolean())) {
                return false;
            }
        }
        return true;
    }

    private void closeInputOuptut(ExecutionContext context) {
        InputOutput ioput = context.getInputOutput();
        if (ioput != null) {
            ioput.closeInputOutput();
        }
    }

    public static final class MavenLauncherFactory
    implements ProfilerLauncher.LauncherFactory {
        public ProfilerLauncher.Launcher createLauncher(final ProfilerLauncher.Session session) {
            return new ProfilerLauncher.Launcher(){

                public void launch(boolean rerun) {
                    if (rerun) {
                        RunConfig config = (RunConfig)session.getAttribute("mvn-run-checker.config");
                        if (config != null) {
                            RunUtils.executeMaven((RunConfig)config);
                        }
                    } else {
                        ActionProvider ap;
                        FileObject f;
                        Project p = session.getProject();
                        if (p == null && (f = session.getFile()) != null) {
                            p = FileOwnerQuery.getOwner((FileObject)f);
                        }
                        if (p != null && (ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class)) != null) {
                            ap.invokeAction(session.getCommand(), session.getContext());
                        }
                    }
                }
            };
        }
    }
}

