/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.derby.ui.DerbyPropertiesPanel;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CreateSampleDatabasePanel
extends JPanel {
    private File derbySystemHome;
    private DialogDescriptor descriptor;
    private DocumentListener docListener = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent e) {
            CreateSampleDatabasePanel.this.validateInput();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CreateSampleDatabasePanel.this.validateInput();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CreateSampleDatabasePanel.this.validateInput();
        }
    };
    public JLabel databaseLocationLabel;
    public JLabel databaseLocationValueLabel;
    public JLabel databaseNameLabel;
    public JTextField databaseNameTextField;
    public JButton propertiesButton;

    public CreateSampleDatabasePanel(String derbySystemHome) {
        this.derbySystemHome = new File(derbySystemHome);
        this.initComponents();
        this.databaseNameTextField.getDocument().addDocumentListener(this.docListener);
        this.updateLocation();
    }

    public void setDialogDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
        this.validateInput();
    }

    public String getDatabaseName() {
        return this.databaseNameTextField.getText().trim();
    }

    public void setIntroduction() {
        String info = NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"INFO_DatabaseNameEmpty");
        this.descriptor.getNotificationLineSupport().setInformationMessage(info);
        this.descriptor.setValid(false);
    }

    private void validateInput() {
        if (this.descriptor == null) {
            return;
        }
        String error = null;
        String warning = null;
        String info = null;
        String databaseName = this.getDatabaseName();
        int illegalChar = DerbyDatabases.getFirstIllegalCharacter(databaseName);
        int unsupportedChar = this.getFirstUnsupportedCharacter(databaseName);
        if (databaseName.length() <= 0) {
            warning = NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"ERR_DatabaseNameEmpty");
        } else if (illegalChar >= 0) {
            error = NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"ERR_DatabaseNameIllegalChar", (Object)new Character((char)illegalChar));
        } else if (databaseName.length() > 0 && new File(this.derbySystemHome, databaseName).exists()) {
            error = NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"ERR_DatabaseDirectoryExists", (Object)databaseName);
        } else if (unsupportedChar >= 0) {
            error = NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"ERR_DatabaseNameUnsupportedChar", (Object)new Character((char)unsupportedChar));
        }
        if (error != null) {
            this.descriptor.getNotificationLineSupport().setErrorMessage(error);
            this.descriptor.setValid(false);
        } else if (warning != null) {
            this.descriptor.getNotificationLineSupport().setWarningMessage(warning);
            this.descriptor.setValid(false);
        } else if (info != null) {
            this.descriptor.getNotificationLineSupport().setInformationMessage(info);
            this.descriptor.setValid(true);
        } else {
            this.descriptor.getNotificationLineSupport().clearMessages();
            this.descriptor.setValid(true);
        }
    }

    static boolean isSql92Identifier(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (s.matches("[\\w&&[^\\d_]](_|\\d|\\w)*")) {
            return true;
        }
        if (s.matches("\\\".+\\\"")) {
            boolean unpairedQuite = false;
            for (int i = 1; i < s.length() - 1; ++i) {
                if (s.charAt(i) == '\"') {
                    unpairedQuite = !unpairedQuite;
                    continue;
                }
                if (!unpairedQuite) continue;
                return false;
            }
            return !unpairedQuite;
        }
        return false;
    }

    private void updateLocation() {
        this.databaseLocationValueLabel.setText(this.derbySystemHome.getAbsolutePath());
    }

    private int getFirstUnsupportedCharacter(String databaseName) {
        for (int i = 0; i < databaseName.length(); ++i) {
            char ch = databaseName.charAt(i);
            if (ch >= ' ' && ch <= '\u00ff') continue;
            return ch;
        }
        return -1;
    }

    private void initComponents() {
        this.databaseNameLabel = new JLabel();
        this.databaseNameTextField = new JTextField();
        this.databaseLocationLabel = new JLabel();
        this.propertiesButton = new JButton();
        this.databaseLocationValueLabel = new JLabel();
        this.databaseNameLabel.setLabelFor(this.databaseNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.databaseNameLabel, (String)NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"LBL_DatabaseName"));
        this.databaseLocationLabel.setLabelFor(this.databaseLocationValueLabel);
        Mnemonics.setLocalizedText((JLabel)this.databaseLocationLabel, (String)NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"LBL_DatabaseLocation"));
        Mnemonics.setLocalizedText((AbstractButton)this.propertiesButton, (String)NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"LBL_Properties"));
        this.propertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateSampleDatabasePanel.this.propertiesButtonActionPerformed(evt);
            }
        });
        this.databaseLocationValueLabel.setToolTipText(this.derbySystemHome.getAbsolutePath());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.databaseNameLabel).addComponent(this.databaseLocationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.databaseNameTextField, -1, 346, Short.MAX_VALUE).addComponent(this.databaseLocationValueLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.propertiesButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.databaseNameLabel).addComponent(this.databaseNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.databaseLocationValueLabel).addComponent(this.databaseLocationLabel).addComponent(this.propertiesButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.databaseNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_databaseNameTextField"));
        this.propertiesButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"ACSN_CreateDatabasePanel_propertiesButton"));
        this.propertiesButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_propertiesButton"));
        this.databaseLocationValueLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"ACSN_CreateDatabasePanel_databaseLocationValueLabel"));
        this.databaseLocationValueLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateSampleDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_databaseLocationValueLabel"));
    }

    private void propertiesButtonActionPerformed(ActionEvent evt) {
        DerbyPropertiesPanel.showDerbyProperties();
        String newLocation = DerbyOptions.getDefault().getSystemHome();
        this.databaseLocationValueLabel.setText(newLocation);
        this.databaseLocationValueLabel.setToolTipText(newLocation);
    }
}

