/*
 * Copyright 2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.kotlin.dsl.provider.plugins.precompiled.tasks

import org.gradle.api.Task
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Input


interface SharedAccessorsPackageAware {

    @get:Input
    val sharedAccessorsPackage: Property<String>
}


internal
fun <T> T.implicitImportsForPrecompiledScriptPlugins() where T : Task, T : SharedAccessorsPackageAware =
    project.implicitImports() + "${sharedAccessorsPackage.get()}.*"
