/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.compression;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gradle.api.internal.file.archive.compression.AbstractArchiver;
import org.gradle.api.internal.file.archive.compression.ArchiveOutputStreamFactory;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.internal.IoActions;
import org.gradle.internal.resource.ResourceExceptions;

public class GzipArchiver
extends AbstractArchiver {
    public GzipArchiver(ReadableResourceInternal resource) {
        super(resource);
    }

    @Override
    protected String getSchemePrefix() {
        return "gzip:";
    }

    public static ArchiveOutputStreamFactory getCompressor() {
        return new ArchiveOutputStreamFactory(){

            @Override
            public OutputStream createArchiveOutputStream(File destination) throws FileNotFoundException {
                FileOutputStream outStr = new FileOutputStream(destination);
                try {
                    return new GZIPOutputStream(outStr);
                }
                catch (Exception e) {
                    IoActions.closeQuietly((Closeable)outStr);
                    String message = String.format("Unable to create gzip output stream for file %s.", destination);
                    throw new RuntimeException(message, e);
                }
            }
        };
    }

    @Override
    public InputStream read() {
        BufferedInputStream input = new BufferedInputStream(this.resource.read());
        try {
            return new GZIPInputStream(input);
        }
        catch (Exception e) {
            IoActions.closeQuietly((Closeable)input);
            throw ResourceExceptions.readFailed((String)this.resource.getDisplayName(), (Throwable)e);
        }
    }
}

