/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.operation.AssignmentTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public final class IntrinsicAssignmentTranslator
extends AssignmentTranslator {
    private final JsExpression right;
    private final AccessTranslator accessTranslator;
    private final boolean rightExpressionTrivial;
    private final JsBlock rightBlock;

    @NotNull
    public static JsExpression doTranslate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(0);
        }
        if (context == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(1);
        }
        if (expression2 == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(1);
        }
        JsExpression jsExpression = new IntrinsicAssignmentTranslator(expression2, context).translate();
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(2);
        }
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(2);
        }
        return jsExpression;
    }

    private IntrinsicAssignmentTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(3);
        }
        if (context == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(4);
        }
        if (expression2 == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(4);
        }
        super(expression2, context);
        this.rightBlock = new JsBlock();
        this.right = this.translateRightExpression(context, expression2);
        this.rightExpressionTrivial = this.rightBlock.isEmpty();
        KtExpression left = expression2.getLeft();
        assert (left != null);
        this.accessTranslator = this.createAccessTranslator(left, !this.rightExpressionTrivial);
    }

    private JsExpression translateRightExpression(TranslationContext context, KtBinaryExpression expression2) {
        JsExpression result2 = TranslationUtils.translateRightExpression(context, expression2, this.rightBlock);
        KotlinType leftType = context.bindingContext().getType(expression2.getLeft());
        KotlinType rightType = context.bindingContext().getType(expression2.getRight());
        if (rightType != null && KotlinBuiltIns.isCharOrNullableChar(rightType)) {
            if (leftType != null && KotlinBuiltIns.isStringOrNullableString(leftType)) {
                result2 = JsAstUtils.charToString(result2);
            } else if (leftType != null && !KotlinBuiltIns.isCharOrNullableChar(leftType)) {
                result2 = TranslationUtils.charToBoxedChar(context, result2);
            }
        }
        return result2;
    }

    @NotNull
    private JsExpression translate() {
        if (PsiUtils.isAssignment(PsiUtils.getOperationToken(this.expression))) {
            JsExpression jsExpression = this.translateAsPlainAssignment();
            if (jsExpression == null) {
                IntrinsicAssignmentTranslator.$$$reportNull$$$0(5);
            }
            if (jsExpression == null) {
                IntrinsicAssignmentTranslator.$$$reportNull$$$1(5);
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.translateAsAssignmentOperation();
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(6);
        }
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(6);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateAsAssignmentOperation() {
        if (TranslationUtils.isSimpleNameExpressionNotDelegatedLocalVar(this.expression.getLeft(), this.context()) && this.rightExpressionTrivial) {
            JsExpression jsExpression = this.translateAsPlainAssignmentOperation();
            if (jsExpression == null) {
                IntrinsicAssignmentTranslator.$$$reportNull$$$0(7);
            }
            if (jsExpression == null) {
                IntrinsicAssignmentTranslator.$$$reportNull$$$1(7);
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.translateAsAssignToCounterpart();
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(8);
        }
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(8);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateAsAssignToCounterpart() {
        JsBinaryOperator operator = this.getCounterpartOperator();
        JsExpression oldValue = this.accessTranslator.translateAsGet();
        if (!this.rightExpressionTrivial) {
            oldValue = this.context().defineTemporary(oldValue);
        }
        JsBinaryOperation counterpartOperation = new JsBinaryOperation(operator, oldValue, this.right);
        this.context().addStatementsToCurrentBlockFrom(this.rightBlock);
        JsExpression jsExpression = this.accessTranslator.translateAsSet(counterpartOperation);
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(9);
        }
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(9);
        }
        return jsExpression;
    }

    @NotNull
    private JsBinaryOperator getCounterpartOperator() {
        KtToken assignmentOperationToken = PsiUtils.getOperationToken(this.expression);
        assert (assignmentOperationToken instanceof KtSingleValueToken);
        assert (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(assignmentOperationToken));
        KtToken counterpartToken = (KtToken)OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get(assignmentOperationToken);
        assert (OperatorTable.hasCorrespondingBinaryOperator(counterpartToken)) : "Unsupported token encountered: " + counterpartToken.toString();
        JsBinaryOperator jsBinaryOperator = OperatorTable.getBinaryOperator(counterpartToken);
        if (jsBinaryOperator == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(10);
        }
        if (jsBinaryOperator == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(10);
        }
        return jsBinaryOperator;
    }

    @NotNull
    private JsExpression translateAsPlainAssignmentOperation() {
        this.context().addStatementsToCurrentBlockFrom(this.rightBlock);
        JsBinaryOperator operator = this.getAssignmentOperator();
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, this.accessTranslator.translateAsGet(), this.right);
        if (jsBinaryOperation == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(11);
        }
        if (jsBinaryOperation == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(11);
        }
        return jsBinaryOperation;
    }

    @NotNull
    private JsBinaryOperator getAssignmentOperator() {
        KtToken token = PsiUtils.getOperationToken(this.expression);
        assert (token instanceof KtSingleValueToken);
        assert (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(token));
        assert (OperatorTable.hasCorrespondingBinaryOperator(token)) : "Unsupported token encountered: " + token.toString();
        JsBinaryOperator jsBinaryOperator = OperatorTable.getBinaryOperator(token);
        if (jsBinaryOperator == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(12);
        }
        if (jsBinaryOperator == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(12);
        }
        return jsBinaryOperator;
    }

    @NotNull
    private JsExpression translateAsPlainAssignment() {
        this.context().addStatementsToCurrentBlockFrom(this.rightBlock);
        JsExpression jsExpression = this.accessTranslator.translateAsSet(this.right);
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$0(13);
        }
        if (jsExpression == null) {
            IntrinsicAssignmentTranslator.$$$reportNull$$$1(13);
        }
        return jsExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/IntrinsicAssignmentTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/IntrinsicAssignmentTranslator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doTranslate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsAssignmentOperation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsAssignToCounterpart";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCounterpartOperator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsPlainAssignmentOperation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignmentOperator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsPlainAssignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTranslate";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/IntrinsicAssignmentTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/IntrinsicAssignmentTranslator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doTranslate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsAssignmentOperation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsAssignToCounterpart";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCounterpartOperator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsPlainAssignmentOperation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignmentOperator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsPlainAssignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTranslate";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

