/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.CapabilitiesSupport;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.logging.text.TreeFormatter;

public class AmbiguousConfigurationSelectionException
extends RuntimeException {
    public AmbiguousConfigurationSelectionException(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent, boolean variantAware) {
        super(AmbiguousConfigurationSelectionException.generateMessage(fromConfigurationAttributes, attributeMatcher, matches, targetComponent, variantAware));
    }

    private static String generateMessage(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent, boolean variantAware) {
        TreeMap<String, ConfigurationMetadata> ambiguousConfigurations = new TreeMap<String, ConfigurationMetadata>();
        for (ConfigurationMetadata configurationMetadata : matches) {
            ambiguousConfigurations.put(configurationMetadata.getName(), configurationMetadata);
        }
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Cannot choose between the following " + (variantAware ? "variants" : "configurations") + " of ");
        formatter.append((CharSequence)targetComponent.getId().getDisplayName());
        formatter.startChildren();
        for (String configuration : ambiguousConfigurations.keySet()) {
            formatter.node(configuration);
        }
        formatter.endChildren();
        formatter.node("All of them match the consumer attributes");
        formatter.startChildren();
        for (ConfigurationMetadata ambiguousConf : ambiguousConfigurations.values()) {
            AmbiguousConfigurationSelectionException.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, ambiguousConf, variantAware, true);
        }
        formatter.endChildren();
        return formatter.toString();
    }

    static void formatConfiguration(TreeFormatter formatter, ComponentResolveMetadata targetComponent, AttributeContainerInternal consumerAttributes, AttributeMatcher attributeMatcher, ConfigurationMetadata configuration, boolean variantAware, boolean ambiguous) {
        ImmutableAttributes producerAttributes = configuration.getAttributes();
        if (variantAware) {
            formatter.node("Variant '");
        } else {
            formatter.node("Configuration '");
        }
        formatter.append((CharSequence)configuration.getName());
        formatter.append((CharSequence)"'");
        if (variantAware) {
            formatter.append((CharSequence)(" " + CapabilitiesSupport.prettifyCapabilities(targetComponent, configuration.getCapabilities().getCapabilities())));
        }
        if (ambiguous) {
            AmbiguousConfigurationSelectionException.formatAttributeMatchesForAmbiguity(formatter, consumerAttributes.asImmutable(), attributeMatcher, producerAttributes.asImmutable());
        } else {
            AmbiguousConfigurationSelectionException.formatAttributeMatchesForIncompatibility(formatter, consumerAttributes.asImmutable(), attributeMatcher, producerAttributes.asImmutable());
        }
    }

    static void formatAttributeMatchesForIncompatibility(TreeFormatter formatter, ImmutableAttributes immutableConsumer, AttributeMatcher attributeMatcher, ImmutableAttributes immutableProducer) {
        Map<String, Attribute<?>> allAttributes = AmbiguousConfigurationSelectionException.collectAttributes(immutableConsumer, immutableProducer);
        formatter.startChildren();
        ArrayList incompatibleValues = Lists.newArrayListWithExpectedSize((int)allAttributes.size());
        ArrayList otherValues = Lists.newArrayListWithExpectedSize((int)allAttributes.size());
        for (Attribute<?> attribute : allAttributes.values()) {
            Attribute untyped = (Attribute)Cast.uncheckedCast(attribute);
            String attributeName = attribute.getName();
            AttributeValue consumerValue = immutableConsumer.findEntry(untyped);
            AttributeValue producerValue = immutableProducer.findEntry(attributeName);
            if (consumerValue.isPresent() && producerValue.isPresent()) {
                if (attributeMatcher.isMatching(untyped, producerValue.coerce(attribute), consumerValue.coerce(attribute))) {
                    otherValues.add("Required " + attributeName + " '" + consumerValue.get() + "' and found compatible value '" + producerValue.get() + "'.");
                    continue;
                }
                incompatibleValues.add("Required " + attributeName + " '" + consumerValue.get() + "' and found incompatible value '" + producerValue.get() + "'.");
                continue;
            }
            if (consumerValue.isPresent()) {
                otherValues.add("Required " + attributeName + " '" + consumerValue.get() + "' but no value provided.");
                continue;
            }
            otherValues.add("Found " + attributeName + " '" + producerValue.get() + "' but wasn't required.");
        }
        AmbiguousConfigurationSelectionException.formatAttributeSection(formatter, "Incompatible attribute", incompatibleValues);
        AmbiguousConfigurationSelectionException.formatAttributeSection(formatter, "Other attribute", otherValues);
        formatter.endChildren();
    }

    static void formatAttributeMatchesForAmbiguity(TreeFormatter formatter, ImmutableAttributes immutableConsumer, AttributeMatcher attributeMatcher, ImmutableAttributes immutableProducer) {
        Map<String, Attribute<?>> allAttributes = AmbiguousConfigurationSelectionException.collectAttributes(immutableConsumer, immutableProducer);
        formatter.startChildren();
        ArrayList compatibleValues = Lists.newArrayListWithExpectedSize((int)allAttributes.size());
        ArrayList otherValues = Lists.newArrayListWithExpectedSize((int)allAttributes.size());
        for (Attribute<?> attribute : allAttributes.values()) {
            Attribute untyped = (Attribute)Cast.uncheckedCast(attribute);
            String attributeName = attribute.getName();
            AttributeValue consumerValue = immutableConsumer.findEntry(untyped);
            AttributeValue producerValue = immutableProducer.findEntry(attributeName);
            if (consumerValue.isPresent() && producerValue.isPresent()) {
                if (attributeMatcher.isMatching(untyped, producerValue.coerce(attribute), consumerValue.coerce(attribute))) {
                    compatibleValues.add("Required " + attributeName + " '" + consumerValue.get() + "' and found compatible value '" + producerValue.get() + "'.");
                    continue;
                }
                String result = "Required " + attributeName + " '" + consumerValue.get() + "' and found incompatible value '" + producerValue.get() + "'.";
                assert (false) : "Incompatible attributes on ambiguity: " + result;
                otherValues.add(result);
                continue;
            }
            if (consumerValue.isPresent()) {
                otherValues.add("Required " + attributeName + " '" + consumerValue.get() + "' but no value provided.");
                continue;
            }
            otherValues.add("Found " + attributeName + " '" + producerValue.get() + "' but wasn't required.");
        }
        AmbiguousConfigurationSelectionException.formatAttributeSection(formatter, "Unmatched attribute", otherValues);
        AmbiguousConfigurationSelectionException.formatAttributeSection(formatter, "Compatible attribute", compatibleValues);
        formatter.endChildren();
    }

    private static Map<String, Attribute<?>> collectAttributes(ImmutableAttributes consumerAttributes, ImmutableAttributes producerAttributes) {
        TreeMap allAttributes = new TreeMap();
        for (Attribute attribute : producerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        for (Attribute attribute : consumerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        return allAttributes;
    }

    private static void formatAttributeSection(TreeFormatter formatter, String section, List<String> values) {
        if (!values.isEmpty()) {
            if (values.size() > 1) {
                formatter.node(section + "s");
            } else {
                formatter.node(section);
            }
            formatter.startChildren();
            values.forEach(arg_0 -> ((TreeFormatter)formatter).node(arg_0));
            formatter.endChildren();
        }
    }
}

