/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.rubygrapefruit.platform.file.FileInfo;
import net.rubygrapefruit.platform.file.Files;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.nativeintegration.filesystem.DefaultFileMetadata;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataAccessor;

public class NativePlatformBackedFileMetadataAccessor
implements FileMetadataAccessor {
    private final Files files;

    public NativePlatformBackedFileMetadataAccessor(Files files) {
        this.files = files;
    }

    @Override
    public FileMetadataSnapshot stat(File f) {
        FileInfo stat = this.files.stat(f, true);
        switch (stat.getType()) {
            case File: {
                return DefaultFileMetadata.file(stat.getLastModifiedTime(), stat.getSize());
            }
            case Directory: {
                return DefaultFileMetadata.directory();
            }
            case Missing: {
                return DefaultFileMetadata.missing();
            }
        }
        throw new IllegalArgumentException("Unrecognised file type: " + stat.getType());
    }

    @Override
    public FileMetadataSnapshot stat(Path path) throws IOException {
        return this.stat(path.toFile());
    }
}

