/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.configuration;

import java.util.Properties;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.process.internal.CurrentProcess;
import org.gradle.process.internal.JvmOptions;

public class BuildProcess
extends CurrentProcess {
    public BuildProcess(FileCollectionFactory fileCollectionFactory) {
        super(fileCollectionFactory);
    }

    protected BuildProcess(JavaInfo jvm, JvmOptions effectiveJvmOptions) {
        super(jvm, effectiveJvmOptions);
    }

    public boolean configureForBuild(DaemonParameters requiredBuildParameters) {
        boolean javaHomeMatch = this.getJvm().equals(requiredBuildParameters.getEffectiveJvm());
        boolean immutableJvmArgsMatch = true;
        if (requiredBuildParameters.hasUserDefinedImmutableJvmArgs()) {
            immutableJvmArgsMatch = this.getJvmOptions().getAllImmutableJvmArgs().equals(requiredBuildParameters.getEffectiveSingleUseJvmArgs());
        }
        if (javaHomeMatch && immutableJvmArgsMatch && !this.isLowDefaultMemory(requiredBuildParameters)) {
            Properties properties = new Properties();
            properties.putAll(requiredBuildParameters.getEffectiveSystemProperties());
            System.setProperties(properties);
            return true;
        }
        return false;
    }

    private boolean isLowDefaultMemory(DaemonParameters daemonParameters) {
        if (daemonParameters.hasUserDefinedImmutableJvmArgs()) {
            for (String arg : daemonParameters.getEffectiveSingleUseJvmArgs()) {
                if (!arg.startsWith("-Xmx")) continue;
                return false;
            }
        }
        return "64m".equals(this.getJvmOptions().getMaxHeapSize());
    }
}

