/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.io.File;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.BinaryToolSpec;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;

public abstract class AbstractCompiler<T extends BinaryToolSpec>
implements Compiler<T> {
    private final CommandLineToolInvocationWorker commandLineToolInvocationWorker;
    private final ArgsTransformer<T> argsTransformer;
    private final CommandLineToolContext invocationContext;
    private final boolean useCommandFile;
    private final BuildOperationExecutor buildOperationExecutor;
    private final WorkerLeaseService workerLeaseService;

    protected AbstractCompiler(BuildOperationExecutor buildOperationExecutor, CommandLineToolInvocationWorker commandLineToolInvocationWorker, CommandLineToolContext invocationContext, ArgsTransformer<T> argsTransformer, boolean useCommandFile, WorkerLeaseService workerLeaseService) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.argsTransformer = argsTransformer;
        this.invocationContext = invocationContext;
        this.useCommandFile = useCommandFile;
        this.commandLineToolInvocationWorker = commandLineToolInvocationWorker;
        this.workerLeaseService = workerLeaseService;
    }

    public WorkResult execute(T spec) {
        List<String> commonArguments = this.getArguments(spec);
        final Action<BuildOperationQueue<CommandLineToolInvocation>> invocationAction = this.newInvocationAction(spec, commonArguments);
        this.workerLeaseService.withoutProjectLock(new Runnable(){

            @Override
            public void run() {
                AbstractCompiler.this.buildOperationExecutor.runAll((BuildOperationWorker)AbstractCompiler.this.commandLineToolInvocationWorker, invocationAction);
            }
        });
        return WorkResults.didWork((boolean)true);
    }

    protected abstract Action<BuildOperationQueue<CommandLineToolInvocation>> newInvocationAction(T var1, List<String> var2);

    protected List<String> getArguments(T spec) {
        List args = (List)this.argsTransformer.transform(spec);
        Action<List<String>> userArgTransformer = this.invocationContext.getArgAction();
        userArgTransformer.execute((Object)args);
        if (this.useCommandFile) {
            this.addOptionsFileArgs(args, spec.getTempDir());
        }
        return args;
    }

    protected abstract void addOptionsFileArgs(List<String> var1, File var2);

    protected CommandLineToolInvocation newInvocation(String name, File workingDirectory, Iterable<String> args, BuildOperationLogger operationLogger) {
        return this.invocationContext.createInvocation(name, workingDirectory, args, operationLogger);
    }

    protected CommandLineToolInvocation newInvocation(String name, Iterable<String> args, BuildOperationLogger operationLogger) {
        return this.invocationContext.createInvocation(name, args, operationLogger);
    }
}

