/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class KeywordSelector
extends JDialog
implements ActionListener {
    public static final Dimension SIZE = new Dimension(200, 200);
    JButton okB;
    JButton canB;
    JButton enterKey;
    JButton deleteSelect;
    JList inList;
    JList outList;
    DefaultListModel inListModel;
    DefaultListModel outListModel;
    Container mycp = this.getContentPane();
    private DeID di;
    private FileSpec fs;
    private int maxCount;
    private String[] inKeys;
    private boolean cancelled = false;
    private byte[][] headers;

    public KeywordSelector(DeID di) {
        super(di, "Keyword Selector", true);
        this.mycp.setLayout(new BorderLayout());
        JPanel centreP = new JPanel();
        centreP.setLayout(new FlowLayout(0, 0, 1));
        this.inListModel = new DefaultListModel();
        this.inList = new JList(this.inListModel);
        this.inList.setSelectionMode(0);
        JScrollPane inScroller = new JScrollPane(this.inList);
        inScroller.setMinimumSize(SIZE);
        inScroller.setPreferredSize(SIZE);
        URL forwardImageURL = DeID.class.getResource("images/forward.gif");
        this.enterKey = forwardImageURL != null ? new JButton(new ImageIcon(forwardImageURL)) : new JButton(">");
        this.enterKey.addActionListener(this);
        this.enterKey.setToolTipText("Add selected keyword to the list");
        this.outListModel = new DefaultListModel();
        this.outList = new JList(this.outListModel);
        this.outList.setSelectionMode(0);
        JScrollPane outScroller = new JScrollPane(this.outList);
        outScroller.setMinimumSize(SIZE);
        outScroller.setPreferredSize(SIZE);
        URL deleteImageURL = DeID.class.getResource("images/delete.gif");
        this.deleteSelect = new JButton(new ImageIcon(deleteImageURL));
        this.deleteSelect.addActionListener(this);
        this.deleteSelect.setToolTipText("Delete the selected keyword from the list");
        centreP.add(inScroller);
        centreP.add(this.enterKey);
        centreP.add(outScroller);
        centreP.add(this.deleteSelect);
        JPanel butP = new JPanel();
        butP.setLayout(new BoxLayout(butP, 0));
        this.okB = new JButton("Set");
        this.okB.addActionListener(this);
        this.canB = new JButton("Cancel");
        this.canB.addActionListener(this);
        butP.add(Box.createHorizontalGlue());
        butP.add(this.okB);
        butP.add(this.canB);
        this.mycp.add("Center", centreP);
        this.mycp.add("South", butP);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                KeywordSelector.this.repaintLists();
            }
        });
    }

    public void set(FileSpec fs, String[] keys, int max) {
        this.maxCount = max;
        this.fs = fs;
        Vector segs = fs.getTextSegments();
        if (segs != null && segs.size() > 0) {
            this.headers = new byte[segs.size()][];
            this.inListModel.clear();
            int index = 0;
            while (index < segs.size()) {
                TextSegment aSeg = (TextSegment)segs.get(index);
                this.headers[index] = aSeg.getText();
                int lngth = this.headers[index].length;
                byte dlt = this.headers[index][0];
                int l = 0;
                int n = 0;
                while (l < lngth) {
                    int m = ++l;
                    while (m < lngth) {
                        if (this.headers[index][m] == dlt) break;
                        ++m;
                    }
                    if (m < lngth) {
                        boolean done = false;
                        String keyName = new String(this.headers[index], l, m - l).trim();
                        if (keyName != null && keyName.length() > 0 && this.inListModel != null) {
                            int i = 0;
                            while (i < this.inListModel.size()) {
                                done = keyName.compareTo((String)this.inListModel.get(i)) < 0;
                                if (done) {
                                    this.inListModel.insertElementAt(keyName, i);
                                    break;
                                }
                                done = keyName.compareTo((String)this.inListModel.get(i)) == 0;
                                if (done) break;
                                ++i;
                            }
                            if (!done) {
                                this.inListModel.addElement(keyName);
                            }
                        }
                    }
                    n = ++m;
                    while (n < lngth) {
                        if (this.headers[index][n] == dlt) break;
                        ++n;
                    }
                    l = n;
                }
                this.outListModel.clear();
                if (keys != null) {
                    l = 0;
                    while (l < keys.length) {
                        String keyVal;
                        if (keys[l] != null && keys[l].length() > 0 && (keyVal = FileSpec.extractS(this.headers[index], keys[l].getBytes(), dlt)) != null) {
                            this.outListModel.addElement(new Keyword(keys[l], keyVal));
                        }
                        ++l;
                    }
                }
                ++index;
            }
        }
        this.cancelled = false;
        this.inKeys = this.getKeysList();
        this.pack();
    }

    private void repaintLists() {
        this.inList.repaint();
        this.outList.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object target = evt.getSource();
        if (target == this.okB) {
            this.cancelled = false;
            this.setVisible(false);
        } else if (target == this.canB) {
            this.cancelled = true;
            this.setVisible(false);
        } else if (target == this.enterKey) {
            this.addOutKey((String)this.inList.getSelectedValue());
        } else if (target == this.deleteSelect) {
            this.deleteSelection();
        }
    }

    public void addOutKey(String k) {
        int count;
        if (k != null && (count = this.outListModel.getSize()) < this.maxCount) {
            String kv;
            int i = 0;
            while (i < this.outListModel.getSize()) {
                int compare = k.compareTo(((Keyword)this.outListModel.elementAt((int)i)).name);
                if (compare == 0) {
                    return;
                }
                if (compare < 0) break;
                ++i;
            }
            int n = 0;
            while ((kv = FileSpec.extractS(this.headers[n], k.getBytes(), this.headers[n][0])) == null && n < this.headers.length) {
                ++n;
            }
            this.outListModel.add(i, new Keyword(k, kv));
        }
    }

    public void deleteSelection() {
        int max = this.outList.getMaxSelectionIndex();
        int min = this.outList.getMinSelectionIndex();
        int i = max;
        while (i >= min && i >= 0) {
            this.outListModel.remove(i);
            --i;
        }
    }

    public String[] getKeysList() {
        if (this.cancelled) {
            return this.inKeys;
        }
        String BLANK = "";
        if (this.outListModel != null) {
            int size = this.outListModel.getSize();
            String[] list = new String[size];
            int i = 0;
            while (i < size) {
                list[i] = ((Keyword)this.outListModel.elementAt((int)i)).name;
                ++i;
            }
            return list;
        }
        return null;
    }
}

