/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class HelpBox
extends JFrame
implements ActionListener {
    private static int myWidth = 650;
    private static int myHeight = 400;
    private static int myX = 400;
    private static int myY = 0;
    private static String helpString = "The Cellular Symphony is an audio representation of flow cytometric data. Each cell may be represented by musical notes of timbre, pitch and volume dependent on its FCM parameters. \n\nOperation: \n1. Drag a folder or list of FCS data files into the CellSymphony window and select one file.\n2. Select one or more 'Pitch' parameters and the 'Instrument' to sound each.\n3. Optionally, select one parameter to modulate the note volumes and the graphic display dot sizes.\n4. Set the duration of each cell's note and the total number of cells to be sounded.\n5. Press the 'Play' button.\n6. Optionally, to record a MIDI file, press the 'Record' button before pressing 'Play'.\n\nGraphic display dot size may be selected by right-clicking or control-clicking on a display. Reselect displayed parameters by right-clicking or control-clicking on a parameter label.  Displayed parameters will be reset upon 'Play'ing the file. The 3D dot plot may be rotated by dragging with the mouse.\n\nThis program seeks to investigate whether audio output can be used as an analytical tool in flow cytometry. It may be that only a musical savant can detect the intricacies in a 3-instrument cellular symphony or it may be that the average cytometrist also can do so with practice.  Your comments are invited (info@frankbattye.com.au).";

    public HelpBox() {
        super("Cellular Symphony Help");
        JTextArea area = new JTextArea(helpString);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setEditable(false);
        JScrollPane jsp = new JScrollPane(area);
        this.getContentPane().add(jsp);
        this.pack();
        this.setLocation(myX, myY);
        this.setSize(myWidth, myHeight);
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent newEvent) {
        this.setVisible(false);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            HelpBox.this.setVisible(false);
        }
    }
}

