/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.publish;

import com.informagen.Util;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.PanelPrinter;
import com.informagen.sa.SAObject;
import com.informagen.sa.SequenceAnalysis;
import com.informagen.sa.publish.Publish;
import com.informagen.sa.publish.PublishLegend;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class PublishPanel
extends AnalysisPanel {
    private static final String defaultContentString = "s+ra  ";
    final Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    final int maxBlockSize = 20;
    final JSlider blockSizeSlider = new JSlider(1, 21, 3);
    final JSlider lineSizeSlider = new JSlider(10, 120, 60);
    final JLabel blockSizeLbl = new JLabel("3");
    final JLabel lineSizeLbl = new JLabel("60");
    final JTextField mFormatSpecField = new JTextField(10);
    final JButton legendBtn = new JButton("Legend");
    final JCheckBox useStartPositionChbx = new JCheckBox("Use cursor position as start", false);
    final JCheckBox obeyStopCodonsChbx = new JCheckBox("Obey stop codons", false);
    JTextArea outputArea = new JTextArea("");
    PublishLegend publishLegend;
    private int sequencePosition = 1;

    public static String getAnalysisName() {
        return "Publish";
    }

    public PublishPanel() {
        this.buildUI();
        this.useDefaultContentString();
        this.wireUI();
        this.mFormatSpecField.setText(this.preferences.get("format", defaultContentString));
        this.blockSizeSlider.setValue(this.preferences.getInt("blockSize", 3));
        this.lineSizeSlider.setValue(this.preferences.getInt("lineSize", 60));
        this.useStartPositionChbx.setSelected(this.preferences.getBoolean("useCursorAsStart", false));
        this.obeyStopCodonsChbx.setSelected(this.preferences.getBoolean("obeyStopCodons", false));
    }

    public boolean ignorePropertyChangeEvents() {
        return false;
    }

    public void changeSequence(SAObject sAObject, int[] nArray) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = nArray;
        this.writeIt();
    }

    public void sequenceUnavailable() {
        this.saObject = null;
        this.selection = null;
        this.sequence = null;
        this.writeToOutputArea("");
    }

    public void sequenceChanged(SAObject sAObject) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = null;
        this.writeIt();
    }

    public void selectionChanged(int[] nArray) {
        this.useStartPositionChbx.setEnabled(false);
        this.selection = nArray;
        this.writeIt();
    }

    public void selectionCancelled() {
        this.useStartPositionChbx.setEnabled(true);
        this.selection = null;
        this.writeIt();
    }

    public void cursorPositionChanged(int n) {
        this.useStartPositionChbx.setEnabled(true);
        this.sequencePosition = n;
        this.writeIt();
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 0;
        JPanel jPanel = new JPanel(gridBagLayout);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 1.0, 0.0, 10, 3);
        JPanel jPanel2 = this.buildSliderPanel();
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 1.0, 10, 3);
        JSeparator jSeparator = new JSeparator(1);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 1.0, 0.0, 10, 0);
        JPanel jPanel3 = this.buildTranslationPanel();
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 1.0, 10, 3);
        jSeparator = new JSeparator(1);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 1.0, 0.0, 10, 0);
        JPanel jPanel4 = this.buildContentPanel();
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add((Component)jPanel4, gridBagConstraints);
        this.add((Component)jPanel, "North");
        this.outputArea.setFont(new Font("Courier", 0, Util.isWindows() ? 10 : 12));
        this.outputArea.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.outputArea, 22, 30);
        this.add((Component)jScrollPane, "Center");
    }

    JPanel buildSliderPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 0;
        JPanel jPanel = new JPanel(gridBagLayout);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 17, 0);
        JLabel jLabel = new JLabel("Block size: ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 17, 0);
        gridBagLayout.setConstraints(this.blockSizeLbl, gridBagConstraints);
        jPanel.add(this.blockSizeLbl);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 2, 1, 1.0, 0.0, 17, 0);
        this.blockSizeSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.blockSizeSlider.setSnapToTicks(true);
        gridBagLayout.setConstraints(this.blockSizeSlider, gridBagConstraints);
        jPanel.add(this.blockSizeSlider);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 17, 0);
        jLabel = new JLabel("Line size: ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 17, 0);
        gridBagLayout.setConstraints(this.lineSizeLbl, gridBagConstraints);
        jPanel.add(this.lineSizeLbl);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2, ++n, 2, 1, 0.0, 0.0, 17, 0);
        this.lineSizeSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.lineSizeSlider.setSnapToTicks(true);
        gridBagLayout.setConstraints(this.lineSizeSlider, gridBagConstraints);
        jPanel.add(this.lineSizeSlider);
        return jPanel;
    }

    JPanel buildTranslationPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 0;
        JPanel jPanel = new JPanel(gridBagLayout);
        Util.buildConstraints(gridBagConstraints, n2, n++, 1, 1, 1.0, 0.0, 17, 2);
        gridBagLayout.setConstraints(this.useStartPositionChbx, gridBagConstraints);
        jPanel.add(this.useStartPositionChbx);
        Util.buildConstraints(gridBagConstraints, n2, n++, 1, 1, 1.0, 0.0, 17, 2);
        this.obeyStopCodonsChbx.setSelected(false);
        gridBagLayout.setConstraints(this.obeyStopCodonsChbx, gridBagConstraints);
        jPanel.add(this.obeyStopCodonsChbx);
        return jPanel;
    }

    JPanel buildContentPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 0;
        JPanel jPanel = new JPanel(gridBagLayout);
        Util.buildConstraints(gridBagConstraints, n2, n++, 1, 1, 1.0, 0.0, 10, 2);
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.mFormatSpecField.setBackground(Color.white);
        gridBagLayout.setConstraints(this.mFormatSpecField, gridBagConstraints);
        jPanel.add((Component)this.mFormatSpecField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2, n++, 1, 1, 1.0, 0.0, 10, 0);
        gridBagLayout.setConstraints(this.legendBtn, gridBagConstraints);
        jPanel.add((Component)this.legendBtn, gridBagConstraints);
        return jPanel;
    }

    void wireUI() {
        this.useStartPositionChbx.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PublishPanel.this.preferences.putBoolean("useCursorAsStart", PublishPanel.this.useStartPositionChbx.isSelected());
                PublishPanel.this.writeIt();
            }
        });
        this.obeyStopCodonsChbx.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PublishPanel.this.preferences.putBoolean("obeyStopCodons", PublishPanel.this.obeyStopCodonsChbx.isSelected());
                PublishPanel.this.writeIt();
            }
        });
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.setChanged(documentEvent.getDocument());
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.setChanged(documentEvent.getDocument());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.setChanged(documentEvent.getDocument());
            }

            private void setChanged(Document document) {
                PublishPanel.this.preferences.put("format", PublishPanel.this.mFormatSpecField.getText());
                PublishPanel.this.writeIt();
            }
        };
        this.mFormatSpecField.getDocument().addDocumentListener(documentListener);
        this.blockSizeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = PublishPanel.this.blockSizeSlider.getValue();
                String string = n == 21 ? "No blocks" : Integer.toString(n);
                PublishPanel.this.blockSizeLbl.setText(string);
                PublishPanel.this.preferences.putInt("blockSize", n);
                PublishPanel.this.writeIt();
            }
        });
        this.lineSizeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PublishPanel.this.lineSizeLbl.setText(Integer.toString(PublishPanel.this.lineSizeSlider.getValue()));
                PublishPanel.this.preferences.putInt("lineSize", PublishPanel.this.lineSizeSlider.getValue());
                PublishPanel.this.writeIt();
            }
        });
        this.legendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PublishPanel.this.publishLegend == null) {
                    PublishPanel.this.publishLegend = new PublishLegend(PublishPanel.this);
                }
                PublishPanel.this.publishLegend.setVisible(true);
            }
        });
    }

    void setContentString(String string) {
        this.mFormatSpecField.setText(string);
    }

    void useDefaultContentString() {
        String string = this.preferences.get("format", defaultContentString);
        this.mFormatSpecField.setText(string);
    }

    void writeIt() {
        if (this.sequence == null) {
            return;
        }
        if (this.sequence.isProtein()) {
            this.writeToOutputArea("Publish currently uses nucleic acid sequences only.");
            return;
        }
        if (this.workThread != null) {
            this.workThread.interrupt();
        }
        this.workThread = new Thread(){

            public void run() {
                int n = PublishPanel.this.blockSizeSlider.getValue();
                int n2 = PublishPanel.this.lineSizeSlider.getValue();
                int n3 = n2 / n;
                if (n == 21) {
                    n = n2;
                    n3 = 1;
                }
                int n4 = 1;
                if (PublishPanel.this.useStartPositionChbx.isSelected()) {
                    n4 = PublishPanel.this.sequencePosition + 1;
                }
                String string = PublishPanel.this.mFormatSpecField.getText();
                String string2 = "";
                if (n > 0 && n3 > 0 && string.length() > 0 && n4 > 0) {
                    Publish publish = new Publish(n, n3);
                    if (PublishPanel.this.selection != null) {
                        publish.setSequence(PublishPanel.this.sequence.getSequence().substring(PublishPanel.this.selection[0], PublishPanel.this.selection[1]));
                    } else {
                        publish.setSequence(PublishPanel.this.sequence.getSequence());
                    }
                    publish.setFormat(string);
                    if (PublishPanel.this.selection != null) {
                        n4 = PublishPanel.this.selection[0] > n4 ? 1 : (n4 -= PublishPanel.this.selection[0] + 1);
                    } else {
                        publish.setTranslateFrom(n4);
                    }
                    publish.setUseStopCodons(PublishPanel.this.obeyStopCodonsChbx.isSelected());
                    string2 = publish.format();
                }
                PublishPanel.this.writeToOutputArea(string2);
                PublishPanel.this.workThread = null;
            }
        };
        try {
            this.workThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    void writeToOutputArea(final String string) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PublishPanel.this.outputArea.selectAll();
                    PublishPanel.this.outputArea.replaceSelection(string);
                    PublishPanel.this.outputArea.setCaretPosition(0);
                }
            });
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void printPanel() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sequence.getUID()).append("\n");
        stringBuffer.append(this.sequence.getTitle()).append("\n\n");
        stringBuffer.append(this.outputArea.getText());
        PanelPrinter panelPrinter = new PanelPrinter(stringBuffer.toString());
        panelPrinter.setPointSize(9);
        panelPrinter.print();
    }

    public void savePanel() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sequence.getUID()).append("\n");
        stringBuffer.append(this.sequence.getTitle()).append("\n\n");
        stringBuffer.append(this.outputArea.getText());
        String string = this.sequence != null ? this.sequence.getUID() : "";
        Frame frame = Util.thisFrame(this);
        SequenceAnalysis.saveText(frame, stringBuffer.toString(), string + "-Publish.txt");
    }
}

