/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.LEDSegment;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;

class SevenSegmentDisplay
extends JPanel {
    private LEDSegment[] segments = new LEDSegment[8];
    private int data;
    private boolean[] segmentsOn = new boolean[8];

    SevenSegmentDisplay(int displayNumber) {
        for (char c = 'a'; c <= 'g'; c = (char)(c + '\u0001')) {
            this.segments[c - 97] = new LEDSegment(c);
        }
        this.segments[7] = new LEDSegment('p');
        this.setAllSegmentsOff();
        this.setBackground(Color.BLACK);
        this.setLayout(new GridBagLayout());
        this.setToolTipText("display " + displayNumber);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.segments[0], gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.add((Component)this.segments[1], gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        this.add((Component)this.segments[2], gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        this.add((Component)this.segments[3], gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.add((Component)this.segments[4], gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.segments[5], gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.add((Component)this.segments[6], gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 4;
        this.add((Component)this.segments[7], gbc);
    }

    void setSize(boolean small) {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].setSize(small);
        }
    }

    void write(int data) {
        this.data = data;
    }

    void turnOn() {
        for (int i = 0; i < this.segmentsOn.length; ++i) {
            this.segmentsOn[i] = (this.data >> i & 1) == 0;
        }
    }

    void turnOff() {
        this.setAllSegmentsOff();
    }

    void updateGraphics() {
        for (int i = 0; i < this.segmentsOn.length; ++i) {
            this.segments[i].turnOn(this.segmentsOn[i]);
        }
    }

    private void setAllSegmentsOff() {
        for (int i = 0; i < this.segmentsOn.length; ++i) {
            this.segmentsOn[i] = false;
        }
    }
}

