/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.pccx.BasicExternalNodeBasedCoverageExtender;
import org.forester.pccx.Coverage;
import org.forester.pccx.CoverageCalculator;
import org.forester.pccx.ExternalNodeBasedCoverageMethod;
import org.forester.pccx.ExternalNodeBasedCoverageMethodOptions;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;

public class TestPccx {
    private static final double ZERO_DIFF = 1.0E-6;

    private static boolean isEqual(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-6;
    }

    public static boolean test() {
        return TestPccx.testExternalNodeBasedCoverage();
    }

    private static boolean testExternalNodeBasedCoverage() {
        try {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny = phylogenyFactory.create("((((A:0.1,B:0.7):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)", new NHXParser())[0];
            ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList.add(phylogeny);
            arrayList2.add("A");
            arrayList2.add("A");
            ExternalNodeBasedCoverageMethodOptions externalNodeBasedCoverageMethodOptions = new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.BranchCountingBasedScoringMethod");
            CoverageCalculator coverageCalculator = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), externalNodeBasedCoverageMethodOptions);
            Coverage coverage = coverageCalculator.calculateCoverage(arrayList, arrayList2, false);
            if (!TestPccx.isEqual(coverage.getScore(), 0.31719576719576714)) {
                return false;
            }
            arrayList2.add("B");
            arrayList2.add("B");
            coverage = coverageCalculator.calculateCoverage(arrayList, arrayList2, false);
            if (!TestPccx.isEqual(coverage.getScore(), 0.3727513227513228)) {
                return false;
            }
            arrayList2.add("G");
            coverage = coverageCalculator.calculateCoverage(arrayList, arrayList2, false);
            if (!TestPccx.isEqual(coverage.getScore(), 0.5370370370370371)) {
                return false;
            }
            arrayList2.add("E");
            coverage = coverageCalculator.calculateCoverage(arrayList, arrayList2, false);
            if (!TestPccx.isEqual(coverage.getScore(), 0.6481481481481483)) {
                return false;
            }
            arrayList2.add("X");
            coverage = coverageCalculator.calculateCoverage(arrayList, arrayList2, false);
            if (!TestPccx.isEqual(coverage.getScore(), 0.7407407407407408)) {
                return false;
            }
            arrayList2.add("C");
            arrayList2.add("C");
            arrayList2.add("C");
            coverage = coverageCalculator.calculateCoverage(arrayList, arrayList2, false);
            if (!TestPccx.isEqual(coverage.getScore(), 0.8148148148148149)) {
                return false;
            }
            arrayList2.add("D");
            coverage = coverageCalculator.calculateCoverage(arrayList, arrayList2, false);
            if (!TestPccx.isEqual(coverage.getScore(), 0.8888888888888888)) {
                return false;
            }
            arrayList2.add("F");
            coverage = coverageCalculator.calculateCoverage(arrayList, arrayList2, false);
            if (!TestPccx.isEqual(coverage.getScore(), 0.9444444444444444)) {
                return false;
            }
            arrayList2.add("H");
            coverage = coverageCalculator.calculateCoverage(arrayList, arrayList2, false);
            if (!TestPccx.isEqual(coverage.getScore(), 1.0)) {
                return false;
            }
            BasicExternalNodeBasedCoverageExtender basicExternalNodeBasedCoverageExtender = new BasicExternalNodeBasedCoverageExtender();
            List<String> list = basicExternalNodeBasedCoverageExtender.find(arrayList, null, 0, new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.BranchCountingBasedScoringMethod"), null);
            if (!list.get(0).equals("X")) {
                return false;
            }
            if (!list.get(1).equals("A")) {
                return false;
            }
            if (!list.get(2).equals("E")) {
                return false;
            }
            if (!list.get(3).equals("G")) {
                return false;
            }
            if (!list.get(4).equals("C")) {
                return false;
            }
            if (!list.get(5).equals("D")) {
                return false;
            }
            if (!list.get(6).equals("B")) {
                return false;
            }
            if (!list.get(7).equals("F")) {
                return false;
            }
            if (!list.get(8).equals("H")) {
                return false;
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add("A");
            arrayList3.add("X");
            arrayList3.add("H");
            arrayList3.add("C");
            list = basicExternalNodeBasedCoverageExtender.find(arrayList, arrayList3, 0, new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.BranchCountingBasedScoringMethod"), null);
            if (!list.get(0).equals("E")) {
                return false;
            }
            if (!list.get(1).equals("D")) {
                return false;
            }
            if (!list.get(2).equals("B")) {
                return false;
            }
            if (!list.get(3).equals("F")) {
                return false;
            }
            if (!list.get(4).equals("G")) {
                return false;
            }
            Phylogeny phylogeny2 = phylogenyFactory.create("((((A:0.1,B:0.7):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)", new NHXParser())[0];
            Phylogeny phylogeny3 = phylogenyFactory.create("((((A:0.1,B:0.1):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)", new NHXParser())[0];
            Phylogeny phylogeny4 = phylogenyFactory.create("((((A:0.1,B:0.05):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,X:2.0)", new NHXParser())[0];
            ArrayList<Phylogeny> arrayList4 = new ArrayList<Phylogeny>();
            ArrayList<String> arrayList5 = new ArrayList<String>();
            arrayList4.add(phylogeny2);
            arrayList4.add(phylogeny3);
            arrayList4.add(phylogeny4);
            arrayList5.add("A");
            arrayList5.add("A");
            ExternalNodeBasedCoverageMethodOptions externalNodeBasedCoverageMethodOptions2 = new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.BranchLengthBasedScoringMethod");
            CoverageCalculator coverageCalculator2 = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), externalNodeBasedCoverageMethodOptions2);
            Coverage coverage2 = coverageCalculator2.calculateCoverage(arrayList4, arrayList5, false);
            if (!TestPccx.isEqual(coverage2.getScore(), 0.6999131832738648)) {
                return false;
            }
            arrayList5.add("C");
            coverage2 = coverageCalculator2.calculateCoverage(arrayList4, arrayList5, false);
            if (!TestPccx.isEqual(coverage2.getScore(), 0.7099393017337181)) {
                return false;
            }
            arrayList5.add("E");
            coverage2 = coverageCalculator2.calculateCoverage(arrayList4, arrayList5, false);
            if (!TestPccx.isEqual(coverage2.getScore(), 0.9193662070896815)) {
                return false;
            }
            ExternalNodeBasedCoverageMethodOptions externalNodeBasedCoverageMethodOptions3 = new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.LogBranchLengthBasedScoringMethod");
            CoverageCalculator coverageCalculator3 = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), externalNodeBasedCoverageMethodOptions3);
            Coverage coverage3 = coverageCalculator3.calculateCoverage(arrayList4, arrayList5, false);
            if (!TestPccx.isEqual(coverage3.getScore(), 0.8534252108361485)) {
                return false;
            }
            Phylogeny phylogeny5 = phylogenyFactory.create("((((A:0.1,B:0.7):0.2,C:1.0):2.0,D:1.7):1.3,((E:0.3,F:0.4):1.1,(G:0.5,H:0.6):1.2):1.4,((((I:0.1,J:0.7):0.2,K:1.0):2.0,L:1.7):1.3,((M:0.3,N:0.4,O:0.1,P:0.2):1.1,(Q:0.5,R:0.6):1.2):1.4,S:2.0):2.0)", new NHXParser())[0];
            ArrayList<Phylogeny> arrayList6 = new ArrayList<Phylogeny>();
            ArrayList<String> arrayList7 = new ArrayList<String>();
            arrayList6.add(phylogeny5);
            arrayList7.add("A");
            arrayList7.add("B");
            arrayList7.add("N");
            arrayList7.add("O");
            ExternalNodeBasedCoverageMethodOptions externalNodeBasedCoverageMethodOptions4 = new ExternalNodeBasedCoverageMethodOptions("org.forester.pccx.BranchCountingBasedScoringMethod");
            CoverageCalculator coverageCalculator4 = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), externalNodeBasedCoverageMethodOptions4);
            coverageCalculator4.calculateCoverage(arrayList6, arrayList7, true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

