/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nexus;

import java.io.BufferedReader;
import java.io.IOException;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.io.parsers.nexus.NexusFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.parsers.util.PhylogenyParserException;

public class NexusBinaryStatesMatrixParser {
    private Object _nexus_source;
    private CharacterStateMatrix<CharacterStateMatrix.BinaryStates> _matrix;
    private int _nchar;
    private int _ntax;

    public CharacterStateMatrix<CharacterStateMatrix.BinaryStates> getMatrix() {
        return this._matrix;
    }

    public int getNChar() {
        return this._nchar;
    }

    private Object getNexusSource() {
        return this._nexus_source;
    }

    public int getNTax() {
        return this._ntax;
    }

    public void parse() throws IOException {
        String string;
        this.reset();
        BufferedReader bufferedReader = ParserUtils.createReader(this.getNexusSource(), "UTF-8");
        boolean bl = false;
        int n = 0;
        int n2 = -1;
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            if ((string = string.trim()).length() <= 0 || string.startsWith("#") || string.startsWith(">")) continue;
            if (string.toLowerCase().indexOf("NChar".toLowerCase()) >= 0) {
                int n3 = string.toLowerCase().indexOf("NChar".toLowerCase());
                string2 = string.toLowerCase().substring(n3 + 6);
                string2 = string2.replace(';', ' ').trim();
                this.setNChar(Integer.parseInt(string2));
                continue;
            }
            if (string.toLowerCase().indexOf("NTax".toLowerCase()) >= 0) {
                int n4 = string.toLowerCase().indexOf("NTax".toLowerCase());
                string2 = string.toLowerCase().substring(n4 + 5);
                string2 = string2.replace(';', ' ').trim();
                this.setNTax(Integer.parseInt(string2));
                continue;
            }
            if (string.toLowerCase().startsWith("Matrix".toLowerCase())) {
                bl = true;
                if (this.getNTax() < 1) {
                    throw new NexusFormatException("did not encounter NTax");
                }
                if (this.getNChar() < 1) {
                    throw new NexusFormatException("did not encounter NChar");
                }
                if (this.getMatrix() != null) {
                    throw new NexusFormatException("more than one matrix present");
                }
                this.setMatrix(new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(this.getNTax(), this.getNChar()));
                continue;
            }
            if (string.toLowerCase().startsWith("End;".toLowerCase())) {
                bl = false;
                continue;
            }
            if (!bl) continue;
            String[] stringArray = string.split("\\s+");
            string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            if (string3.endsWith(";")) {
                bl = false;
                string3 = string3.substring(0, string3.length() - 1);
            }
            char[] cArray = string3.toCharArray();
            this.getMatrix().setIdentifier(n, string2);
            int n5 = 0;
            for (char c : cArray) {
                if (c == CharacterStateMatrix.BinaryStates.PRESENT.toChar()) {
                    try {
                        this.getMatrix().setState(n, n5, CharacterStateMatrix.BinaryStates.PRESENT);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new NexusFormatException("problem at line " + string + " [" + arrayIndexOutOfBoundsException + "]");
                    }
                } else if (c == CharacterStateMatrix.BinaryStates.ABSENT.toChar()) {
                    try {
                        this.getMatrix().setState(n, n5, CharacterStateMatrix.BinaryStates.ABSENT);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new NexusFormatException("problem at line " + string + " [" + arrayIndexOutOfBoundsException + "]");
                    }
                } else {
                    throw new NexusFormatException("illegal state " + c);
                }
                ++n5;
            }
            if (n2 > 0 && n2 != n5) {
                throw new NexusFormatException("unequal number of characters at line " + string);
            }
            n2 = n5;
            ++n;
        }
    }

    private void reset() {
        this.setMatrix(null);
        this.setNChar(-1);
        this.setNTax(-1);
    }

    private void setMatrix(CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix) {
        this._matrix = characterStateMatrix;
    }

    private void setNChar(int n) {
        this._nchar = n;
    }

    private void setNTax(int n) {
        this._ntax = n;
    }

    public void setSource(Object object) throws PhylogenyParserException, IOException {
        if (object == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        this._nexus_source = object;
    }
}

