/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.forester.development.AbstractRenderer;
import org.forester.development.MsaRenderer;

public class ResidueRenderer
extends AbstractRenderer {
    static final Color EMPTY_COLOR = new Color(250, 0, 250);
    static final Color POSITIVE_COLOR = new Color(250, 0, 250);
    static final Color NEGATIVE_COLOR = new Color(250, 0, 250);
    static final Color NULL_COLOR = new Color(50, 50, 50);
    static final int DISTANCE_OVAL_BORDER = 1;
    static final int SIZE_LIMIT = 7;
    private static final long serialVersionUID = -2331160296913478874L;
    private final char _value;
    private Color _wellColor;
    private boolean _isMarked;
    private boolean _isSelected;
    private final MsaRenderer _parentPlateRenderer;

    public ResidueRenderer(char c, MsaRenderer msaRenderer) {
        this._value = c;
        this._parentPlateRenderer = msaRenderer;
        this.setIsSelected(false);
        this.setIsMarked(false);
        this.setStatus((byte)0);
    }

    private double calcFactor(double d, double d2) {
        return (d2 - d) / 255.0;
    }

    private Color calcWellColor(double d, double d2, double d3, Color color, Color color2) {
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        double d4 = 255.0 * (d - d2) / (d3 - d2);
        int n = (int)((double)color.getRed() + d4 * this.calcFactor(color.getRed(), color2.getRed()));
        int n2 = (int)((double)color.getGreen() + d4 * this.calcFactor(color.getGreen(), color2.getGreen()));
        int n3 = (int)((double)color.getBlue() + d4 * this.calcFactor(color.getBlue(), color2.getBlue()));
        return new Color(n, n2, n3);
    }

    private Color calcWellColor(double d, double d2, double d3, double d4, Color color, Color color2, Color color3) {
        if (color3 == null) {
            return this.calcWellColor(d, d2, d3, color, color2);
        }
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        if (d < d4) {
            double d5 = 255.0 * (d - d2) / (d4 - d2);
            int n = (int)((double)color.getRed() + d5 * this.calcFactor(color.getRed(), color3.getRed()));
            int n2 = (int)((double)color.getGreen() + d5 * this.calcFactor(color.getGreen(), color3.getGreen()));
            int n3 = (int)((double)color.getBlue() + d5 * this.calcFactor(color.getBlue(), color3.getBlue()));
            return new Color(n, n2, n3);
        }
        if (d > d4) {
            double d6 = 255.0 * (d - d4) / (d3 - d4);
            int n = (int)((double)color3.getRed() + d6 * this.calcFactor(color3.getRed(), color2.getRed()));
            int n4 = (int)((double)color3.getGreen() + d6 * this.calcFactor(color3.getGreen(), color2.getGreen()));
            int n5 = (int)((double)color3.getBlue() + d6 * this.calcFactor(color3.getBlue(), color2.getBlue()));
            return new Color(n, n4, n5);
        }
        return color3;
    }

    public double getDataValue() {
        return this._value;
    }

    @Override
    public MsaRenderer getParentPlateRenderer() {
        return this._parentPlateRenderer;
    }

    public Color getWellColor() {
        return this._wellColor;
    }

    public boolean isMarked() {
        return this._isMarked;
    }

    @Override
    public boolean isSelected() {
        return this._isSelected;
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getWellSize() - 1;
        int n2 = n - 1;
        int n3 = n2 - 1 + 1;
        int n4 = n3 - 2;
        int n5 = this.getX() + 1;
        int n6 = this.getY() + 1;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        if (this.isMarked()) {
            graphics2D.setColor(AbstractRenderer.MARKED_COLOR);
        } else {
            graphics2D.setColor(AbstractRenderer.DEFAULT_COLOR);
        }
        graphics2D.drawRect(this.getX(), this.getY(), n, n);
        graphics2D.setColor(this.getWellColor());
        if (this.isMarked() || this.isSelected()) {
            graphics2D.fillRect(this.getX() + 1, this.getY() + 1, n2, n2);
        } else {
            graphics2D.fillRect(this.getX() + 1 - 1, this.getY() + 1 - 1, n2 + 2, n2 + 2);
        }
    }

    public void resetWellColor(double d, double d2, Color color, Color color2) {
        this.setWellColor(this.calcWellColor(this.getDataValue(), d, d2, color, color2));
    }

    public void resetWellColor(double d, double d2, double d3, Color color, Color color2, Color color3) {
        this.setWellColor(this.calcWellColor(this.getDataValue(), d, d2, d3, color, color2, color3));
    }

    public void setIsMarked(boolean bl) {
        this._isMarked = bl;
    }

    @Override
    public void setIsSelected(boolean bl) {
        this._isSelected = bl;
    }

    private void setWellColor(Color color) {
        this._wellColor = color;
    }
}

