/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.io.File;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.util.ForesterUtil;

public final class Archaeopteryx {
    public static MainFrame createApplication(Phylogeny phylogeny) {
        Phylogeny[] phylogenyArray = new Phylogeny[]{phylogeny};
        return Archaeopteryx.createApplication(phylogenyArray, "", "");
    }

    public static MainFrame createApplication(Phylogeny phylogeny, Configuration configuration, String string) {
        Phylogeny[] phylogenyArray = new Phylogeny[]{phylogeny};
        return MainFrameApplication.createInstance(phylogenyArray, configuration, string);
    }

    public static MainFrame createApplication(Phylogeny[] phylogenyArray) {
        return Archaeopteryx.createApplication(phylogenyArray, "", "");
    }

    public static MainFrame createApplication(Phylogeny[] phylogenyArray, String string, String string2) {
        return MainFrameApplication.createInstance(phylogenyArray, string, string2);
    }

    public static void main(String[] stringArray) {
        Object object;
        Phylogeny[] phylogenyArray = null;
        String string = null;
        Configuration configuration = null;
        File file = null;
        try {
            int n = 0;
            if (stringArray.length == 0) {
                configuration = new Configuration(null, false, false, true);
            } else if (stringArray.length > 0) {
                if (stringArray[0].startsWith("-c")) {
                    string = stringArray[1];
                    n += 2;
                }
                if (stringArray[0].startsWith("-open")) {
                    ++n;
                }
                configuration = new Configuration(string, false, false, true);
                if (stringArray.length > n) {
                    PhylogenyParser phylogenyParser;
                    file = new File(stringArray[n]);
                    object = ForesterUtil.isReadableFile(file);
                    if (!ForesterUtil.isEmpty((String)object)) {
                        ForesterUtil.fatalError("Archaeopteryx", (String)object);
                    }
                    boolean bl = false;
                    PhylogenyParser phylogenyParser2 = ParserUtils.createParserDependingOnFileType(file, configuration.isValidatePhyloXmlAgainstSchema());
                    if (phylogenyParser2 instanceof NHXParser) {
                        bl = true;
                        phylogenyParser = (NHXParser)phylogenyParser2;
                        ((NHXParser)phylogenyParser).setReplaceUnderscores(configuration.isReplaceUnderscoresInNhParsing());
                        ((NHXParser)phylogenyParser).setIgnoreQuotes(false);
                        ((NHXParser)phylogenyParser).setTaxonomyExtraction(configuration.getTaxonomyExtraction());
                    } else if (phylogenyParser2 instanceof NexusPhylogeniesParser) {
                        bl = true;
                        phylogenyParser = (NexusPhylogeniesParser)phylogenyParser2;
                        ((NexusPhylogeniesParser)phylogenyParser).setReplaceUnderscores(configuration.isReplaceUnderscoresInNhParsing());
                        ((NexusPhylogeniesParser)phylogenyParser).setIgnoreQuotes(false);
                    } else if (phylogenyParser2 instanceof PhyloXmlParser) {
                        MainFrameApplication.warnIfNotPhyloXmlValidation(configuration);
                    }
                    phylogenyArray = PhylogenyMethods.readPhylogenies(phylogenyParser2, file);
                    if (bl && configuration.isInternalNumberAreConfidenceForNhParsing()) {
                        for (PhylogenyParser phylogenyParser3 : phylogenyArray) {
                            PhylogenyMethods.transferInternalNodeNamesToConfidence((Phylogeny)((Object)phylogenyParser3), "");
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            ForesterUtil.fatalError("Archaeopteryx", "failed to start: " + exception.getLocalizedMessage());
        }
        String string2 = "";
        if (file != null) {
            string2 = file.getName();
        }
        object = null;
        if (phylogenyArray != null && phylogenyArray.length > 0) {
            object = new File(".");
        }
        try {
            MainFrameApplication.createInstance(phylogenyArray, configuration, string2, object);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            AptxUtil.outOfMemoryError(outOfMemoryError);
        }
        catch (Exception exception) {
            AptxUtil.unexpectedException(exception);
        }
        catch (Error error) {
            AptxUtil.unexpectedError(error);
        }
    }
}

