/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.go.GoTerm;
import org.forester.go.OBOparser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class obo_tool {
    private static final String IDS_TO_NAMES_SUFFIX = "_ids_to_names";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String GO_ID_TO_NAME_OPTION = "i";
    private static final String PRG_NAME = "obo_tool";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "2008.11.26";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/";

    public static void main(String[] stringArray) {
        String string;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2) || stringArray.length == 0) {
            obo_tool.printHelp();
            System.exit(0);
        }
        if (stringArray.length < 3) {
            System.out.println();
            System.out.println("[obo_tool] incorrect number of arguments");
            System.out.println();
            obo_tool.printHelp();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(GO_ID_TO_NAME_OPTION);
        if (commandLineArguments.getNumberOfNames() != 2) {
            System.out.println();
            System.out.println("[obo_tool] incorrect number of arguments");
            System.out.println();
            obo_tool.printHelp();
            System.exit(-1);
        }
        if ((string = commandLineArguments.validateAllowedOptionsAsString(arrayList)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
        }
        boolean bl = false;
        if (commandLineArguments.isOptionSet(GO_ID_TO_NAME_OPTION)) {
            bl = true;
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        OBOparser oBOparser = new OBOparser(file, OBOparser.ReturnType.BASIC_GO_TERM);
        List<GoTerm> list = null;
        try {
            list = oBOparser.parse();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.toString());
        }
        ForesterUtil.programMessage(PRG_NAME, "successfully read in " + list.size() + " GO terms from [" + file + "]");
        if (bl) {
            File file3 = new File(file2 + IDS_TO_NAMES_SUFFIX);
            String string2 = ForesterUtil.isWritableFile(file3);
            if (!ForesterUtil.isEmpty(string2)) {
                ForesterUtil.fatalError(PRG_NAME, string2);
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
                for (GoTerm goTerm : list) {
                    bufferedWriter.write(goTerm.getGoId().getId());
                    bufferedWriter.write("\t");
                    bufferedWriter.write(goTerm.getDefinition());
                    bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
                }
                ((Writer)bufferedWriter).close();
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.toString());
            }
            ForesterUtil.programMessage(PRG_NAME, "wrote: [" + file3 + "]");
        }
        ForesterUtil.programMessage(PRG_NAME, "OK");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("obo_tool <options> <obo infile> <outfile>");
        System.out.println();
        System.out.println(" options: ");
        System.out.println();
        System.out.println("   -i: output GO id to name map file");
        System.out.println();
    }
}

