/*
 * Decompiled with CFR 0.152.
 */
package org.forester.analysis;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import javax.swing.JOptionPane;
import org.forester.analysis.AncestralTaxonomyInferenceException;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.tools.AncestralTaxonomyInferrer;
import org.forester.archaeopteryx.tools.RunnableProcess;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;
import org.forester.util.TaxonomyUtil;
import org.forester.ws.seqdb.SequenceDbWsTools;
import org.forester.ws.seqdb.UniProtTaxonomy;

public final class TaxonomyDataManager
extends RunnableProcess {
    private static final int MAX_CACHE_SIZE = 100000;
    private static final int MAX_TAXONOMIES_TO_RETURN = 2000;
    private static final HashMap<String, UniProtTaxonomy> _sn_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _lineage_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _code_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _cn_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _id_up_cache_map = new HashMap();
    private final Phylogeny _phy;
    private final MainFrameApplication _mf;
    private final TreePanel _treepanel;
    private final boolean _delete;
    private final boolean _allow_simple_names;

    public TaxonomyDataManager(MainFrameApplication mainFrameApplication, TreePanel treePanel, Phylogeny phylogeny) {
        this._phy = phylogeny;
        this._mf = mainFrameApplication;
        this._treepanel = treePanel;
        this._delete = false;
        this._allow_simple_names = false;
    }

    public TaxonomyDataManager(MainFrameApplication mainFrameApplication, TreePanel treePanel, Phylogeny phylogeny, boolean bl, boolean bl2) {
        this._phy = phylogeny;
        this._mf = mainFrameApplication;
        this._treepanel = treePanel;
        this._delete = bl;
        this._allow_simple_names = bl2;
    }

    static synchronized void clearCachesIfTooLarge() {
        if (TaxonomyDataManager.getSnTaxCacheMap().size() > 100000) {
            TaxonomyDataManager.getSnTaxCacheMap().clear();
        }
        if (TaxonomyDataManager.getLineageTaxCacheMap().size() > 100000) {
            TaxonomyDataManager.getLineageTaxCacheMap().clear();
        }
        if (TaxonomyDataManager.getCnTaxCacheMap().size() > 100000) {
            TaxonomyDataManager.getCnTaxCacheMap().clear();
        }
        if (TaxonomyDataManager.getCodeTaxCacheMap().size() > 100000) {
            TaxonomyDataManager.getCodeTaxCacheMap().clear();
        }
        if (TaxonomyDataManager.getIdTaxCacheMap().size() > 100000) {
            TaxonomyDataManager.getIdTaxCacheMap().clear();
        }
    }

    static final synchronized HashMap<String, UniProtTaxonomy> getCnTaxCacheMap() {
        return _cn_up_cache_map;
    }

    static final synchronized HashMap<String, UniProtTaxonomy> getCodeTaxCacheMap() {
        return _code_up_cache_map;
    }

    static final synchronized HashMap<String, UniProtTaxonomy> getIdTaxCacheMap() {
        return _id_up_cache_map;
    }

    static final synchronized HashMap<String, UniProtTaxonomy> getLineageTaxCacheMap() {
        return _lineage_up_cache_map;
    }

    static final synchronized HashMap<String, UniProtTaxonomy> getSnTaxCacheMap() {
        return _sn_up_cache_map;
    }

    private static final UniProtTaxonomy obtainTaxonomy(HashMap<String, UniProtTaxonomy> hashMap, Object object, QUERY_TYPE qUERY_TYPE) throws IOException, AncestralTaxonomyInferenceException {
        if (hashMap.containsKey(object)) {
            return hashMap.get(object).copy();
        }
        List<UniProtTaxonomy> list = null;
        switch (qUERY_TYPE) {
            case ID: {
                list = TaxonomyDataManager.getTaxonomiesFromId((String)object);
                break;
            }
            case CODE: {
                list = TaxonomyDataManager.getTaxonomiesFromTaxonomyCode((String)object);
                break;
            }
            case SN: {
                list = TaxonomyDataManager.getTaxonomiesFromScientificName((String)object);
                break;
            }
            case CN: {
                list = TaxonomyDataManager.getTaxonomiesFromCommonName((String)object);
                break;
            }
            case LIN: {
                return TaxonomyDataManager.obtainUniProtTaxonomyFromLineage((List)object);
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (list != null && list.size() == 1) {
            UniProtTaxonomy uniProtTaxonomy = list.get(0);
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getScientificName())) {
                TaxonomyDataManager.getSnTaxCacheMap().put(uniProtTaxonomy.getScientificName(), uniProtTaxonomy);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCode())) {
                TaxonomyDataManager.getCodeTaxCacheMap().put(uniProtTaxonomy.getCode(), uniProtTaxonomy);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCommonName())) {
                TaxonomyDataManager.getCnTaxCacheMap().put(uniProtTaxonomy.getCommonName(), uniProtTaxonomy);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getId())) {
                TaxonomyDataManager.getIdTaxCacheMap().put(uniProtTaxonomy.getId(), uniProtTaxonomy);
            }
            return uniProtTaxonomy;
        }
        return null;
    }

    private static final List<UniProtTaxonomy> getTaxonomiesFromCommonName(String string) throws IOException {
        return SequenceDbWsTools.getTaxonomiesFromCommonNameStrict(string, 2000);
    }

    private static final List<UniProtTaxonomy> getTaxonomiesFromId(String string) throws IOException {
        return SequenceDbWsTools.getTaxonomiesFromId(string, 2000);
    }

    private static final List<UniProtTaxonomy> getTaxonomiesFromScientificName(String string) throws IOException {
        if (string.equalsIgnoreCase("Bacteria") || string.equalsIgnoreCase("Archaea") || string.equalsIgnoreCase("Viruses") || string.equalsIgnoreCase("Eukaryota") || string.equalsIgnoreCase("x")) {
            ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
            arrayList.add(UniProtTaxonomy.createSpecialFromScientificName(string));
            return arrayList;
        }
        return SequenceDbWsTools.getTaxonomiesFromScientificNameStrict(string, 2000);
    }

    private static final List<UniProtTaxonomy> getTaxonomiesFromTaxonomyCode(String string) throws IOException {
        if (string.indexOf("XX") == 3 && TaxonomyUtil.isHasTaxIdFromFakeTaxCode(string) || string.equals("SPHAR")) {
            int n = TaxonomyUtil.getTaxIdFromFakeTaxCode(string);
            return SequenceDbWsTools.getTaxonomiesFromId(String.valueOf(n), 2000);
        }
        return SequenceDbWsTools.getTaxonomiesFromTaxonomyCode(string, 2000);
    }

    static final boolean isHasAppropriateId(Taxonomy taxonomy) {
        return taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue()) && (taxonomy.getIdentifier().getProvider().equalsIgnoreCase("ncbi") || taxonomy.getIdentifier().getProvider().equalsIgnoreCase("uniprot") || taxonomy.getIdentifier().getProvider().equalsIgnoreCase("uniprotkb"));
    }

    private static final synchronized SortedSet<String> obtainDetailedTaxonomicInformation(Phylogeny phylogeny, boolean bl, boolean bl2) throws IOException, AncestralTaxonomyInferenceException {
        TaxonomyDataManager.clearCachesIfTooLarge();
        TreeSet<String> treeSet = new TreeSet<String>();
        ArrayList<PhylogenyNode> arrayList = null;
        if (bl) {
            arrayList = new ArrayList<PhylogenyNode>();
        }
        Iterator<PhylogenyNode> iterator = phylogeny.iteratorPostorder();
        while (iterator.hasNext()) {
            PhylogenyNode phylogenyNode = iterator.next();
            QUERY_TYPE qUERY_TYPE = null;
            Taxonomy taxonomy = null;
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                taxonomy = phylogenyNode.getNodeData().getTaxonomy();
            } else if ((!bl2 || ForesterUtil.isEmpty(phylogenyNode.getName())) && phylogenyNode.isExternal()) {
                if (!ForesterUtil.isEmpty(phylogenyNode.getName())) {
                    treeSet.add(phylogenyNode.getName());
                } else {
                    treeSet.add(phylogenyNode.toString());
                }
                if (bl) {
                    arrayList.add(phylogenyNode);
                }
            }
            UniProtTaxonomy uniProtTaxonomy = null;
            if ((taxonomy == null || !TaxonomyDataManager.isHasAppropriateId(taxonomy) && ForesterUtil.isEmpty(taxonomy.getScientificName()) && ForesterUtil.isEmpty(taxonomy.getTaxonomyCode()) && ForesterUtil.isEmpty(taxonomy.getCommonName())) && (!bl2 || ForesterUtil.isEmpty(phylogenyNode.getName()))) continue;
            uniProtTaxonomy = taxonomy != null && (TaxonomyDataManager.isHasAppropriateId(taxonomy) || !ForesterUtil.isEmpty(taxonomy.getScientificName()) || !ForesterUtil.isEmpty(taxonomy.getTaxonomyCode()) || !ForesterUtil.isEmpty(taxonomy.getCommonName())) ? TaxonomyDataManager.obtainUniProtTaxonomy(taxonomy, null, qUERY_TYPE) : TaxonomyDataManager.obtainUniProtTaxonomy(phylogenyNode.getName(), qUERY_TYPE);
            if (uniProtTaxonomy != null) {
                if (taxonomy == null) {
                    taxonomy = new Taxonomy();
                    phylogenyNode.getNodeData().addTaxonomy(taxonomy);
                }
                TaxonomyDataManager.updateTaxonomy(qUERY_TYPE, phylogenyNode, taxonomy, uniProtTaxonomy);
                continue;
            }
            if (taxonomy != null) {
                treeSet.add(taxonomy.toString());
            } else {
                treeSet.add(phylogenyNode.getName());
            }
            if (!bl || !phylogenyNode.isExternal()) continue;
            arrayList.add(phylogenyNode);
        }
        if (bl) {
            for (PhylogenyNode phylogenyNode : arrayList) {
                phylogeny.deleteSubtree(phylogenyNode, true);
            }
            phylogeny.externalNodesHaveChanged();
            phylogeny.clearHashIdToNodeMap();
            phylogeny.recalculateNumberOfExternalDescendants(true);
        }
        return treeSet;
    }

    public static final UniProtTaxonomy obtainUniProtTaxonomy(Taxonomy taxonomy, Object object, QUERY_TYPE qUERY_TYPE) throws IOException, AncestralTaxonomyInferenceException {
        if (taxonomy == null) {
            throw new IllegalArgumentException("illegal attempt to use empty taxonomy object");
        }
        if (TaxonomyDataManager.isHasAppropriateId(taxonomy)) {
            object = taxonomy.getIdentifier().getValue();
            qUERY_TYPE = QUERY_TYPE.ID;
            return TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getIdTaxCacheMap(), object, qUERY_TYPE);
        }
        if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            if (!ForesterUtil.isEmpty(taxonomy.getLineage())) {
                object = taxonomy.getLineage();
                qUERY_TYPE = QUERY_TYPE.LIN;
                return TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getLineageTaxCacheMap(), object, qUERY_TYPE);
            }
            object = taxonomy.getScientificName();
            qUERY_TYPE = QUERY_TYPE.SN;
            return TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getSnTaxCacheMap(), object, qUERY_TYPE);
        }
        if (!ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            object = taxonomy.getTaxonomyCode();
            qUERY_TYPE = QUERY_TYPE.CODE;
            return TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getCodeTaxCacheMap(), object, qUERY_TYPE);
        }
        object = taxonomy.getCommonName();
        qUERY_TYPE = QUERY_TYPE.CN;
        return TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getCnTaxCacheMap(), object, qUERY_TYPE);
    }

    public static final UniProtTaxonomy obtainUniProtTaxonomy(String string, QUERY_TYPE qUERY_TYPE) throws IOException, AncestralTaxonomyInferenceException {
        String string2;
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("illegal attempt to use empty simple name");
        }
        UniProtTaxonomy uniProtTaxonomy = null;
        String string3 = ParserUtils.extractTaxonomyCodeFromNodeName(string, NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
        if (!ForesterUtil.isEmpty(string3)) {
            qUERY_TYPE = QUERY_TYPE.CODE;
            uniProtTaxonomy = TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getCodeTaxCacheMap(), string3, qUERY_TYPE);
        }
        if (uniProtTaxonomy == null && !ForesterUtil.isEmpty(string2 = ParserUtils.extractScientificNameFromNodeName(string))) {
            qUERY_TYPE = QUERY_TYPE.SN;
            uniProtTaxonomy = TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getSnTaxCacheMap(), string2, qUERY_TYPE);
        }
        if (uniProtTaxonomy == null && !ForesterUtil.isEmpty(string2 = ParserUtils.extractUniprotTaxonomyIdFromNodeName(string, NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED))) {
            qUERY_TYPE = QUERY_TYPE.ID;
            uniProtTaxonomy = TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getIdTaxCacheMap(), string2, qUERY_TYPE);
        }
        if (uniProtTaxonomy == null) {
            string2 = "";
            Matcher matcher = ParserUtils.TAXOMONY_SN_PATTERN_GENUS.matcher(string);
            if (matcher.matches()) {
                string2 = matcher.group(1);
            }
            if (!ForesterUtil.isEmpty(string2)) {
                qUERY_TYPE = QUERY_TYPE.SN;
                uniProtTaxonomy = TaxonomyDataManager.obtainTaxonomy(TaxonomyDataManager.getSnTaxCacheMap(), string2, qUERY_TYPE);
            }
        }
        return uniProtTaxonomy;
    }

    static final UniProtTaxonomy obtainUniProtTaxonomyFromLineage(List<String> list) throws AncestralTaxonomyInferenceException, IOException {
        String string = ForesterUtil.stringListToString(list, ">");
        if (TaxonomyDataManager.getLineageTaxCacheMap().containsKey(string)) {
            return TaxonomyDataManager.getLineageTaxCacheMap().get(string).copy();
        }
        ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
        List<UniProtTaxonomy> list2 = TaxonomyDataManager.getTaxonomiesFromScientificName(list.get(list.size() - 1));
        if (list2 != null && list2.size() > 0) {
            UniProtTaxonomy uniProtTaxonomy2;
            for (UniProtTaxonomy uniProtTaxonomy2 : list2) {
                boolean bl = true;
                for (int i = 0; i < list.size(); ++i) {
                    if (i != uniProtTaxonomy2.getLineage().size() && list.get(i).equalsIgnoreCase(uniProtTaxonomy2.getLineage().get(i))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                arrayList.add(uniProtTaxonomy2);
            }
            if (arrayList.isEmpty()) {
                throw new AncestralTaxonomyInferenceException("lineage \"" + ForesterUtil.stringListToString(list, " > ") + "\" not found");
            }
            int n = Integer.MAX_VALUE;
            uniProtTaxonomy2 = null;
            for (UniProtTaxonomy uniProtTaxonomy3 : arrayList) {
                int n2 = uniProtTaxonomy3.getLineage().size();
                if (n2 >= n) continue;
                n = n2;
                uniProtTaxonomy2 = uniProtTaxonomy3;
            }
            TaxonomyDataManager.getLineageTaxCacheMap().put(string, uniProtTaxonomy2);
            if (!ForesterUtil.isEmpty(uniProtTaxonomy2.getScientificName())) {
                TaxonomyDataManager.getSnTaxCacheMap().put(uniProtTaxonomy2.getScientificName(), uniProtTaxonomy2);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy2.getCode())) {
                TaxonomyDataManager.getCodeTaxCacheMap().put(uniProtTaxonomy2.getCode(), uniProtTaxonomy2);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy2.getCommonName())) {
                TaxonomyDataManager.getCnTaxCacheMap().put(uniProtTaxonomy2.getCommonName(), uniProtTaxonomy2);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy2.getId())) {
                TaxonomyDataManager.getIdTaxCacheMap().put(uniProtTaxonomy2.getId(), uniProtTaxonomy2);
            }
            return uniProtTaxonomy2;
        }
        throw new AncestralTaxonomyInferenceException("taxonomy \"" + list.get(list.size() - 1) + "\" not found");
    }

    private static final synchronized void updateTaxonomy(QUERY_TYPE qUERY_TYPE, PhylogenyNode phylogenyNode, Taxonomy taxonomy, UniProtTaxonomy uniProtTaxonomy) throws PhyloXmlDataFormatException {
        if (qUERY_TYPE != QUERY_TYPE.SN && !ForesterUtil.isEmpty(uniProtTaxonomy.getScientificName()) && ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            taxonomy.setScientificName(uniProtTaxonomy.getScientificName());
        }
        if (phylogenyNode.isExternal() && qUERY_TYPE != QUERY_TYPE.CODE && !ForesterUtil.isEmpty(uniProtTaxonomy.getCode()) && ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            taxonomy.setTaxonomyCode(uniProtTaxonomy.getCode());
        }
        if (qUERY_TYPE != QUERY_TYPE.CN && !ForesterUtil.isEmpty(uniProtTaxonomy.getCommonName()) && ForesterUtil.isEmpty(taxonomy.getCommonName())) {
            taxonomy.setCommonName(uniProtTaxonomy.getCommonName());
        }
        if (!ForesterUtil.isEmpty(uniProtTaxonomy.getSynonym()) && !taxonomy.getSynonyms().contains(uniProtTaxonomy.getSynonym())) {
            taxonomy.getSynonyms().add(uniProtTaxonomy.getSynonym());
        }
        if (!ForesterUtil.isEmpty(uniProtTaxonomy.getRank()) && ForesterUtil.isEmpty(taxonomy.getRank())) {
            try {
                taxonomy.setRank(uniProtTaxonomy.getRank().toLowerCase());
            }
            catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                taxonomy.setRank("");
            }
        }
        if (qUERY_TYPE != QUERY_TYPE.ID && !ForesterUtil.isEmpty(uniProtTaxonomy.getId()) && (taxonomy.getIdentifier() == null || ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue()))) {
            taxonomy.setIdentifier(new Identifier(uniProtTaxonomy.getId(), "uniprot"));
        }
        if (uniProtTaxonomy.getLineage() != null) {
            taxonomy.setLineage(new ArrayList<String>());
            for (String string : uniProtTaxonomy.getLineage()) {
                if (ForesterUtil.isEmpty(string)) continue;
                taxonomy.getLineage().add(string);
            }
        }
    }

    private final void execute() {
        this.start(this._mf, "taxonomy data");
        SortedSet<String> sortedSet = null;
        try {
            sortedSet = TaxonomyDataManager.obtainDetailedTaxonomicInformation(this._phy, this._delete, this._allow_simple_names);
        }
        catch (UnknownHostException unknownHostException) {
            JOptionPane.showMessageDialog(this._mf, "Could not connect to \"" + this.getBaseUrl() + "\"", "Network error during taxonomic information gathering", 0);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, iOException.toString(), "Failed to obtain taxonomic information", 0);
            return;
        }
        catch (AncestralTaxonomyInferenceException ancestralTaxonomyInferenceException) {
            ancestralTaxonomyInferenceException.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, ancestralTaxonomyInferenceException.toString(), "Failed to obtain taxonomic information", 0);
            return;
        }
        finally {
            this.end(this._mf);
        }
        if (this._phy == null || this._phy.isEmpty()) {
            try {
                JOptionPane.showMessageDialog(this._mf, "None of the external node taxonomies could be resolved", "Taxonomy Tool Failed", 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this._treepanel.setTree(this._phy);
        this._mf.showWhole();
        this._treepanel.setEdited(true);
        if (sortedSet != null && sortedSet.size() > 0) {
            int n = sortedSet.size();
            boolean bl = false;
            if (n > 20) {
                bl = true;
                n = 20;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Not all taxonomies could be resolved.\n");
            if (sortedSet.size() == 1) {
                if (this._delete) {
                    stringBuffer.append("The following taxonomy was not found and deleted (if external):\n");
                } else {
                    stringBuffer.append("The following taxonomy was not found:\n");
                }
            } else if (this._delete) {
                stringBuffer.append("The following taxonomies were not found and deleted (if external) (total: " + sortedSet.size() + "):\n");
            } else {
                stringBuffer.append("The following taxonomies were not found (total: " + sortedSet.size() + "):\n");
            }
            int n2 = 0;
            for (String string : sortedSet) {
                if (n2 > 19) break;
                stringBuffer.append(string);
                stringBuffer.append("\n");
                ++n2;
            }
            if (bl) {
                stringBuffer.append("...");
            }
            try {
                JOptionPane.showMessageDialog(this._mf, stringBuffer.toString(), "Taxonomy Tool Completed", 2);
            }
            catch (Exception exception) {}
        } else {
            try {
                JOptionPane.showMessageDialog(this._mf, "Taxonomy tool successfully completed", "Taxonomy Tool Completed", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final String getBaseUrl() {
        return AncestralTaxonomyInferrer.getBaseUrl();
    }

    @Override
    public void run() {
        this.execute();
    }

    static enum QUERY_TYPE {
        CODE,
        SN,
        CN,
        ID,
        LIN;

    }
}

