/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;

public class StackedChartDataModelConstraints
implements ChartDataModelConstraints {
    protected AbstractChartDataModel model;
    protected int axis;
    protected boolean allowManualColScale = true;

    public StackedChartDataModelConstraints(AbstractChartDataModel model, int axis) {
        this.model = model;
        this.axis = axis;
    }

    public StackedChartDataModelConstraints(AbstractChartDataModel model, int axis, boolean allowManualColScale) {
        this(model, axis);
        this.allowManualColScale = allowManualColScale;
    }

    @Override
    public Number getMaximumValue() {
        return this.getMaximumY();
    }

    @Override
    public Number getMaximumY() {
        int minimumDataSetLength = Integer.MAX_VALUE;
        double maxvalue = 0.0;
        double minvalue = 0.0;
        double columnminvalue = Double.MAX_VALUE;
        double columnmaxvalue = Double.MIN_VALUE;
        int i = 0;
        while (i < this.model.getDataSetNumber()) {
            minimumDataSetLength = Math.min(minimumDataSetLength, this.model.getDataSetLength(i));
            ++i;
        }
        double value = 0.0;
        int i2 = 0;
        while (i2 < minimumDataSetLength) {
            int j = 0;
            while (j < this.model.getDataSetNumber()) {
                value = this.model.getValueAt(j, i2).doubleValue();
                if (value < 0.0) {
                    columnminvalue += value;
                } else {
                    columnmaxvalue += value;
                }
                ++j;
            }
            minvalue = Math.min(columnminvalue, minvalue);
            columnminvalue = 0.0;
            maxvalue = Math.max(columnmaxvalue, maxvalue);
            columnmaxvalue = 0.0;
            ++i2;
        }
        if (this.model.getOrderedValues(0).size() == 0 || maxvalue == 0.0 && minvalue == 0.0) {
            return new Integer(1);
        }
        if (this.model.isManualScale()) {
            return new Double(Math.max(this.model.getManualMaximumValue().doubleValue(), maxvalue));
        }
        if (this.model.isAutoScale()) {
            if (minvalue / maxvalue > 0.95) {
                return new Double(ChartUtilities.performAutoScale(minvalue / 2.0, 2.0 * maxvalue)[1]);
            }
            return new Double(ChartUtilities.performAutoScale(minvalue, maxvalue)[1]);
        }
        return new Double(maxvalue);
    }

    @Override
    public Number getMinimumValue() {
        return this.getMinimumY();
    }

    @Override
    public Number getMinimumY() {
        int minimumDataSetLength = Integer.MAX_VALUE;
        double maxvalue = 0.0;
        double minvalue = 0.0;
        double columnmaxvalue = 0.0;
        double columnminvalue = 0.0;
        int i = 0;
        while (i < this.model.getDataSetNumber()) {
            minimumDataSetLength = Math.min(minimumDataSetLength, this.model.getDataSetLength(i));
            ++i;
        }
        double value = 0.0;
        int i2 = 0;
        while (i2 < minimumDataSetLength) {
            int j = 0;
            while (j < this.model.getDataSetNumber()) {
                value = this.model.getValueAt(j, i2).doubleValue();
                if (value < 0.0) {
                    columnminvalue += value;
                } else {
                    columnmaxvalue += value;
                }
                ++j;
            }
            minvalue = Math.min(columnminvalue, minvalue);
            columnminvalue = 0.0;
            maxvalue = Math.max(columnmaxvalue, maxvalue);
            columnmaxvalue = 0.0;
            ++i2;
        }
        if (this.model.getOrderedValues(0).size() == 0 || maxvalue == 0.0 && minvalue == 0.0) {
            return new Integer(0);
        }
        if (this.model.isManualScale()) {
            return new Double(Math.min(this.model.getManualMinimumValue().doubleValue(), minvalue));
        }
        if (this.model.isAutoScale()) {
            if (minvalue / maxvalue > 0.95) {
                return new Double(ChartUtilities.performAutoScale(minvalue / 2.0, 2.0 * maxvalue)[0]);
            }
            return new Double(ChartUtilities.performAutoScale(minvalue, maxvalue)[0]);
        }
        return new Double(minvalue);
    }

    @Override
    public double getMinimumColumnValue() {
        Number x = this.getMinimumX();
        if (x == null) {
            return 0.0;
        }
        return x.doubleValue();
    }

    @Override
    public Number getMinimumX() {
        if (this.model.isManualScale() && this.allowManualColScale) {
            return this.model.getManualMinimumX();
        }
        if (this.model.isAutoScale()) {
            return new Double(ChartUtilities.performAutoScale(this.model.getFirstColumnValue(), this.model.getLastColumnValue())[0]);
        }
        return new Double(this.model.getFirstColumnValue());
    }

    @Override
    public double getMaximumColumnValue() {
        Number x = this.getMaximumX();
        if (x == null) {
            return 0.0;
        }
        return x.doubleValue();
    }

    @Override
    public Number getMaximumX() {
        if (this.model.isManualScale() && this.allowManualColScale) {
            return this.model.getManualMaximumX();
        }
        if (this.model.isAutoScale()) {
            return new Double(ChartUtilities.performAutoScale(this.model.getFirstColumnValue(), this.model.getLastColumnValue())[1]);
        }
        return new Double(this.model.getLastColumnValue());
    }
}

