/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import FCSalyzer.FCS.FCS_data;
import FCSalyzer.GUI.mainFrame;
import FCSalyzer.Transform.Compensation;
import FCSalyzer.Transform.LogicleTransformer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class formatDatafilesDialog
implements ActionListener,
WindowListener {
    private final JDialog theDialog = new JDialog();
    private final JButton CLOSE_Button = new JButton("Close Dialog");
    private final JTabbedPane tabHolder = new JTabbedPane(1, 1);
    private static final String CLOSE = "CLOSE";
    private mainFrame theFrame;
    private transformationObject transObj;
    private compensationObject compObj;
    private parameterObject paramObj;
    private multiplyObject multiplyObj;

    public formatDatafilesDialog(mainFrame paramFrame, List<FCS_data> documentDatafiles, List<Compensation> documentComps, String docName) {
        this.theFrame = paramFrame;
        this.theDialog.setModal(false);
        this.theDialog.setTitle("Format datafiles in: " + docName);
        this.theDialog.setLayout(new BorderLayout());
        this.theDialog.addWindowListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.CLOSE_Button);
        this.CLOSE_Button.setActionCommand(CLOSE);
        this.CLOSE_Button.addActionListener(this);
        this.theDialog.add((Component)buttonPanel, "South");
        this.theDialog.setDefaultCloseOperation(2);
        this.theDialog.add((Component)this.tabHolder, "Center");
        this.transObj = new transformationObject(paramFrame, documentDatafiles);
        this.compObj = new compensationObject(paramFrame, documentDatafiles, documentComps);
        this.paramObj = new parameterObject(paramFrame, documentDatafiles);
        this.multiplyObj = new multiplyObject(paramFrame, documentDatafiles);
        this.tabHolder.insertTab("Transformation", null, this.transObj.getPanel(), "Set display transformation", 0);
        this.tabHolder.insertTab("Compensation", null, this.compObj.getPanel(), "Set compensations", 1);
        this.tabHolder.insertTab("Parameter Descriptions", null, this.paramObj.getPanel(), "Set parameter descriptions", 2);
        this.tabHolder.insertTab("Parameter Multipliers", null, this.multiplyObj.getPanel(), "Set parameter multiplication", 3);
        this.theDialog.setLocationByPlatform(true);
        this.theDialog.setSize(800, 500);
    }

    public boolean showDialog() {
        this.theDialog.setVisible(true);
        return true;
    }

    private void closeDialog() {
        this.theDialog.setVisible(false);
        this.transObj.clear();
        this.compObj.clear();
        this.paramObj.clear();
        this.theDialog.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(CLOSE)) {
            this.closeDialog();
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.closeDialog();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private class transformTableCellRenderer
    implements TableCellRenderer {
        private JLabel toDraw = new JLabel();
        private boolean top = true;

        public transformTableCellRenderer() {
            this.toDraw.setBorder(new transBorder());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean bl = this.top = row % 2 == 0;
            if (value == null) {
                this.toDraw.setText(null);
            } else {
                this.toDraw.setText(" " + value.toString());
            }
            return this.toDraw;
        }

        private class transBorder
        implements Border {
            private Insets theInsets = new Insets(0, 0, 0, 0);

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                if (transformTableCellRenderer.this.top) {
                    g.setColor(Color.darkGray);
                    g.drawLine(x, y, x + width, y);
                }
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return this.theInsets;
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        }
    }

    private class multiplyObject
    implements TableModel,
    ComponentListener {
        public JPanel thePanel = new JPanel();
        private mainFrame theFrame;
        private List<FCS_data> theFiles;
        private List<TableModelListener> theListeners = new ArrayList<TableModelListener>();
        private JCheckBox allParams = new JCheckBox("Apply changes to all parameters");
        private JCheckBox allFiles = new JCheckBox("Apply changes to all files");
        private JTable theTable;
        private JScrollPane theScroller;

        public multiplyObject(mainFrame paramFrame, List<FCS_data> documentDatafiles) {
            this.theFrame = paramFrame;
            this.theFiles = documentDatafiles;
            this.thePanel.setLayout(new BorderLayout());
            this.theTable = new JTable(this);
            this.theTable.setRowHeight(this.theTable.getRowHeight() + 5);
            this.theTable.setSelectionMode(0);
            this.theTable.setDefaultRenderer(String.class, new transformTableCellRenderer());
            this.theTable.setShowHorizontalLines(false);
            this.theTable.setBorder(BorderFactory.createLineBorder(Color.darkGray));
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.theTable.getColumn(this.theTable.getColumnName(i)).setMinWidth(100);
            }
            this.theScroller = new JScrollPane(this.theTable);
            this.theScroller.addComponentListener(this);
            this.thePanel.add((Component)this.theScroller, "Center");
            JPanel checkBoxHolders = new JPanel(new GridLayout(3, 1));
            checkBoxHolders.add(new JLabel("<html><i>Please note: the raw data is multiplied <u>before</u> compensation!</i></html>"));
            checkBoxHolders.add(this.allFiles);
            checkBoxHolders.add(this.allParams);
            this.thePanel.add((Component)checkBoxHolders, "North");
        }

        public JPanel getPanel() {
            return this.thePanel;
        }

        public void clear() {
            this.theFrame = null;
            this.theFiles = null;
        }

        @Override
        public int getRowCount() {
            return this.theFiles.size() * 2;
        }

        @Override
        public int getColumnCount() {
            int count = 0;
            for (FCS_data theFile : this.theFiles) {
                if (count >= theFile.getRawParameterCount()) continue;
                count = theFile.getRawParameterCount();
            }
            return count + 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "File";
            }
            return "Parameter " + (columnIndex - 1);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return false;
            }
            if (rowIndex % 2 == 0) {
                return false;
            }
            return columnIndex - 1 < this.theFiles.get(rowIndex / 2).getRawParameterCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FCS_data theFile = this.theFiles.get(rowIndex / 2);
            if (rowIndex % 2 == 0) {
                if (columnIndex == 0) {
                    return theFile.getDataFileName();
                }
                if (columnIndex - 1 < theFile.getRawParameterCount()) {
                    return theFile.getParameterLabel(columnIndex - 1);
                }
                return null;
            }
            if (columnIndex == 0) {
                return theFile.getSampleDescription();
            }
            if (columnIndex - 1 < theFile.getRawParameterCount()) {
                return String.valueOf(theFile.getMultiplyBy(columnIndex - 1));
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            FCS_data[] filesToUse;
            String newValue = aValue.toString();
            --columnIndex;
            if (this.allFiles.isSelected()) {
                filesToUse = new FCS_data[this.theFiles.size()];
                for (int i = 0; i < filesToUse.length; ++i) {
                    filesToUse[i] = this.theFiles.get(i);
                }
            } else {
                filesToUse = new FCS_data[]{this.theFiles.get(rowIndex / 2)};
            }
            for (FCS_data currentFile : filesToUse) {
                int currentMult;
                if (columnIndex >= currentFile.getRawParameterCount()) continue;
                int newMult = currentMult = currentFile.getMultiplyBy(columnIndex);
                try {
                    newMult = Integer.decode(newValue.trim());
                }
                catch (NumberFormatException m) {
                    newMult = currentMult;
                }
                if (newMult == currentMult) continue;
                if (this.allParams.isSelected()) {
                    for (int i = 0; i < currentFile.getRawParameterCount(); ++i) {
                        currentFile.setMultiplyBy(i, newMult);
                    }
                } else {
                    currentFile.setMultiplyBy(columnIndex, newMult);
                }
                this.theFrame.transformationChanged(currentFile);
            }
            this.tableChanged();
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.theListeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.theListeners.remove(l);
        }

        public void tableChanged() {
            for (TableModelListener l : this.theListeners) {
                l.tableChanged(new TableModelEvent(this));
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (this.theScroller.getSize().width <= this.getColumnCount() * 100) {
                this.theTable.setAutoResizeMode(0);
            } else {
                this.theTable.setAutoResizeMode(4);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    private class parameterObject
    implements TableModel,
    ComponentListener {
        public JPanel thePanel = new JPanel();
        private mainFrame theFrame;
        private List<FCS_data> theFiles;
        private List<TableModelListener> theListeners = new ArrayList<TableModelListener>();
        private JCheckBox allFiles = new JCheckBox("Apply changes to all files");
        private JTable theTable;
        private JScrollPane theScroller;

        public parameterObject(mainFrame paramFrame, List<FCS_data> documentDatafiles) {
            this.theFrame = paramFrame;
            this.theFiles = documentDatafiles;
            this.thePanel.setLayout(new BorderLayout());
            this.theTable = new JTable(this);
            this.theTable.setRowHeight(this.theTable.getRowHeight() + 5);
            this.theTable.setSelectionMode(0);
            this.theTable.setDefaultRenderer(String.class, new transformTableCellRenderer());
            this.theTable.setShowHorizontalLines(false);
            this.theTable.setBorder(BorderFactory.createLineBorder(Color.darkGray));
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.theTable.getColumn(this.theTable.getColumnName(i)).setMinWidth(100);
            }
            this.theScroller = new JScrollPane(this.theTable);
            this.theScroller.addComponentListener(this);
            this.thePanel.add((Component)this.theScroller, "Center");
            JPanel checkBoxHolders = new JPanel(new GridLayout(1, 1));
            checkBoxHolders.add(this.allFiles);
            this.thePanel.add((Component)checkBoxHolders, "North");
        }

        public JPanel getPanel() {
            return this.thePanel;
        }

        public void clear() {
            this.theFrame = null;
            this.theFiles = null;
        }

        @Override
        public int getRowCount() {
            return this.theFiles.size() * 2;
        }

        @Override
        public int getColumnCount() {
            int count = 0;
            for (FCS_data theFile : this.theFiles) {
                if (count >= theFile.getTotalParameterCount()) continue;
                count = theFile.getTotalParameterCount();
            }
            return count + 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "File";
            }
            return "Parameter " + (columnIndex - 1);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return false;
            }
            if (rowIndex % 2 == 0) {
                return false;
            }
            return columnIndex - 1 < this.theFiles.get(rowIndex / 2).getTotalParameterCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FCS_data theFile = this.theFiles.get(rowIndex / 2);
            if (rowIndex % 2 == 0) {
                if (columnIndex == 0) {
                    return theFile.getDataFileName();
                }
                if (columnIndex - 1 < theFile.getTotalParameterCount()) {
                    return theFile.getParameterName(columnIndex - 1);
                }
                return null;
            }
            if (columnIndex == 0) {
                return theFile.getSampleDescription();
            }
            if (columnIndex - 1 < theFile.getTotalParameterCount()) {
                return theFile.getParameterDesc(columnIndex - 1);
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            FCS_data[] filesToUse;
            String newValue = aValue.toString();
            --columnIndex;
            if (this.allFiles.isSelected()) {
                filesToUse = new FCS_data[this.theFiles.size()];
                for (int i = 0; i < filesToUse.length; ++i) {
                    filesToUse[i] = this.theFiles.get(i);
                }
            } else {
                filesToUse = new FCS_data[]{this.theFiles.get(rowIndex / 2)};
            }
            for (FCS_data currentFile : filesToUse) {
                if (columnIndex >= currentFile.getTotalParameterCount()) continue;
                currentFile.setParameterDesc(columnIndex, newValue);
                this.theFrame.labelsChanged(currentFile);
            }
            this.tableChanged();
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.theListeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.theListeners.remove(l);
        }

        public void tableChanged() {
            for (TableModelListener l : this.theListeners) {
                l.tableChanged(new TableModelEvent(this));
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (this.theScroller.getSize().width <= this.getColumnCount() * 100) {
                this.theTable.setAutoResizeMode(0);
            } else {
                this.theTable.setAutoResizeMode(4);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    private class compensationObject
    implements ActionListener,
    ListSelectionListener,
    TableModel {
        JPanel thePanel;
        mainFrame theFrame;
        List<FCS_data> theFiles;
        List<Compensation> theComps;
        JList compList;
        JTable fileTable;
        JTable compEdit;
        JLabel currentFileLabel = new JLabel();
        JTextField compName = new JTextField();
        JList parameterList = new JList();
        compensationMatrixTable matrixTableModel = new compensationMatrixTable();
        JComboBox compsChooser = new JComboBox();
        String[] columnNames = new String[]{"File", "Compensation"};
        ArrayList<TableModelListener> listeners = new ArrayList();
        boolean isUpdating = false;

        public compensationObject(mainFrame paramFrame, List<FCS_data> documentDatafiles, List<Compensation> documentComps) {
            this.theFrame = paramFrame;
            this.theFiles = documentDatafiles;
            this.theComps = documentComps;
            JPanel compensationPanel = new JPanel();
            JPanel filePanel = new JPanel();
            JSplitPane split = new JSplitPane(0, true, compensationPanel, filePanel);
            split.setDividerLocation(200);
            compensationPanel.setLayout(new BorderLayout());
            JPanel holder = new JPanel(new BorderLayout());
            compensationPanel.add((Component)holder, "West");
            Compensation[] docList = new Compensation[documentComps.size()];
            for (int i = 0; i < docList.length; ++i) {
                docList[i] = documentComps.get(i);
            }
            this.compList = new JList<Compensation>(docList);
            this.compList.addListSelectionListener(this);
            holder.add((Component)new JScrollPane(this.compList), "Center");
            JPanel buttons = new JPanel(new GridLayout(2, 1));
            JButton newC = new JButton("New compensation");
            newC.setActionCommand("newC");
            newC.addActionListener(this);
            JButton delC = new JButton("Delete compensation");
            delC.setActionCommand("delC");
            delC.addActionListener(this);
            buttons.add(newC);
            buttons.add(delC);
            holder.add((Component)buttons, "South");
            JPanel matrixHolder = new JPanel(new BorderLayout());
            this.currentFileLabel.setHorizontalAlignment(0);
            this.currentFileLabel.setText("<html><i>to see parameter labels, select a file in the list below:</i></html>");
            matrixHolder.add((Component)this.currentFileLabel, "South");
            matrixHolder.add((Component)this.compName, "North");
            this.compName.addActionListener(this);
            this.compName.setActionCommand("changeName");
            JSplitPane spillOverHolder = new JSplitPane(1, true);
            spillOverHolder.setDividerLocation(150);
            JPanel paramHolder = new JPanel(new BorderLayout());
            paramHolder.add((Component)new JLabel("Parameter:"), "North");
            paramHolder.add((Component)new JScrollPane(this.parameterList), "Center");
            this.parameterList.addListSelectionListener(this);
            this.parameterList.setSelectionMode(0);
            spillOverHolder.add(paramHolder);
            JPanel compHolder = new JPanel(new BorderLayout());
            compHolder.add((Component)new JLabel("Spillover [%] into channel:"), "North");
            this.compEdit = new JTable(this.matrixTableModel);
            this.compEdit.setRowHeight(this.compEdit.getRowHeight() + 5);
            compValuesEditor cVE = new compValuesEditor();
            this.compEdit.getColumn(this.compEdit.getColumnName(1)).setCellEditor(cVE);
            compHolder.add((Component)new JScrollPane(this.compEdit), "Center");
            spillOverHolder.add(compHolder);
            matrixHolder.add((Component)spillOverHolder, "Center");
            compensationPanel.add((Component)matrixHolder, "Center");
            this.compsChooser.setEditable(false);
            this.compsChooser.addItem("none");
            for (int i = 0; i < this.theComps.size(); ++i) {
                this.compsChooser.addItem(this.theComps.get(i));
            }
            this.fileTable = new JTable(this);
            this.fileTable.setRowHeight(this.fileTable.getRowHeight() + 5);
            this.fileTable.getColumn(this.columnNames[1]).setCellEditor(new DefaultCellEditor(this.compsChooser));
            this.fileTable.setSelectionMode(0);
            this.fileTable.getSelectionModel().addListSelectionListener(this);
            filePanel.setLayout(new BorderLayout());
            filePanel.add(Box.createVerticalStrut(10), "North");
            filePanel.add(Box.createVerticalStrut(10), "South");
            filePanel.add(Box.createHorizontalStrut(40), "East");
            filePanel.add(Box.createHorizontalStrut(40), "West");
            filePanel.add((Component)new JScrollPane(this.fileTable), "Center");
            this.thePanel = new JPanel(new BorderLayout());
            this.thePanel.add((Component)split, "Center");
        }

        public JPanel getPanel() {
            return this.thePanel;
        }

        public void clear() {
            this.theFrame = null;
            this.theFiles = null;
            this.theComps = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("newC")) {
                if (this.theFiles.size() > 0) {
                    int i;
                    int selected = this.fileTable.getSelectedRow();
                    if (selected == -1) {
                        selected = 0;
                    }
                    this.isUpdating = true;
                    int paramC = this.theFiles.get(selected).getRawParameterCount();
                    Compensation newComp = Compensation.generateCompensation("new Compensation [" + paramC + "]", paramC);
                    this.theComps.add(newComp);
                    Compensation[] docList = new Compensation[this.theComps.size()];
                    for (i = 0; i < docList.length; ++i) {
                        docList[i] = this.theComps.get(i);
                    }
                    this.compList.setListData(docList);
                    this.compList.setSelectedIndex(docList.length - 1);
                    this.compsChooser.removeAllItems();
                    this.compsChooser.addItem("none");
                    for (i = 0; i < this.theComps.size(); ++i) {
                        this.compsChooser.addItem(this.theComps.get(i));
                    }
                    this.tableChanged();
                    this.isUpdating = false;
                    this.fileTable.setRowSelectionInterval(selected, selected);
                }
            } else if (e.getActionCommand().equals("delC")) {
                int selected = this.compList.getSelectedIndex();
                if (selected > -1) {
                    int i;
                    Compensation toDelete = this.theComps.get(selected);
                    this.theComps.remove(selected);
                    for (int i2 = 0; i2 < this.theFiles.size(); ++i2) {
                        if (this.theFiles.get(i2).getCompensation() != toDelete) continue;
                        this.theFiles.get(i2).removeComp(toDelete);
                        this.theFrame.transformationChanged(this.theFiles.get(i2));
                    }
                    this.isUpdating = true;
                    Compensation[] docList = new Compensation[this.theComps.size()];
                    for (i = 0; i < docList.length; ++i) {
                        docList[i] = this.theComps.get(i);
                    }
                    this.compList.setListData(docList);
                    this.compsChooser.removeAllItems();
                    this.compsChooser.addItem("none");
                    for (i = 0; i < this.theComps.size(); ++i) {
                        this.compsChooser.addItem(this.theComps.get(i));
                    }
                    this.tableChanged();
                    this.isUpdating = false;
                }
            } else if (e.getActionCommand().equals("changeName")) {
                int selected;
                Compensation toChange = null;
                if (!this.compName.getText().isEmpty() && (selected = this.compList.getSelectedIndex()) > -1) {
                    toChange = this.theComps.get(selected);
                    toChange.setName(this.compName.getText());
                    this.tableChanged();
                    this.compList.repaint();
                }
                if (toChange != null) {
                    this.compName.setText(toChange.toString());
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.theFiles.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.theFiles.get(rowIndex).getDataFileName();
            }
            Compensation temp = this.theFiles.get(rowIndex).getCompensation();
            if (temp != null) {
                return temp;
            }
            return "none";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (this.isUpdating) {
                return;
            }
            int index = this.compsChooser.getSelectedIndex() - 1;
            if (index == -1) {
                this.theFiles.get(rowIndex).removeComp(this.theFiles.get(rowIndex).getCompensation());
            } else {
                this.theFiles.get(rowIndex).setCompensation(this.theComps.get(this.compsChooser.getSelectedIndex() - 1));
            }
            this.theFrame.transformationChanged(this.theFiles.get(rowIndex));
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        public void tableChanged() {
            for (TableModelListener l : this.listeners) {
                l.tableChanged(new TableModelEvent(this));
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.compList) {
                Object selected = this.compList.getSelectedValue();
                int fileIndex = this.fileTable.getSelectedRow();
                if (fileIndex != -1) {
                    this.matrixTableModel.setCurrentFile(this.theFiles.get(fileIndex));
                }
                this.matrixTableModel.setCurrentComp(selected);
                if (selected != null) {
                    this.compName.setText(selected.toString());
                    String[] params = this.matrixTableModel.getParameterLabels();
                    int index = this.parameterList.getSelectedIndex();
                    this.parameterList.setListData(params);
                    if (index > -1) {
                        this.parameterList.setSelectedIndex(index);
                    } else {
                        this.parameterList.setSelectedIndex(0);
                    }
                } else {
                    this.compName.setText(null);
                    int index = this.parameterList.getSelectedIndex();
                    this.parameterList.setListData(new Object[0]);
                    if (index > -1) {
                        this.parameterList.setSelectedIndex(index);
                    } else {
                        this.parameterList.setSelectedIndex(0);
                    }
                }
                this.matrixTableModel.tableChanged();
            } else if (e.getSource() == this.parameterList) {
                this.compEdit.editingCanceled(null);
                this.matrixTableModel.tableChanged();
            } else if (e.getSource() instanceof ListSelectionModel) {
                if (this.fileTable.getSelectedRow() > -1) {
                    FCS_data selected = this.theFiles.get(this.fileTable.getSelectedRow());
                    this.currentFileLabel.setText("Parameter labels from: " + selected.getDataFileName());
                    this.matrixTableModel.setCurrentFile(selected);
                    String[] params = this.matrixTableModel.getParameterLabels();
                    int index = this.parameterList.getSelectedIndex();
                    this.parameterList.setListData(params);
                    if (index > -1) {
                        this.parameterList.setSelectedIndex(index);
                    } else {
                        this.parameterList.setSelectedIndex(0);
                    }
                } else {
                    this.currentFileLabel.setText("<html><i>to see parameter labels, select a file</i></html>");
                    this.matrixTableModel.setCurrentFile(null);
                    this.compName.setText(null);
                    String[] params = this.matrixTableModel.getParameterLabels();
                    int index = this.parameterList.getSelectedIndex();
                    this.parameterList.setListData(params);
                    if (index > -1) {
                        this.parameterList.setSelectedIndex(index);
                    } else {
                        this.parameterList.setSelectedIndex(0);
                    }
                }
            }
        }

        private class compValuesEditor
        extends AbstractCellEditor
        implements TableCellEditor,
        ChangeListener,
        ActionListener {
            private final JSplitPane theHolder;
            private final JTextField theInput;
            private final JSlider theSpinner;
            private HashSet numbers = new HashSet();
            private int currRow;
            private int currCol;

            public compValuesEditor() {
                this.numbers.add(Character.valueOf('0'));
                this.numbers.add(Character.valueOf('1'));
                this.numbers.add(Character.valueOf('2'));
                this.numbers.add(Character.valueOf('3'));
                this.numbers.add(Character.valueOf('4'));
                this.numbers.add(Character.valueOf('5'));
                this.numbers.add(Character.valueOf('6'));
                this.numbers.add(Character.valueOf('7'));
                this.numbers.add(Character.valueOf('8'));
                this.numbers.add(Character.valueOf('9'));
                this.theInput = new JTextField();
                this.theInput.addActionListener(this);
                this.theSpinner = new JSlider(0, 0, 10000, 0);
                this.theSpinner.setExtent(0);
                this.theSpinner.addChangeListener(this);
                this.theHolder = new JSplitPane(1, this.theInput, this.theSpinner);
                this.theHolder.setDividerLocation(50);
                this.theHolder.setDividerSize(0);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.currRow = row;
                this.currCol = column;
                int newV = 0;
                String n = "";
                if (value != null) {
                    n = value.toString();
                }
                this.theInput.setText(n);
                if (!n.isEmpty()) {
                    n = n.replaceAll("\\.", "");
                    newV = Integer.parseInt(n);
                }
                this.theSpinner.setValue(newV);
                return this.theHolder;
            }

            @Override
            public Object getCellEditorValue() {
                return this.theSpinner.getValue();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                int v = this.theSpinner.getValue();
                String aboveZero = v / 100 + ".";
                if ((v %= 100) < 10) {
                    this.theInput.setText(aboveZero + "0" + v);
                } else {
                    this.theInput.setText(aboveZero + v);
                }
                compensationObject.this.matrixTableModel.setValueAt(this.theSpinner.getValue(), this.currRow, this.currCol);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int newValue = 0;
                char[] nV = this.theInput.getText().toCharArray();
                String clean = "";
                int onePeriod = -1;
                for (int i = nV.length - 1; i > -1; --i) {
                    if (this.numbers.contains(Character.valueOf(nV[i]))) {
                        clean = nV[i] + clean;
                        continue;
                    }
                    if (onePeriod != -1 || nV[i] != '.') continue;
                    onePeriod = clean.length();
                }
                if (!clean.isEmpty()) {
                    if (onePeriod > 0) {
                        if (onePeriod == 1) {
                            newValue = Integer.parseInt(clean) * 10;
                        } else if (onePeriod == 2) {
                            newValue = Integer.parseInt(clean);
                        } else {
                            newValue = Integer.parseInt(clean);
                            int factor = (int)Math.pow(10.0, onePeriod - 2);
                            int rounded = newValue / factor;
                            int leftover = newValue % factor;
                            newValue = rounded;
                            if (leftover >= factor / 2) {
                                ++newValue;
                            }
                        }
                    } else {
                        newValue = Integer.parseInt(clean) * 100;
                    }
                }
                this.theSpinner.setValueIsAdjusting(true);
                this.theSpinner.setMaximum((newValue / 10000 + 1) * 10000);
                this.theSpinner.setValue(newValue);
                this.theSpinner.setValueIsAdjusting(false);
            }
        }

        private class compensationMatrixTable
        implements TableModel {
            private ArrayList<TableModelListener> listeners = new ArrayList();
            private Compensation currentComp;
            private FCS_data currentFile;
            private String[] parameterLabels = new String[0];

            public void setCurrentComp(Object newComp) {
                this.parameterLabels = new String[0];
                if (newComp == null) {
                    this.currentComp = null;
                }
                if (newComp instanceof Compensation) {
                    this.currentComp = (Compensation)newComp;
                    this.parameterLabels = new String[this.currentComp.getParamCount()];
                    for (int i = 0; i < this.parameterLabels.length; ++i) {
                        this.parameterLabels[i] = "Parameter #" + i;
                        if (this.currentFile == null || this.currentFile.getRawParameterCount() <= i) continue;
                        this.parameterLabels[i] = this.currentFile.getParameterLabel(i);
                    }
                }
                this.tableChanged();
            }

            public void setCurrentFile(FCS_data newFile) {
                this.currentFile = newFile;
                if (this.currentFile != null) {
                    this.parameterLabels = this.currentComp != null ? new String[this.currentComp.getParamCount()] : new String[0];
                    for (int i = 0; i < this.parameterLabels.length; ++i) {
                        this.parameterLabels[i] = "Parameter #" + i;
                        if (this.currentFile.getRawParameterCount() <= i) continue;
                        this.parameterLabels[i] = this.currentFile.getParameterLabel(i);
                    }
                }
                this.tableChanged();
            }

            public String[] getParameterLabels() {
                return this.parameterLabels;
            }

            @Override
            public int getRowCount() {
                return this.parameterLabels.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return "Spillover into";
                }
                return "Spillover [%]";
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                if (columnIndex < 1) {
                    return false;
                }
                return compensationObject.this.parameterList.getSelectedIndex() != rowIndex;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (this.currentComp != null) {
                    if (columnIndex == 0) {
                        return this.parameterLabels[rowIndex];
                    }
                    if (columnIndex == 1) {
                        int current = this.currentComp.getSpillover(rowIndex, compensationObject.this.parameterList.getSelectedIndex());
                        String aboveZero = current / 100 + ".";
                        if ((current %= 100) < 10) {
                            return aboveZero + "0" + current;
                        }
                        return aboveZero + current;
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex < 1) {
                    return;
                }
                int newValue = 0;
                if (aValue != null) {
                    newValue = (Integer)aValue;
                }
                this.currentComp.setSpillover(rowIndex, compensationObject.this.parameterList.getSelectedIndex(), newValue);
                compensationObject.this.theFrame.compensationChanged(this.currentComp);
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
                this.listeners.add(l);
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
                this.listeners.remove(l);
            }

            public void tableChanged() {
                for (TableModelListener l : this.listeners) {
                    l.tableChanged(new TableModelEvent(this));
                }
            }
        }
    }

    private class transformationObject
    implements TableModel,
    ComponentListener {
        public JPanel thePanel = new JPanel();
        private mainFrame theFrame;
        private List<FCS_data> theFiles;
        private String[] transDesc;
        private HashMap<String, Integer> transMap;
        private List<TableModelListener> theListeners = new ArrayList<TableModelListener>();
        private JCheckBox allParams = new JCheckBox("Apply changes to all parameters");
        private JCheckBox allFiles = new JCheckBox("Apply changes to all files");
        private JTable theTable;
        private JScrollPane theScroller;

        public transformationObject(mainFrame paramFrame, List<FCS_data> documentDatafiles) {
            this.theFrame = paramFrame;
            this.theFiles = documentDatafiles;
            this.thePanel.setLayout(new BorderLayout());
            this.transDesc = new String[LogicleTransformer.Zero_Ranges.length + 2];
            this.transDesc[0] = "linear";
            this.transDesc[1] = "log";
            this.transMap = new HashMap(this.transDesc.length);
            this.transMap.put(this.transDesc[0], 0);
            this.transMap.put(this.transDesc[1], 1);
            for (int i = 0; i < LogicleTransformer.Zero_Ranges.length; ++i) {
                String percent = LogicleTransformer.Zero_percentages[i];
                this.transDesc[i + 2] = "logicle:  (-" + percent + ")";
                this.transMap.put(this.transDesc[i + 2], i + 2);
            }
            this.theTable = new JTable(this);
            this.theTable.setRowHeight(this.theTable.getRowHeight() + 5);
            this.theTable.setSelectionMode(0);
            this.theTable.setDefaultRenderer(String.class, new transformTableCellRenderer());
            this.theTable.setShowHorizontalLines(false);
            this.theTable.setBorder(BorderFactory.createLineBorder(Color.darkGray));
            JComboBox<String> editorBox = new JComboBox<String>(this.transDesc);
            editorBox.setEditable(false);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.theTable.getColumn(this.theTable.getColumnName(i)).setMinWidth(100);
                this.theTable.getColumn(this.theTable.getColumnName(i)).setCellEditor(new DefaultCellEditor(editorBox));
            }
            this.theScroller = new JScrollPane(this.theTable);
            this.theScroller.addComponentListener(this);
            this.thePanel.add((Component)this.theScroller, "Center");
            JPanel checkBoxHolders = new JPanel(new GridLayout(2, 1));
            checkBoxHolders.add(this.allFiles);
            checkBoxHolders.add(this.allParams);
            this.thePanel.add((Component)checkBoxHolders, "North");
        }

        public JPanel getPanel() {
            return this.thePanel;
        }

        public void clear() {
            this.theFrame = null;
            this.theFiles = null;
        }

        @Override
        public int getRowCount() {
            return this.theFiles.size() * 2;
        }

        @Override
        public int getColumnCount() {
            int count = 0;
            for (FCS_data theFile : this.theFiles) {
                if (count >= theFile.getTotalParameterCount()) continue;
                count = theFile.getTotalParameterCount();
            }
            return count + 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "File";
            }
            return "Parameter " + (columnIndex - 1);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return false;
            }
            if (rowIndex % 2 == 0) {
                return false;
            }
            return columnIndex - 1 < this.theFiles.get(rowIndex / 2).getTotalParameterCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FCS_data theFile = this.theFiles.get(rowIndex / 2);
            if (rowIndex % 2 == 0) {
                if (columnIndex == 0) {
                    return theFile.getDataFileName();
                }
                if (columnIndex - 1 < theFile.getTotalParameterCount()) {
                    return theFile.getParameterLabel(columnIndex - 1);
                }
                return null;
            }
            if (columnIndex == 0) {
                return theFile.getSampleDescription();
            }
            if (columnIndex - 1 < theFile.getTotalParameterCount()) {
                int index = theFile.getLogicle(columnIndex - 1) + 2;
                if (index == 0) {
                    return this.transDesc[1];
                }
                if (index == 1) {
                    return this.transDesc[0];
                }
                return this.transDesc[theFile.getLogicle(columnIndex - 1) + 2];
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            FCS_data[] filesToUse;
            String newValue = aValue.toString();
            int comboIndex = this.transMap.get(newValue);
            --columnIndex;
            if (this.allFiles.isSelected()) {
                filesToUse = new FCS_data[this.theFiles.size()];
                for (int i = 0; i < filesToUse.length; ++i) {
                    filesToUse[i] = this.theFiles.get(i);
                }
            } else {
                filesToUse = new FCS_data[]{this.theFiles.get(rowIndex / 2)};
            }
            for (FCS_data currentFile : filesToUse) {
                if (this.allParams.isSelected()) {
                    for (int i = 0; i < currentFile.getTotalParameterCount(); ++i) {
                        if (comboIndex == 0) {
                            currentFile.setLinear(i);
                            continue;
                        }
                        if (comboIndex == 1) {
                            currentFile.setLog(i);
                            continue;
                        }
                        currentFile.setLogicle(i, comboIndex - 2);
                    }
                } else if (columnIndex < currentFile.getTotalParameterCount()) {
                    if (comboIndex == 0) {
                        currentFile.setLinear(columnIndex);
                    } else if (comboIndex == 1) {
                        currentFile.setLog(columnIndex);
                    } else {
                        currentFile.setLogicle(columnIndex, comboIndex - 2);
                    }
                }
                this.theFrame.transformationChanged(currentFile);
            }
            this.tableChanged();
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.theListeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.theListeners.remove(l);
        }

        public void tableChanged() {
            for (TableModelListener l : this.theListeners) {
                l.tableChanged(new TableModelEvent(this));
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (this.theScroller.getSize().width <= this.getColumnCount() * 100) {
                this.theTable.setAutoResizeMode(0);
            } else {
                this.theTable.setAutoResizeMode(4);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

