/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import org.python.core.CachedJarsPackageManager;
import org.python.core.Py;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyString;
import org.python.core.imp;

public abstract class PathPackageManager
extends CachedJarsPackageManager {
    public PyList searchPath = new PyList();

    protected boolean packageExists(PyList pyList, String string2, String string3) {
        String string4 = string2.replace('.', File.separatorChar) + File.separator + string3;
        for (int i = 0; i < pyList.__len__(); ++i) {
            String string5 = imp.defaultEmptyPathDirectory(pyList.pyget(i).__str__().toString());
            File file = new File(string5, string4);
            if (!file.isDirectory() || !imp.caseok(file, string3, string3.length())) continue;
            PackageExistsFileFilter packageExistsFileFilter = new PackageExistsFileFilter();
            file.listFiles(packageExistsFileFilter);
            boolean bl = packageExistsFileFilter.packageExists();
            if (bl) {
                Py.writeComment("import", "java package as '" + file.getAbsolutePath() + "'");
            }
            return bl;
        }
        return false;
    }

    protected void doDir(PyList pyList, PyList pyList2, PyJavaPackage pyJavaPackage, boolean bl, boolean bl2) {
        String string2 = pyJavaPackage.__name__.replace('.', File.separatorChar);
        for (int i = 0; i < pyList.__len__(); ++i) {
            File file;
            String[] stringArray;
            String string3 = pyList.pyget(i).__str__().toString();
            if (string3.length() == 0) {
                string3 = null;
            }
            if ((stringArray = (file = new File(string3, string2)).list()) == null) continue;
            block3: for (int j = 0; j < stringArray.length; ++j) {
                int n;
                String string4 = stringArray[j];
                File file2 = new File(file, string4);
                int n2 = string4.length();
                boolean bl3 = false;
                if (file2.isDirectory()) {
                    if (!bl && bl2) continue;
                    bl3 = true;
                } else {
                    if (!string4.endsWith(".class")) continue;
                    n2 -= 6;
                }
                string4 = string4.substring(0, n2);
                PyString pyString = new PyString(string4);
                if (this.filterByName(string4, bl3) || pyJavaPackage.__dict__.has_key(pyString) || pyJavaPackage.clsSet.has_key(pyString) || pyList2.__contains__(pyString) || !Character.isJavaIdentifierStart(string4.charAt(0))) continue;
                for (n = 1; n < n2; ++n) {
                    if (!Character.isJavaIdentifierPart(string4.charAt(n))) continue block3;
                }
                if (!bl3) {
                    try {
                        n = PathPackageManager.checkAccess(new BufferedInputStream(new FileInputStream(file2)));
                        if (n == -1) continue;
                        if (this.filterByAccess(string4, n)) {
                        }
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                if (bl) {
                    if (bl3) {
                        pyJavaPackage.addPackage(string4);
                    } else {
                        pyJavaPackage.addLazyClass(string4);
                    }
                }
                pyList2.append(pyString);
            }
        }
    }

    public void addDirectory(File file) {
        try {
            if (file.getPath().length() == 0) {
                this.searchPath.append(Py.EmptyString);
            } else {
                this.searchPath.append(new PyString(file.getCanonicalPath()));
            }
        }
        catch (IOException iOException) {
            this.warning("skipping bad directory, '" + file + "'");
        }
    }

    public void addClassPath(String string2) {
        PyList pyList = new PyString(string2).split(File.pathSeparator);
        for (int i = 0; i < pyList.__len__(); ++i) {
            String string3 = pyList.pyget(i).toString();
            if (string3.endsWith(".jar") || string3.endsWith(".zip")) {
                this.addJarToPackages(new File(string3), true);
                continue;
            }
            File file = new File(string3);
            if (string3.length() != 0 && !file.isDirectory()) continue;
            this.addDirectory(file);
        }
    }

    public PyList doDir(PyJavaPackage pyJavaPackage, boolean bl, boolean bl2) {
        PyList pyList = this.basicDoDir(pyJavaPackage, bl, bl2);
        PyList pyList2 = new PyList();
        this.doDir(this.searchPath, pyList2, pyJavaPackage, bl, bl2);
        return this.merge(pyList, pyList2);
    }

    public boolean packageExists(String string2, String string3) {
        return this.packageExists(this.searchPath, string2, string3);
    }

    class PackageExistsFileFilter
    implements FilenameFilter {
        private boolean java;
        private boolean python;

        PackageExistsFileFilter() {
        }

        public boolean accept(File file, String string2) {
            if (string2.endsWith(".py") || string2.endsWith("$py.class") || string2.endsWith("$_PyInner.class")) {
                this.python = true;
            } else if (string2.endsWith(".class")) {
                this.java = true;
            }
            return false;
        }

        public boolean packageExists() {
            return !this.python || this.java;
        }
    }
}

