/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.cache;

import edu.berkeley.nlp.lm.cache.ArrayEncodedLmCache;
import java.util.Arrays;

public final class ArrayEncodedDirectMappedLmCache
implements ArrayEncodedLmCache {
    private static final long serialVersionUID = 1L;
    private static final int WORD_OFFSET = 0;
    private static final int VAL_OFFSET = 1;
    private static final int KEY_OFFSET = 2;
    private static final int EMPTY = Integer.MIN_VALUE;
    private final int[] threadUnsafeArray;
    private final ThreadLocal<int[]> threadSafeArray;
    private final int cacheSize;
    private final int structLength;
    private final boolean threadSafe;
    private final int arrayLength;

    public ArrayEncodedDirectMappedLmCache(int cacheBits, int maxNgramOrder, boolean threadSafe) {
        this.cacheSize = (1 << cacheBits) - 1;
        this.threadSafe = threadSafe;
        this.arrayLength = maxNgramOrder - 1;
        this.structLength = maxNgramOrder + 2;
        if (threadSafe) {
            this.threadUnsafeArray = null;
            this.threadSafeArray = new ThreadLocal<int[]>(){

                @Override
                protected int[] initialValue() {
                    return ArrayEncodedDirectMappedLmCache.this.allocCache();
                }
            };
        } else {
            this.threadSafeArray = null;
            this.threadUnsafeArray = this.allocCache();
        }
    }

    private int[] allocCache() {
        int[] ret = new int[this.cacheSize * this.structLength];
        Arrays.fill(ret, Integer.MIN_VALUE);
        return ret;
    }

    @Override
    public float getCached(int[] ngram, int startPos, int endPos, int hash) {
        int[] arrayHere;
        int[] nArray = arrayHere = !this.threadSafe ? this.threadUnsafeArray : this.threadSafeArray.get();
        if (ngram[endPos - 1] == this.getWord(hash, arrayHere) && this.equals(ngram, startPos, endPos, arrayHere, this.getKeyStart(hash))) {
            return this.getVal(hash, arrayHere);
        }
        return Float.NaN;
    }

    private boolean equals(int[] ngram, int startPos, int endPos, int[] cachedNgram, int cachedNgramStart) {
        boolean all = true;
        for (int i = startPos; i < endPos - 1; ++i) {
            all &= cachedNgram[cachedNgramStart + i - startPos] == ngram[i];
        }
        return all && (endPos - startPos - 1 == this.arrayLength || cachedNgram[cachedNgramStart + endPos - 1 - startPos] == Integer.MIN_VALUE);
    }

    private float getVal(int hash, int[] arrayHere) {
        return Float.intBitsToFloat(arrayHere[this.startOfStruct(hash) + 1]);
    }

    private float setVal(int hash, float f, int[] arrayHere) {
        int n = Float.floatToIntBits(f);
        arrayHere[this.startOfStruct((int)hash) + 1] = n;
        return n;
    }

    private float setWord(int hash, int word, int[] arrayHere) {
        int n = word;
        arrayHere[this.startOfStruct((int)hash) + 0] = n;
        return n;
    }

    private int getWord(int hash, int[] arrayHere) {
        return arrayHere[this.startOfStruct(hash) + 0];
    }

    private int getKeyStart(int hash) {
        return this.startOfStruct(hash) + 2;
    }

    private int startOfStruct(int hash) {
        return hash * this.structLength;
    }

    @Override
    public void clear() {
        Arrays.fill(!this.threadSafe ? this.threadUnsafeArray : this.threadSafeArray.get(), Float.floatToIntBits(Float.NaN));
    }

    @Override
    public void putCached(int[] ngram, int startPos, int endPos, float f, int hash) {
        int i;
        int[] arrayHere = !this.threadSafe ? this.threadUnsafeArray : this.threadSafeArray.get();
        this.setVal(hash, f, arrayHere);
        this.setWord(hash, ngram[endPos - 1], arrayHere);
        for (i = startPos; i < endPos - 1; ++i) {
            arrayHere[this.getKeyStart((int)hash) + i - startPos] = ngram[i];
        }
        for (i = endPos - 1; i < this.arrayLength; ++i) {
            arrayHere[this.getKeyStart((int)hash) + i - startPos] = Integer.MIN_VALUE;
        }
    }

    @Override
    public int capacity() {
        return this.cacheSize;
    }
}

