/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene41;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.codecs.lucene41.Lucene41StoredFieldsIndexReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.packed.PackedInts;

@Deprecated
final class Lucene41StoredFieldsReader
extends StoredFieldsReader {
    private static final int BUFFER_REUSE_THRESHOLD = 32768;
    static final int STRING = 0;
    static final int BYTE_ARR = 1;
    static final int NUMERIC_INT = 2;
    static final int NUMERIC_FLOAT = 3;
    static final int NUMERIC_LONG = 4;
    static final int NUMERIC_DOUBLE = 5;
    static final String CODEC_SFX_IDX = "Index";
    static final String CODEC_SFX_DAT = "Data";
    static final int TYPE_BITS = PackedInts.bitsRequired((long)5L);
    static final int TYPE_MASK = (int)PackedInts.maxValue((int)TYPE_BITS);
    static final int VERSION_START = 0;
    static final int VERSION_BIG_CHUNKS = 1;
    static final int VERSION_CHECKSUM = 2;
    static final int VERSION_CURRENT = 2;
    public static final String FIELDS_EXTENSION = "fdt";
    public static final String FIELDS_INDEX_EXTENSION = "fdx";
    private final int version;
    private final FieldInfos fieldInfos;
    private final Lucene41StoredFieldsIndexReader indexReader;
    private final long maxPointer;
    private final IndexInput fieldsStream;
    private final int chunkSize;
    private final int packedIntsVersion;
    private final CompressionMode compressionMode;
    private final Decompressor decompressor;
    private final int numDocs;
    private final boolean merging;
    private final BlockState state;
    private boolean closed;

    private Lucene41StoredFieldsReader(Lucene41StoredFieldsReader reader, boolean merging) {
        this.version = reader.version;
        this.fieldInfos = reader.fieldInfos;
        this.fieldsStream = reader.fieldsStream.clone();
        this.indexReader = reader.indexReader.clone();
        this.maxPointer = reader.maxPointer;
        this.chunkSize = reader.chunkSize;
        this.packedIntsVersion = reader.packedIntsVersion;
        this.compressionMode = reader.compressionMode;
        this.decompressor = reader.decompressor.clone();
        this.numDocs = reader.numDocs;
        this.merging = merging;
        this.state = new BlockState();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene41StoredFieldsReader(Directory d, SegmentInfo si, String segmentSuffix, FieldInfos fn, IOContext context, String formatName, CompressionMode compressionMode) throws IOException {
        this.compressionMode = compressionMode;
        String segment = si.name;
        boolean success = false;
        this.fieldInfos = fn;
        this.numDocs = si.maxDoc();
        ChecksumIndexInput indexStream = null;
        try {
            String indexStreamFN = IndexFileNames.segmentFileName((String)segment, (String)segmentSuffix, (String)FIELDS_INDEX_EXTENSION);
            String fieldsStreamFN = IndexFileNames.segmentFileName((String)segment, (String)segmentSuffix, (String)FIELDS_EXTENSION);
            indexStream = d.openChecksumInput(indexStreamFN, context);
            String codecNameIdx = formatName + CODEC_SFX_IDX;
            this.version = CodecUtil.checkHeader((DataInput)indexStream, (String)codecNameIdx, (int)0, (int)2);
            assert ((long)CodecUtil.headerLength((String)codecNameIdx) == indexStream.getFilePointer());
            this.indexReader = new Lucene41StoredFieldsIndexReader((IndexInput)indexStream, si);
            long maxPointer = -1L;
            if (this.version >= 2) {
                maxPointer = indexStream.readVLong();
                CodecUtil.checkFooter((ChecksumIndexInput)indexStream);
            } else {
                CodecUtil.checkEOF((IndexInput)indexStream);
            }
            indexStream.close();
            indexStream = null;
            this.fieldsStream = d.openInput(fieldsStreamFN, context);
            if (this.version >= 2) {
                if (maxPointer + (long)CodecUtil.footerLength() != this.fieldsStream.length()) {
                    throw new CorruptIndexException("Invalid fieldsStream maxPointer (file truncated?): maxPointer=" + maxPointer + ", length=" + this.fieldsStream.length(), (DataInput)this.fieldsStream);
                }
            } else {
                maxPointer = this.fieldsStream.length();
            }
            this.maxPointer = maxPointer;
            String codecNameDat = formatName + CODEC_SFX_DAT;
            int fieldsVersion = CodecUtil.checkHeader((DataInput)this.fieldsStream, (String)codecNameDat, (int)0, (int)2);
            if (this.version != fieldsVersion) {
                throw new CorruptIndexException("Version mismatch between stored fields index and data: " + this.version + " != " + fieldsVersion, (DataInput)this.fieldsStream);
            }
            assert ((long)CodecUtil.headerLength((String)codecNameDat) == this.fieldsStream.getFilePointer());
            this.chunkSize = this.version >= 1 ? this.fieldsStream.readVInt() : -1;
            this.packedIntsVersion = this.fieldsStream.readVInt();
            this.decompressor = compressionMode.newDecompressor();
            this.merging = false;
            this.state = new BlockState();
            if (this.version >= 2) {
                CodecUtil.retrieveChecksum((IndexInput)this.fieldsStream);
            }
            if (success = true) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this, indexStream});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this, indexStream});
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            IOUtils.close((Closeable[])new Closeable[]{this.fieldsStream});
            this.closed = true;
        }
    }

    private static void readField(DataInput in, StoredFieldVisitor visitor, FieldInfo info, int bits) throws IOException {
        switch (bits & TYPE_MASK) {
            case 1: {
                int length = in.readVInt();
                byte[] data = new byte[length];
                in.readBytes(data, 0, length);
                visitor.binaryField(info, data);
                break;
            }
            case 0: {
                int length = in.readVInt();
                byte[] data = new byte[length];
                in.readBytes(data, 0, length);
                visitor.stringField(info, data);
                break;
            }
            case 2: {
                visitor.intField(info, in.readInt());
                break;
            }
            case 3: {
                visitor.floatField(info, Float.intBitsToFloat(in.readInt()));
                break;
            }
            case 4: {
                visitor.longField(info, in.readLong());
                break;
            }
            case 5: {
                visitor.doubleField(info, Double.longBitsToDouble(in.readLong()));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    private static void skipField(DataInput in, int bits) throws IOException {
        switch (bits & TYPE_MASK) {
            case 0: 
            case 1: {
                int length = in.readVInt();
                in.skipBytes((long)length);
                break;
            }
            case 2: 
            case 3: {
                in.readInt();
                break;
            }
            case 4: 
            case 5: {
                in.readLong();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    SerializedDocument document(int docID) throws IOException {
        if (!this.state.contains(docID)) {
            this.fieldsStream.seek(this.indexReader.getStartPointer(docID));
            this.state.reset(docID);
        }
        assert (this.state.contains(docID));
        return this.state.document(docID);
    }

    public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
        SerializedDocument doc = this.document(docID);
        block5: for (int fieldIDX = 0; fieldIDX < doc.numStoredFields; ++fieldIDX) {
            long infoAndBits = doc.in.readVLong();
            int fieldNumber = (int)(infoAndBits >>> TYPE_BITS);
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
            int bits = (int)(infoAndBits & (long)TYPE_MASK);
            if (bits < 0 || bits > 5) {
                throw new CorruptIndexException("Invalid bits: " + Integer.toHexString(bits) + ", docid=" + docID, doc.in);
            }
            switch (visitor.needsField(fieldInfo)) {
                case YES: {
                    Lucene41StoredFieldsReader.readField(doc.in, visitor, fieldInfo, bits);
                    continue block5;
                }
                case NO: {
                    Lucene41StoredFieldsReader.skipField(doc.in, bits);
                    continue block5;
                }
                case STOP: {
                    return;
                }
            }
        }
    }

    public StoredFieldsReader clone() {
        this.ensureOpen();
        return new Lucene41StoredFieldsReader(this, false);
    }

    public StoredFieldsReader getMergeInstance() {
        this.ensureOpen();
        return new Lucene41StoredFieldsReader(this, true);
    }

    public long ramBytesUsed() {
        return this.indexReader.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        return Collections.singleton(Accountables.namedAccountable((String)"stored field index", (Accountable)this.indexReader));
    }

    public void checkIntegrity() throws IOException {
        if (this.version >= 2) {
            CodecUtil.checksumEntireFile((IndexInput)this.fieldsStream);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(mode=" + this.compressionMode + ",chunksize=" + this.chunkSize + ")";
    }

    private class BlockState {
        private int docBase;
        private int chunkDocs;
        private boolean sliced;
        private int[] offsets = IntsRef.EMPTY_INTS;
        private int[] numStoredFields = IntsRef.EMPTY_INTS;
        private long startPointer;
        private final BytesRef spare = new BytesRef();
        private final BytesRef bytes = new BytesRef();

        private BlockState() {
        }

        boolean contains(int docID) {
            return docID >= this.docBase && docID < this.docBase + this.chunkDocs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset(int docID) throws IOException {
            boolean success = false;
            try {
                this.doReset(docID);
                success = true;
            }
            finally {
                if (!success) {
                    this.chunkDocs = 0;
                }
            }
        }

        private void doReset(int docID) throws IOException {
            this.docBase = Lucene41StoredFieldsReader.this.fieldsStream.readVInt();
            this.chunkDocs = Lucene41StoredFieldsReader.this.fieldsStream.readVInt();
            if (!this.contains(docID) || this.docBase + this.chunkDocs > Lucene41StoredFieldsReader.this.numDocs) {
                throw new CorruptIndexException("Corrupted: docID=" + docID + ", docBase=" + this.docBase + ", chunkDocs=" + this.chunkDocs + ", numDocs=" + Lucene41StoredFieldsReader.this.numDocs, (DataInput)Lucene41StoredFieldsReader.this.fieldsStream);
            }
            this.offsets = ArrayUtil.grow((int[])this.offsets, (int)(this.chunkDocs + 1));
            this.numStoredFields = ArrayUtil.grow((int[])this.numStoredFields, (int)this.chunkDocs);
            if (this.chunkDocs == 1) {
                this.numStoredFields[0] = Lucene41StoredFieldsReader.this.fieldsStream.readVInt();
                this.offsets[1] = Lucene41StoredFieldsReader.this.fieldsStream.readVInt();
            } else {
                int i;
                int bitsPerStoredFields = Lucene41StoredFieldsReader.this.fieldsStream.readVInt();
                if (bitsPerStoredFields == 0) {
                    Arrays.fill(this.numStoredFields, 0, this.chunkDocs, Lucene41StoredFieldsReader.this.fieldsStream.readVInt());
                } else {
                    if (bitsPerStoredFields > 31) {
                        throw new CorruptIndexException("bitsPerStoredFields=" + bitsPerStoredFields, (DataInput)Lucene41StoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader((DataInput)Lucene41StoredFieldsReader.this.fieldsStream, (PackedInts.Format)PackedInts.Format.PACKED, (int)Lucene41StoredFieldsReader.this.packedIntsVersion, (int)this.chunkDocs, (int)bitsPerStoredFields, (int)1);
                    for (int i2 = 0; i2 < this.chunkDocs; ++i2) {
                        this.numStoredFields[i2] = (int)it.next();
                    }
                }
                int bitsPerLength = Lucene41StoredFieldsReader.this.fieldsStream.readVInt();
                if (bitsPerLength == 0) {
                    int length = Lucene41StoredFieldsReader.this.fieldsStream.readVInt();
                    for (i = 0; i < this.chunkDocs; ++i) {
                        this.offsets[1 + i] = (1 + i) * length;
                    }
                } else {
                    if (bitsPerStoredFields > 31) {
                        throw new CorruptIndexException("bitsPerLength=" + bitsPerLength, (DataInput)Lucene41StoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader((DataInput)Lucene41StoredFieldsReader.this.fieldsStream, (PackedInts.Format)PackedInts.Format.PACKED, (int)Lucene41StoredFieldsReader.this.packedIntsVersion, (int)this.chunkDocs, (int)bitsPerLength, (int)1);
                    for (i = 0; i < this.chunkDocs; ++i) {
                        this.offsets[i + 1] = (int)it.next();
                    }
                    for (i = 0; i < this.chunkDocs; ++i) {
                        int n = i + 1;
                        this.offsets[n] = this.offsets[n] + this.offsets[i];
                    }
                }
                for (int i3 = 0; i3 < this.chunkDocs; ++i3) {
                    int storedFields;
                    int len = this.offsets[i3 + 1] - this.offsets[i3];
                    if (len == 0 == ((storedFields = this.numStoredFields[i3]) == 0)) continue;
                    throw new CorruptIndexException("length=" + len + ", numStoredFields=" + storedFields, (DataInput)Lucene41StoredFieldsReader.this.fieldsStream);
                }
            }
            this.sliced = Lucene41StoredFieldsReader.this.version >= 1 && this.offsets[this.chunkDocs] >= 2 * Lucene41StoredFieldsReader.this.chunkSize;
            this.startPointer = Lucene41StoredFieldsReader.this.fieldsStream.getFilePointer();
            if (Lucene41StoredFieldsReader.this.merging) {
                int totalLength = this.offsets[this.chunkDocs];
                if (this.sliced) {
                    int toDecompress;
                    this.bytes.length = 0;
                    this.bytes.offset = 0;
                    for (int decompressed = 0; decompressed < totalLength; decompressed += toDecompress) {
                        toDecompress = Math.min(totalLength - decompressed, Lucene41StoredFieldsReader.this.chunkSize);
                        Lucene41StoredFieldsReader.this.decompressor.decompress((DataInput)Lucene41StoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, this.spare);
                        this.bytes.bytes = ArrayUtil.grow((byte[])this.bytes.bytes, (int)(this.bytes.length + this.spare.length));
                        System.arraycopy(this.spare.bytes, this.spare.offset, this.bytes.bytes, this.bytes.length, this.spare.length);
                        this.bytes.length += this.spare.length;
                    }
                } else {
                    Lucene41StoredFieldsReader.this.decompressor.decompress((DataInput)Lucene41StoredFieldsReader.this.fieldsStream, totalLength, 0, totalLength, this.bytes);
                }
                if (this.bytes.length != totalLength) {
                    throw new CorruptIndexException("Corrupted: expected chunk size = " + totalLength + ", got " + this.bytes.length, (DataInput)Lucene41StoredFieldsReader.this.fieldsStream);
                }
            }
        }

        SerializedDocument document(int docID) throws IOException {
            Object documentInput;
            if (!this.contains(docID)) {
                throw new IllegalArgumentException();
            }
            int index = docID - this.docBase;
            int offset = this.offsets[index];
            final int length = this.offsets[index + 1] - offset;
            int totalLength = this.offsets[this.chunkDocs];
            int numStoredFields = this.numStoredFields[index];
            Lucene41StoredFieldsReader.this.fieldsStream.seek(this.startPointer);
            if (length == 0) {
                documentInput = new ByteArrayDataInput();
            } else if (Lucene41StoredFieldsReader.this.merging) {
                documentInput = new ByteArrayDataInput(this.bytes.bytes, this.bytes.offset + offset, length);
            } else if (this.sliced) {
                Lucene41StoredFieldsReader.this.decompressor.decompress((DataInput)Lucene41StoredFieldsReader.this.fieldsStream, Lucene41StoredFieldsReader.this.chunkSize, offset, Math.min(length, Lucene41StoredFieldsReader.this.chunkSize - offset), this.bytes);
                documentInput = new DataInput(){
                    int decompressed;
                    {
                        this.decompressed = ((BlockState)BlockState.this).bytes.length;
                    }

                    void fillBuffer() throws IOException {
                        assert (this.decompressed <= length);
                        if (this.decompressed == length) {
                            throw new EOFException();
                        }
                        int toDecompress = Math.min(length - this.decompressed, Lucene41StoredFieldsReader.this.chunkSize);
                        Lucene41StoredFieldsReader.this.decompressor.decompress((DataInput)Lucene41StoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, BlockState.this.bytes);
                        this.decompressed += toDecompress;
                    }

                    public byte readByte() throws IOException {
                        if (((BlockState)BlockState.this).bytes.length == 0) {
                            this.fillBuffer();
                        }
                        --((BlockState)BlockState.this).bytes.length;
                        return ((BlockState)BlockState.this).bytes.bytes[((BlockState)BlockState.this).bytes.offset++];
                    }

                    public void readBytes(byte[] b, int offset, int len) throws IOException {
                        while (len > ((BlockState)BlockState.this).bytes.length) {
                            System.arraycopy(((BlockState)BlockState.this).bytes.bytes, ((BlockState)BlockState.this).bytes.offset, b, offset, ((BlockState)BlockState.this).bytes.length);
                            len -= ((BlockState)BlockState.this).bytes.length;
                            offset += ((BlockState)BlockState.this).bytes.length;
                            this.fillBuffer();
                        }
                        System.arraycopy(((BlockState)BlockState.this).bytes.bytes, ((BlockState)BlockState.this).bytes.offset, b, offset, len);
                        ((BlockState)BlockState.this).bytes.offset += len;
                        ((BlockState)BlockState.this).bytes.length -= len;
                    }
                };
            } else {
                BytesRef bytes = totalLength <= 32768 ? this.bytes : new BytesRef();
                Lucene41StoredFieldsReader.this.decompressor.decompress((DataInput)Lucene41StoredFieldsReader.this.fieldsStream, totalLength, offset, length, bytes);
                assert (bytes.length == length);
                documentInput = new ByteArrayDataInput(bytes.bytes, bytes.offset, bytes.length);
            }
            return new SerializedDocument((DataInput)documentInput, length, numStoredFields);
        }
    }

    static class SerializedDocument {
        final DataInput in;
        final int length;
        final int numStoredFields;

        private SerializedDocument(DataInput in, int length, int numStoredFields) {
            this.in = in;
            this.length = length;
            this.numStoredFields = numStoredFields;
        }
    }
}

