/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices.decomposition;

import java.util.Arrays;
import org.encog.mathutil.EncogMath;
import org.encog.mathutil.matrices.Matrix;

public class EigenvalueDecomposition {
    private final int n;
    private final boolean issymmetric;
    private final double[] d;
    private final double[] e;
    private final double[][] v;
    private double cdivr;
    private double cdivi;
    private double[][] h;
    private double[] ort;

    public EigenvalueDecomposition(Matrix matrix) {
        double[][] a = matrix.getData();
        this.n = matrix.getCols();
        this.v = new double[this.n][this.n];
        this.d = new double[this.n];
        this.e = new double[this.n];
        this.issymmetric = EigenvalueDecomposition.isSymmetric(a);
        if (this.issymmetric) {
            for (int i = 0; i < this.n; ++i) {
                System.arraycopy(a[i], 0, this.v[i], 0, this.n);
            }
            this.tred2();
            this.tql2();
        } else {
            this.h = new double[this.n][this.n];
            this.ort = new double[this.n];
            for (int j = 0; j < this.n; ++j) {
                System.arraycopy(a, 0, this.h, 0, this.n);
            }
            this.orthes();
            this.hqr2();
        }
    }

    static boolean isSymmetric(double[][] a) {
        int len = a.length;
        if (len == 0) {
            return true;
        }
        if (a[0].length != len) {
            return false;
        }
        for (int j = 1; j < len; ++j) {
            if (a[j].length != len) {
                return false;
            }
            for (int i = 0; i < j; ++i) {
                if (a[i][j] == a[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    private void cdiv(double xr, double xi, double yr, double yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            this.cdivr = (xr + r * xi) / d;
            this.cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            this.cdivr = (r * xr + xi) / d;
            this.cdivi = (r * xi - xr) / d;
        }
    }

    public Matrix getD() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] D = X.getData();
        for (int i = 0; i < this.n; ++i) {
            Arrays.fill(D[i], 0.0);
            D[i][i] = this.d[i];
            if (this.e[i] > 0.0) {
                D[i][i + 1] = this.e[i];
                continue;
            }
            if (!(this.e[i] < 0.0)) continue;
            D[i][i - 1] = this.e[i];
        }
        return X;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public Matrix getV() {
        return new Matrix(this.v);
    }

    private void hqr2() {
        double y;
        int i;
        double x;
        double w;
        int l;
        int j;
        int nn = this.n;
        int n = nn - 1;
        boolean low = false;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double exshift = 0.0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double norm = 0.0;
        for (int i2 = 0; i2 < nn; ++i2) {
            if (i2 < 0 | i2 > high) {
                this.d[i2] = this.h[i2][i2];
                this.e[i2] = 0.0;
            }
            for (j = Math.max(i2 - 1, 0); j < nn; ++j) {
                norm += Math.abs(this.h[i2][j]);
            }
        }
        int iter = 0;
        block2: while (n >= 0) {
            int m;
            for (l = n; l > 0; --l) {
                s = Math.abs(this.h[l - 1][l - 1]) + Math.abs(this.h[l][l]);
                if (s == 0.0) {
                    s = norm;
                }
                if (Math.abs(this.h[l][l - 1]) < eps * s) break;
            }
            if (l == n) {
                this.h[n][n] = this.h[n][n] + exshift;
                this.d[n] = this.h[n][n];
                this.e[n] = 0.0;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = this.h[n][n - 1] * this.h[n - 1][n];
                p = (this.h[n - 1][n - 1] - this.h[n][n]) / 2.0;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                this.h[n][n] = this.h[n][n] + exshift;
                this.h[n - 1][n - 1] = this.h[n - 1][n - 1] + exshift;
                x = this.h[n][n];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    this.d[n - 1] = x + z;
                    this.d[n] = this.d[n - 1];
                    if (z != 0.0) {
                        this.d[n] = x - w / z;
                    }
                    this.e[n - 1] = 0.0;
                    this.e[n] = 0.0;
                    x = this.h[n][n - 1];
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (int j2 = n - 1; j2 < nn; ++j2) {
                        z = this.h[n - 1][j2];
                        this.h[n - 1][j2] = q * z + p * this.h[n][j2];
                        this.h[n][j2] = q * this.h[n][j2] - p * z;
                    }
                    for (i = 0; i <= n; ++i) {
                        z = this.h[i][n - 1];
                        this.h[i][n - 1] = q * z + p * this.h[i][n];
                        this.h[i][n] = q * this.h[i][n] - p * z;
                    }
                    for (i = 0; i <= high; ++i) {
                        z = this.v[i][n - 1];
                        this.v[i][n - 1] = q * z + p * this.v[i][n];
                        this.v[i][n] = q * this.v[i][n] - p * z;
                    }
                } else {
                    this.d[n - 1] = x + p;
                    this.d[n] = x + p;
                    this.e[n - 1] = z;
                    this.e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = this.h[n][n];
            y = 0.0;
            w = 0.0;
            if (l < n) {
                y = this.h[n - 1][n - 1];
                w = this.h[n][n - 1] * this.h[n - 1][n];
            }
            if (iter == 10) {
                exshift += x;
                i = 0;
                while (i <= n) {
                    double[] dArray = this.h[i];
                    int n2 = i++;
                    dArray[n2] = dArray[n2] - x;
                }
                s = Math.abs(this.h[n][n - 1]) + Math.abs(this.h[n - 1][n - 2]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    i = 0;
                    while (i <= n) {
                        double[] dArray = this.h[i];
                        int n3 = i++;
                        dArray[n3] = dArray[n3] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = this.h[m][m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / this.h[m + 1][m] + this.h[m][m + 1];
                q = this.h[m + 1][m + 1] - z - r - s;
                r = this.h[m + 2][m + 1];
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(this.h[m][m - 1]) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(this.h[m - 1][m - 1]) + Math.abs(z) + Math.abs(this.h[m + 1][m + 1])))) break;
            }
            for (int i3 = m + 2; i3 <= n; ++i3) {
                this.h[i3][i3 - 2] = 0.0;
                if (i3 <= m + 2) continue;
                this.h[i3][i3 - 3] = 0.0;
            }
            for (int k = m; k <= n - 1; ++k) {
                int i4;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = this.h[k][k - 1];
                    q = this.h[k + 1][k - 1];
                    r = notlast ? this.h[k + 2][k - 1] : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x != 0.0) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0) continue block2;
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    this.h[k][k - 1] = -s * x;
                } else if (l != m) {
                    this.h[k][k - 1] = -this.h[k][k - 1];
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j3 = k; j3 < nn; ++j3) {
                    p = this.h[k][j3] + q * this.h[k + 1][j3];
                    if (notlast) {
                        this.h[k + 2][j3] = this.h[k + 2][j3] - (p += r * this.h[k + 2][j3]) * z;
                    }
                    this.h[k][j3] = this.h[k][j3] - p * x;
                    this.h[k + 1][j3] = this.h[k + 1][j3] - p * y;
                }
                for (i4 = 0; i4 <= Math.min(n, k + 3); ++i4) {
                    p = x * this.h[i4][k] + y * this.h[i4][k + 1];
                    if (notlast) {
                        this.h[i4][k + 2] = this.h[i4][k + 2] - (p += z * this.h[i4][k + 2]) * r;
                    }
                    this.h[i4][k] = this.h[i4][k] - p;
                    this.h[i4][k + 1] = this.h[i4][k + 1] - p * q;
                }
                for (i4 = 0; i4 <= high; ++i4) {
                    p = x * this.v[i4][k] + y * this.v[i4][k + 1];
                    if (notlast) {
                        this.v[i4][k + 2] = this.v[i4][k + 2] - (p += z * this.v[i4][k + 2]) * r;
                    }
                    this.v[i4][k] = this.v[i4][k] - p;
                    this.v[i4][k + 1] = this.v[i4][k + 1] - p * q;
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (n = nn - 1; n >= 0; --n) {
            double t;
            p = this.d[n];
            q = this.e[n];
            if (q == 0.0) {
                l = n;
                this.h[n][n] = 1.0;
                for (i = n - 1; i >= 0; --i) {
                    int j4;
                    w = this.h[i][i] - p;
                    r = 0.0;
                    for (j4 = l; j4 <= n; ++j4) {
                        r += this.h[i][j4] * this.h[j4][n];
                    }
                    if (this.e[i] < 0.0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i;
                    if (this.e[i] == 0.0) {
                        this.h[i][n] = w != 0.0 ? -r / w : -r / (eps * norm);
                    } else {
                        x = this.h[i][i + 1];
                        y = this.h[i + 1][i];
                        q = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i];
                        this.h[i][n] = t = (x * s - z * r) / q;
                        this.h[i + 1][n] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                    }
                    t = Math.abs(this.h[i][n]);
                    if (!(eps * t * t > 1.0)) continue;
                    for (j4 = i; j4 <= n; ++j4) {
                        this.h[j4][n] = this.h[j4][n] / t;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (Math.abs(this.h[n][n - 1]) > Math.abs(this.h[n - 1][n])) {
                this.h[n - 1][n - 1] = q / this.h[n][n - 1];
                this.h[n - 1][n] = -(this.h[n][n] - p) / this.h[n][n - 1];
            } else {
                this.cdiv(0.0, -this.h[n - 1][n], this.h[n - 1][n - 1] - p, q);
                this.h[n - 1][n - 1] = this.cdivr;
                this.h[n - 1][n] = this.cdivi;
            }
            this.h[n][n - 1] = 0.0;
            this.h[n][n] = 1.0;
            for (i = n - 2; i >= 0; --i) {
                int j5;
                double ra = 0.0;
                double sa = 0.0;
                for (j5 = l; j5 <= n; ++j5) {
                    ra += this.h[i][j5] * this.h[j5][n - 1];
                    sa += this.h[i][j5] * this.h[j5][n];
                }
                w = this.h[i][i] - p;
                if (this.e[i] < 0.0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i;
                if (this.e[i] == 0.0) {
                    this.cdiv(-ra, -sa, w, q);
                    this.h[i][n - 1] = this.cdivr;
                    this.h[i][n] = this.cdivi;
                } else {
                    double vi;
                    x = this.h[i][i + 1];
                    y = this.h[i + 1][i];
                    double vr = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i] - q * q;
                    if (vr == 0.0 & (vi = (this.d[i] - p) * 2.0 * q) == 0.0) {
                        vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                    }
                    this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                    this.h[i][n - 1] = this.cdivr;
                    this.h[i][n] = this.cdivi;
                    if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                        this.h[i + 1][n - 1] = (-ra - w * this.h[i][n - 1] + q * this.h[i][n]) / x;
                        this.h[i + 1][n] = (-sa - w * this.h[i][n] - q * this.h[i][n - 1]) / x;
                    } else {
                        this.cdiv(-r - y * this.h[i][n - 1], -s - y * this.h[i][n], z, q);
                        this.h[i + 1][n - 1] = this.cdivr;
                        this.h[i + 1][n] = this.cdivi;
                    }
                }
                t = Math.max(Math.abs(this.h[i][n - 1]), Math.abs(this.h[i][n]));
                if (!(eps * t * t > 1.0)) continue;
                for (j5 = i; j5 <= n; ++j5) {
                    this.h[j5][n - 1] = this.h[j5][n - 1] / t;
                    this.h[j5][n] = this.h[j5][n] / t;
                }
            }
        }
        for (int i5 = 0; i5 < nn; ++i5) {
            if (!(i5 < 0 | i5 > high)) continue;
            System.arraycopy(this.h, i5, this.v, i5, nn - i5);
        }
        for (j = nn - 1; j >= 0; --j) {
            for (i = 0; i <= high; ++i) {
                z = 0.0;
                for (int k = 0; k <= Math.min(j, high); ++k) {
                    z += this.v[i][k] * this.h[k][j];
                }
                this.v[i][j] = z;
            }
        }
    }

    private void orthes() {
        int m;
        boolean low = false;
        int high = this.n - 1;
        for (m = 1; m <= high - 1; ++m) {
            double f;
            double scale = 0.0;
            for (int i = m; i <= high; ++i) {
                scale += Math.abs(this.h[i][m - 1]);
            }
            if (scale == 0.0) continue;
            double lh = 0.0;
            for (int i = high; i >= m; --i) {
                this.ort[i] = this.h[i][m - 1] / scale;
                lh += this.ort[i] * this.ort[i];
            }
            double g = Math.sqrt(lh);
            if (this.ort[m] > 0.0) {
                g = -g;
            }
            lh -= this.ort[m] * g;
            this.ort[m] = this.ort[m] - g;
            for (int j = m; j < this.n; ++j) {
                int i;
                f = 0.0;
                for (i = high; i >= m; --i) {
                    f += this.ort[i] * this.h[i][j];
                }
                f /= lh;
                for (i = m; i <= high; ++i) {
                    double[] dArray = this.h[i];
                    int n = j;
                    dArray[n] = dArray[n] - f * this.ort[i];
                }
            }
            for (int i = 0; i <= high; ++i) {
                int j;
                f = 0.0;
                for (j = high; j >= m; --j) {
                    f += this.ort[j] * this.h[i][j];
                }
                f /= lh;
                for (j = m; j <= high; ++j) {
                    double[] dArray = this.h[i];
                    int n = j;
                    dArray[n] = dArray[n] - f * this.ort[j];
                }
            }
            this.ort[m] = scale * this.ort[m];
            this.h[m][m - 1] = scale * g;
        }
        for (int i = 0; i < this.n; ++i) {
            Arrays.fill(this.v[i], 0.0);
            this.v[i][i] = 1.0;
        }
        for (m = high - 1; m >= 1; --m) {
            if (this.h[m][m - 1] == 0.0) continue;
            for (int i = m + 1; i <= high; ++i) {
                this.ort[i] = this.h[i][m - 1];
            }
            for (int j = m; j <= high; ++j) {
                int i;
                double g = 0.0;
                for (i = m; i <= high; ++i) {
                    g += this.ort[i] * this.v[i][j];
                }
                g = g / this.ort[m] / this.h[m][m - 1];
                for (i = m; i <= high; ++i) {
                    double[] dArray = this.v[i];
                    int n = j;
                    dArray[n] = dArray[n] + g * this.ort[i];
                }
            }
        }
    }

    private void tql2() {
        for (int i = 1; i < this.n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[this.n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < this.n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            for (m = l; m < this.n && !(Math.abs(this.e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = this.d[l];
                    double p = (this.d[l + 1] - g) / (2.0 * this.e[l]);
                    double r = EncogMath.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    double dl1 = this.d[l + 1];
                    double h = g - this.d[l];
                    int i = l + 2;
                    while (i < this.n) {
                        int n = i++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i2];
                        h = c * p;
                        r = EncogMath.hypot(p, this.e[i2]);
                        this.e[i2 + 1] = s * r;
                        s = this.e[i2] / r;
                        c = p / r;
                        p = c * this.d[i2] - s * g;
                        this.d[i2 + 1] = h + s * (c * g + s * this.d[i2]);
                        for (int k = 0; k < this.n; ++k) {
                            h = this.v[k][i2 + 1];
                            this.v[k][i2 + 1] = s * this.v[k][i2] + c * h;
                            this.v[k][i2] = c * this.v[k][i2] - s * h;
                        }
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            this.d[l] = this.d[l] + f;
            this.e[l] = 0.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            int j;
            int k = i;
            double p = this.d[i];
            for (j = i + 1; j < this.n; ++j) {
                if (!(this.d[j] < p)) continue;
                k = j;
                p = this.d[j];
            }
            if (k == i) continue;
            this.d[k] = this.d[i];
            this.d[i] = p;
            for (j = 0; j < this.n; ++j) {
                p = this.v[j][i];
                this.v[j][i] = this.v[j][k];
                this.v[j][k] = p;
            }
        }
    }

    private void tred2() {
        int i;
        System.arraycopy(this.v[this.n - 1], 0, this.d, 0, this.n);
        for (i = this.n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(this.d[k]);
            }
            if (scale == 0.0) {
                this.e[i] = this.d[i - 1];
                for (int j = 0; j < i; ++j) {
                    this.d[j] = this.v[i - 1][j];
                    this.v[i][j] = 0.0;
                    this.v[j][i] = 0.0;
                }
            } else {
                int j;
                int j2;
                for (k = 0; k < i; ++k) {
                    int n = k;
                    this.d[n] = this.d[n] / scale;
                    h += this.d[k] * this.d[k];
                }
                double f = this.d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                this.e[i] = scale * g;
                h -= f * g;
                this.d[i - 1] = f - g;
                Arrays.fill(this.e, 0, i, 0.0);
                for (j2 = 0; j2 < i; ++j2) {
                    this.v[j2][i] = f = this.d[j2];
                    g = this.e[j2] + this.v[j2][j2] * f;
                    for (int k2 = j2 + 1; k2 <= i - 1; ++k2) {
                        g += this.v[k2][j2] * this.d[k2];
                        int n = k2;
                        this.e[n] = this.e[n] + this.v[k2][j2] * f;
                    }
                    this.e[j2] = g;
                }
                f = 0.0;
                for (j2 = 0; j2 < i; ++j2) {
                    int n = j2;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j2] * this.d[j2];
                }
                double hh = f / (h + h);
                for (j = 0; j < i; ++j) {
                    int n = j;
                    this.e[n] = this.e[n] - hh * this.d[j];
                }
                for (j = 0; j < i; ++j) {
                    f = this.d[j];
                    g = this.e[j];
                    for (int k3 = j; k3 <= i - 1; ++k3) {
                        double[] dArray = this.v[k3];
                        int n = j;
                        dArray[n] = dArray[n] - (f * this.e[k3] + g * this.d[k3]);
                    }
                    this.d[j] = this.v[i - 1][j];
                    this.v[i][j] = 0.0;
                }
            }
            this.d[i] = h;
        }
        for (i = 0; i < this.n - 1; ++i) {
            int k;
            this.v[this.n - 1][i] = this.v[i][i];
            this.v[i][i] = 1.0;
            double h = this.d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    this.d[k] = this.v[k][i + 1] / h;
                }
                for (int j = 0; j <= i; ++j) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g += this.v[k4][i + 1] * this.v[k4][j];
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        double[] dArray = this.v[k4];
                        int n = j;
                        dArray[n] = dArray[n] - g * this.d[k4];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                this.v[k][i + 1] = 0.0;
            }
        }
        System.arraycopy(this.v[this.n - 1], 0, this.d, 0, this.n);
        Arrays.fill(this.v[this.n - 1], 0.0);
        this.v[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }
}

