/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.gui.FetcherPreviewDialog;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.PreviewEntryFetcher;
import net.sf.jabref.net.URLDownload;

public class GoogleScholarFetcher
implements PreviewEntryFetcher {
    private boolean hasRunConfig = false;
    private boolean clearKeys = true;
    protected static int MAX_ENTRIES_TO_LOAD = 50;
    static final String QUERY_MARKER = "___QUERY___";
    static final String URL_START = "http://scholar.google.com";
    static final String URL_SETTING = "http://scholar.google.com/scholar_settings";
    static final String URL_SETPREFS = "http://scholar.google.com/scholar_setprefs";
    static final String SEARCH_URL = "http://scholar.google.com/scholar?q=___QUERY___&amp;hl=en&amp;btnG=Search";
    static final Pattern BIBTEX_LINK_PATTERN = Pattern.compile("<a href=\"([^\"]*)\">[A-Za-z ]*BibTeX");
    static final Pattern TITLE_START_PATTERN = Pattern.compile("<div class=\"gs_ri\">");
    static final Pattern LINK_PATTERN = Pattern.compile("<h3 class=\"gs_rt\"><a href=\"([^\"]*)\">");
    static final Pattern TITLE_END_PATTERN = Pattern.compile("<div class=\"gs_fl\">");
    protected HashMap<String, String> entryLinks = new HashMap();
    protected boolean stopFetching = false;
    static Pattern inputPattern = Pattern.compile("<input type=([^ ]+) name=([^ ]+) value=([^> ]+)");

    @Override
    public int getWarningLimit() {
        return 10;
    }

    @Override
    public int getPreferredPreviewHeight() {
        return 100;
    }

    @Override
    public boolean processQuery(String query, ImportInspector inspector, OutputPrinter status) {
        return false;
    }

    @Override
    public boolean processQueryGetPreview(String query, FetcherPreviewDialog preview, OutputPrinter status) {
        this.entryLinks.clear();
        this.stopFetching = false;
        try {
            if (!this.hasRunConfig) {
                this.runConfig();
                this.hasRunConfig = true;
            }
            Map<String, JLabel> citations = this.getCitations(query);
            for (String link : citations.keySet()) {
                preview.addEntry(link, citations.get(link));
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            status.showMessage(Globals.lang("Error fetching from Google Scholar"));
            return false;
        }
    }

    @Override
    public void getEntries(Map<String, Boolean> selection, ImportInspector inspector) {
        boolean isSelected;
        int toDownload = 0;
        int downloaded = 0;
        for (String link : selection.keySet()) {
            isSelected = selection.get(link);
            if (!isSelected) continue;
            ++toDownload;
        }
        if (toDownload == 0) {
            return;
        }
        for (String link : selection.keySet()) {
            if (this.stopFetching) break;
            inspector.setProgress(downloaded, toDownload);
            isSelected = selection.get(link);
            if (!isSelected) continue;
            ++downloaded;
            try {
                BibtexEntry entry = this.downloadEntry(link);
                inspector.addEntry(entry);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getTitle() {
        return "Google Scholar";
    }

    @Override
    public String getKeyName() {
        return "Google Scholar";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getHelpPage() {
        return "GoogleScholarHelp.html";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
    }

    private void save(String filename, String content) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        out.write(content);
        out.close();
    }

    protected void runConfig() throws IOException {
        try {
            URL url = new URL(URL_START);
            URLDownload ud = new URLDownload(url);
            ud.download();
            url = new URL(URL_SETTING);
            ud = new URLDownload(url);
            ud.download();
            String settingsPage = ud.getStringContent();
            HashMap<String, String> formItems = GoogleScholarFetcher.getFormElements(settingsPage);
            formItems.put("scis", "yes");
            formItems.put("scisf", "4");
            formItems.put("num", String.valueOf(MAX_ENTRIES_TO_LOAD));
            StringBuilder ub = new StringBuilder("http://scholar.google.com/scholar_setprefs?");
            Iterator<String> i = formItems.keySet().iterator();
            while (i.hasNext()) {
                String name = i.next();
                ub.append(name).append("=").append(formItems.get(name));
                if (!i.hasNext()) continue;
                ub.append("&");
            }
            ub.append("&submit=");
            URL url_setprefs = new URL(ub.toString());
            ud = new URLDownload(url_setprefs);
            ud.download();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    protected Map<String, JLabel> getCitations(String query) throws IOException {
        LinkedHashMap<String, JLabel> res = new LinkedHashMap<String, JLabel>();
        try {
            String urlQuery = SEARCH_URL.replace(QUERY_MARKER, URLEncoder.encode(query, "UTF-8"));
            String nextPage = null;
            for (int count = 1; (nextPage = this.getCitationsFromUrl(urlQuery, res)) != null && count < 2; ++count) {
                urlQuery = nextPage;
                if (!this.stopFetching) continue;
            }
            return res;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getCitationsFromUrl(String urlQuery, Map<String, JLabel> ids) throws IOException {
        URL url = new URL(urlQuery);
        URLDownload ud = new URLDownload(url);
        ud.download();
        String cont = ud.getStringContent();
        Matcher m = BIBTEX_LINK_PATTERN.matcher(cont);
        int lastRegionStart = 0;
        while (m.find()) {
            String link = m.group(1).replaceAll("&amp;", "&");
            String pText = null;
            String part = cont.substring(lastRegionStart, m.start());
            Matcher titleS = TITLE_START_PATTERN.matcher(part);
            Matcher titleE = TITLE_END_PATTERN.matcher(part);
            boolean fS = titleS.find();
            boolean fE = titleE.find();
            pText = fS && fE ? (titleS.end() < titleE.start() ? part.substring(titleS.end(), titleE.start()) : part) : link;
            pText = pText.replaceAll("\\[PDF\\]", "");
            JLabel preview = new JLabel("<html>" + pText + "</html>");
            ids.put(link, preview);
            Matcher linkMatcher = LINK_PATTERN.matcher(pText);
            if (linkMatcher.find()) {
                this.entryLinks.put(link, linkMatcher.group(1));
            }
            lastRegionStart = m.end();
        }
        return null;
    }

    protected BibtexEntry downloadEntry(String link) throws IOException {
        try {
            URL url = new URL(URL_START + link);
            URLDownload ud = new URLDownload(url);
            ud.download();
            String s = ud.getStringContent();
            BibtexParser bp = new BibtexParser(new StringReader(s));
            ParserResult pr = bp.parse();
            if (pr != null && pr.getDatabase() != null) {
                Collection<BibtexEntry> entries = pr.getDatabase().getEntries();
                if (entries.size() == 1) {
                    String newtitle;
                    String title;
                    String storedUrl;
                    BibtexEntry entry = entries.iterator().next();
                    if (this.clearKeys) {
                        entry.setField("bibtexkey", null);
                    }
                    if (entry.getField("url") == null && (storedUrl = this.entryLinks.get(link)) != null) {
                        entry.setField("url", storedUrl);
                    }
                    if ((title = entry.getField("title")) != null && !(newtitle = title.replaceAll("<.?i>([^<]*)</i>", "$1")).equals(title)) {
                        entry.setField("title", newtitle);
                    }
                    return entry;
                }
                if (entries.size() == 0) {
                    System.out.println("No entry found! (" + link + ")");
                    return null;
                }
                System.out.println(entries.size() + " entries found! (" + link + ")");
                return null;
            }
            System.out.println("Parser failed! (" + link + ")");
            return null;
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static HashMap<String, String> getFormElements(String page) {
        Matcher m = inputPattern.matcher(page);
        HashMap<String, String> items = new HashMap<String, String>();
        while (m.find()) {
            String value;
            String name = m.group(2);
            if (name.length() > 2 && name.charAt(0) == '\"' && name.charAt(name.length() - 1) == '\"') {
                name = name.substring(1, name.length() - 1);
            }
            if ((value = m.group(3)).length() > 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
            items.put(name, value);
        }
        return items;
    }
}

