/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.EntryEditorTab;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldTextArea;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SearchTextListener;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;
import net.sf.jabref.gui.AutoCompleteListener;
import net.sf.jabref.gui.FileListEditor;

public class CompressedEntryEditorTab
extends EntryEditorTab {
    private JPanel panel = new JPanel();
    private JScrollPane scrollPane = new JScrollPane(this.panel, 20, 31);
    private String[] fields;
    private EntryEditor parent;
    private HashMap<String, FieldEditor> editors = new HashMap();
    private FieldEditor activeField = null;
    BibtexEntry entry;
    protected boolean updating = false;
    FocusListener fieldListener = new FocusListener(){
        JTextComponent c;
        DocumentListener d;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusGained(FocusEvent e) {
            1 var2_2 = this;
            synchronized (var2_2) {
                if (this.c != null) {
                    this.c.getDocument().removeDocumentListener(this.d);
                    this.c = null;
                    this.d = null;
                }
                if (e.getSource() instanceof JTextComponent) {
                    JScrollPane componentPane;
                    Container cPane;
                    this.c = (JTextComponent)e.getSource();
                    this.d = new DocumentListener(){

                        void fire(DocumentEvent e) {
                            if (c.isFocusOwner()) {
                                CompressedEntryEditorTab.this.markIfModified((FieldEditor)((Object)c));
                            }
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            this.fire(e);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            this.fire(e);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            this.fire(e);
                        }
                    };
                    this.c.getDocument().addDocumentListener(this.d);
                    Container cScrollPane = this.c.getParent().getParent();
                    if (cScrollPane instanceof JScrollPane && (cPane = (componentPane = (JScrollPane)cScrollPane).getParent()) instanceof JPanel) {
                        JPanel panel = (JPanel)cPane;
                        Rectangle bounds = componentPane.getBounds();
                        panel.scrollRectToVisible(bounds);
                    }
                }
            }
            CompressedEntryEditorTab.this.setActive((FieldEditor)e.getSource());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusLost(FocusEvent e) {
            1 var2_2 = this;
            synchronized (var2_2) {
                if (this.c != null) {
                    this.c.getDocument().removeDocumentListener(this.d);
                    this.c = null;
                    this.d = null;
                }
            }
            if (!e.isTemporary()) {
                CompressedEntryEditorTab.this.parent.updateField(e.getSource());
            }
        }
    };

    public CompressedEntryEditorTab(JabRefFrame frame, BasePanel panel, List<String> fields, EntryEditor parent, boolean addKeyField, String name) {
        this.fields = fields != null ? fields.toArray(new String[0]) : new String[0];
        this.parent = parent;
        this.setupPanel(frame, panel, addKeyField, name);
        this.scrollPane.setFocusCycleRoot(true);
    }

    @Override
    void setupPanel(JabRefFrame frame, BasePanel bPanel, boolean addKeyField, String title) {
        InputMap im = this.panel.getInputMap(0);
        ActionMap am = this.panel.getActionMap();
        im.put(Globals.prefs.getKey("Entry editor, previous entry"), "prev");
        am.put("prev", this.parent.prevEntryAction);
        im.put(Globals.prefs.getKey("Entry editor, next entry"), "next");
        am.put("next", this.parent.nextEntryAction);
        im.put(Globals.prefs.getKey("Entry editor, store field"), "store");
        am.put("store", this.parent.storeFieldAction);
        im.put(Globals.prefs.getKey("Entry editor, next panel"), "right");
        im.put(Globals.prefs.getKey("Entry editor, next panel 2"), "right");
        am.put("left", this.parent.switchLeftAction);
        im.put(Globals.prefs.getKey("Entry editor, previous panel"), "left");
        im.put(Globals.prefs.getKey("Entry editor, previous panel 2"), "left");
        am.put("right", this.parent.switchRightAction);
        im.put(Globals.prefs.getKey("Help"), "help");
        am.put("help", this.parent.helpAction);
        im.put(Globals.prefs.getKey("Save database"), "save");
        am.put("save", this.parent.saveDatabaseAction);
        im.put(Globals.prefs.getKey("Next tab"), "nexttab");
        am.put("nexttab", this.parent.frame.nextTab);
        im.put(Globals.prefs.getKey("Previous tab"), "prevtab");
        am.put("prevtab", this.parent.frame.prevTab);
        this.panel.setName(title);
        String colSpec = "fill:pref, 1dlu, fill:10dlu:grow, 1dlu, fill:pref, 8dlu, fill:pref, 1dlu, fill:10dlu:grow, 1dlu, fill:pref";
        StringBuffer sb = new StringBuffer();
        int rows = (int)Math.ceil((double)this.fields.length / 2.0);
        for (int i = 0; i < rows; ++i) {
            sb.append("fill:pref:grow, ");
        }
        if (addKeyField) {
            sb.append("4dlu, fill:pref");
        } else if (sb.length() >= 2) {
            sb.delete(sb.length() - 2, sb.length());
        }
        String rowSpec = sb.toString();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout(colSpec, rowSpec), this.panel);
        for (int i = 0; i < this.fields.length; ++i) {
            JComponent ta;
            int editorType = BibtexFields.getEditorType(this.fields[i]);
            if (editorType == 2) {
                ta = new FileListEditor(frame, bPanel.metaData(), this.fields[i], null, this.parent);
            } else {
                ta = new FieldTextArea(this.fields[i], null);
                frame.getSearchManager().addSearchListener((SearchTextListener)((Object)ta));
            }
            JComponent ex = this.parent.getExtra(this.fields[i], (FieldEditor)((Object)ta));
            AbstractAutoCompleter autoComp = bPanel.getAutoCompleter(this.fields[i]);
            AutoCompleteListener acl = null;
            if (autoComp != null) {
                acl = new AutoCompleteListener(autoComp);
            }
            this.setupJTextComponent(ta.getTextComponent(), acl);
            ta.setAutoCompleteListener(acl);
            this.editors.put(this.fields[i], (FieldEditor)((Object)ta));
            if (i == 0) {
                this.activeField = ta;
            }
            builder.append(ta.getLabel());
            if (ex == null) {
                builder.append((Component)ta.getPane(), 3);
            } else {
                builder.append(ta.getPane());
                JPanel pan = new JPanel();
                pan.setLayout(new BorderLayout());
                pan.add((Component)ex, "North");
                builder.append(pan);
            }
            if (i % 2 != 1) continue;
            builder.nextLine();
        }
        if (addKeyField) {
            FieldTextField tf = new FieldTextField("bibtexkey", this.parent.getEntry().getField("bibtexkey"), true);
            this.setupJTextComponent(tf, null);
            this.editors.put("bibtexkey", tf);
            if (this.editors.size() == 1) {
                this.activeField = tf;
            }
            builder.nextLine();
            builder.append(tf.getLabel());
            builder.append((Component)tf, 3);
        }
    }

    @Override
    public BibtexEntry getEntry() {
        return this.entry;
    }

    @Override
    boolean isFieldModified(FieldEditor f) {
        String text = f.getText().trim();
        if (text.length() == 0) {
            return this.getEntry().getField(f.getFieldName()) != null;
        }
        String entryValue = this.getEntry().getField(f.getFieldName());
        return entryValue == null || !entryValue.toString().equals(text);
    }

    @Override
    public void markIfModified(FieldEditor f) {
        if (!this.updating && !this.parent.panel.isBaseChanged() && this.isFieldModified(f)) {
            this.markBaseChanged();
        }
    }

    @Override
    void markBaseChanged() {
        this.parent.panel.markBaseChanged();
    }

    @Override
    public void setActive(FieldEditor c) {
        this.activeField = c;
    }

    @Override
    public FieldEditor getActive() {
        return this.activeField;
    }

    @Override
    public List<String> getFields() {
        return Arrays.asList(this.fields);
    }

    @Override
    public void activate() {
        if (this.activeField != null) {
            new FocusRequester(this.activeField.getTextComponent());
        }
    }

    @Override
    public void updateAll() {
        this.setEntry(this.getEntry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEntry(BibtexEntry entry) {
        try {
            this.updating = true;
            for (FieldEditor editor : this.editors.values()) {
                String content = entry.getField(editor.getFieldName());
                String toSet = content == null ? "" : content.toString();
                if (toSet.equals(editor.getText())) continue;
                editor.setText(toSet);
            }
            this.entry = entry;
        }
        finally {
            this.updating = false;
        }
    }

    @Override
    public boolean updateField(String field, String content) {
        if (!this.editors.containsKey(field)) {
            return false;
        }
        FieldEditor ed = this.editors.get(field);
        ed.setText(content);
        return true;
    }

    @Override
    public void validateAllFields() {
        for (String field : this.editors.keySet()) {
            FieldEditor ed = this.editors.get(field);
            ed.setEnabled(true);
            if (((Component)((Object)ed)).hasFocus()) {
                ed.setActiveBackgroundColor();
                continue;
            }
            ed.setValidBackgroundColor();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (FieldEditor editor : this.editors.values()) {
            editor.setEnabled(enabled);
        }
    }

    @Override
    public Component getPane() {
        return this.scrollPane;
    }

    @Override
    public void setupJTextComponent(JComponent component, AutoCompleteListener acl) {
        if (acl != null) {
            component.addKeyListener(acl);
            component.addFocusListener(acl);
            acl.setNextFocusListener(this.fieldListener);
        } else {
            component.addFocusListener(this.fieldListener);
        }
        InputMap im = component.getInputMap(0);
        ActionMap am = component.getActionMap();
        im.put(Globals.prefs.getKey("Entry editor, previous entry"), "prev");
        am.put("prev", this.parent.prevEntryAction);
        im.put(Globals.prefs.getKey("Entry editor, next entry"), "next");
        am.put("next", this.parent.nextEntryAction);
        im.put(Globals.prefs.getKey("Entry editor, store field"), "store");
        am.put("store", this.parent.storeFieldAction);
        im.put(Globals.prefs.getKey("Entry editor, next panel"), "right");
        im.put(Globals.prefs.getKey("Entry editor, next panel 2"), "right");
        am.put("left", this.parent.switchLeftAction);
        im.put(Globals.prefs.getKey("Entry editor, previous panel"), "left");
        im.put(Globals.prefs.getKey("Entry editor, previous panel 2"), "left");
        am.put("right", this.parent.switchRightAction);
        im.put(Globals.prefs.getKey("Help"), "help");
        am.put("help", this.parent.helpAction);
        im.put(Globals.prefs.getKey("Save database"), "save");
        am.put("save", this.parent.saveDatabaseAction);
        im.put(Globals.prefs.getKey("Next tab"), "nexttab");
        am.put("nexttab", this.parent.frame.nextTab);
        im.put(Globals.prefs.getKey("Previous tab"), "prevtab");
        am.put("prevtab", this.parent.frame.prevTab);
        try {
            HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(component.getFocusTraversalKeys(0));
            keys.clear();
            keys.add(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
            component.setFocusTraversalKeys(0, keys);
            keys = new HashSet<AWTKeyStroke>(component.getFocusTraversalKeys(1));
            keys.clear();
            keys.add(KeyStroke.getKeyStroke("shift pressed TAB"));
            component.setFocusTraversalKeys(1, keys);
        }
        catch (Throwable t) {
            System.err.println(t);
        }
    }
}

