/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.export.FieldFormatter;

public class BibtexEntry {
    public static final String ID_FIELD = "id";
    private String _id;
    private BibtexEntryType _type;
    private Map<String, String> _fields = new HashMap<String, String>();
    VetoableChangeSupport _changeSupport = new VetoableChangeSupport(this);
    private boolean searchHit;
    private boolean groupHit;

    public BibtexEntry() {
        this(Util.createNeutralId());
    }

    public BibtexEntry(String id) {
        this(id, BibtexEntryType.OTHER);
    }

    public BibtexEntry(String id, BibtexEntryType type) {
        if (id == null) {
            throw new NullPointerException("Every BibtexEntry must have an ID");
        }
        this._id = id;
        this.setType(type);
    }

    public String[] getOptionalFields() {
        return this._type.getOptionalFields();
    }

    public String[] getRequiredFields() {
        return this._type.getRequiredFields();
    }

    public Set<String> getAllFields() {
        return new TreeSet<String>(this._fields.keySet());
    }

    public String describeRequiredFields() {
        return this._type.describeRequiredFields();
    }

    public boolean hasAllRequiredFields(BibtexDatabase database) {
        return this._type.hasAllRequiredFields(this, database);
    }

    public BibtexEntryType getType() {
        return this._type;
    }

    public void setType(BibtexEntryType type) {
        if (type == null) {
            throw new NullPointerException("Every BibtexEntry must have a type.  Instead of null, use type OTHER");
        }
        BibtexEntryType oldType = this._type;
        try {
            this._type = type;
            this.firePropertyChangedEvent(GUIGlobals.TYPE_HEADER, oldType != null ? oldType.getName() : null, type.getName());
        }
        catch (PropertyVetoException pve) {
            pve.printStackTrace();
        }
    }

    public boolean updateType() {
        BibtexEntryType newType = BibtexEntryType.getType(this._type.getName());
        if (newType != null) {
            this._type = newType;
            return true;
        }
        this._type = BibtexEntryType.TYPELESS;
        return false;
    }

    public void setId(String id) throws KeyCollisionException {
        if (id == null) {
            throw new NullPointerException("Every BibtexEntry must have an ID");
        }
        try {
            this.firePropertyChangedEvent(ID_FIELD, this._id, id);
        }
        catch (PropertyVetoException pv) {
            throw new KeyCollisionException("Couldn't change ID: " + pv);
        }
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public String getField(String name) {
        return this._fields.get(name);
    }

    public String getCiteKey() {
        return this._fields.containsKey("bibtexkey") ? this._fields.get("bibtexkey") : null;
    }

    public void setField(Map<String, String> fields) {
        this._fields.putAll(fields);
    }

    public void setField(String name, String value) {
        if (ID_FIELD.equals(name)) {
            throw new IllegalArgumentException("The field name '" + name + "' is reserved");
        }
        String oldValue = this._fields.get(name);
        try {
            this._fields.put(name, value);
            this.firePropertyChangedEvent(name, oldValue, value);
        }
        catch (PropertyVetoException pve) {
            this._fields.put(name, oldValue);
            throw new IllegalArgumentException("Change rejected: " + pve);
        }
    }

    public void clearField(String name) {
        if (ID_FIELD.equals(name)) {
            throw new IllegalArgumentException("The field name '" + name + "' is reserved");
        }
        String oldValue = this._fields.get(name);
        this._fields.remove(name);
        try {
            this.firePropertyChangedEvent(name, oldValue, null);
        }
        catch (PropertyVetoException pve) {
            throw new IllegalArgumentException("Change rejected: " + pve);
        }
    }

    protected boolean allFieldsPresent(String[] fields, BibtexDatabase database) {
        for (int i = 0; i < fields.length; ++i) {
            if (BibtexDatabase.getResolvedField(fields[i], this, database) != null) continue;
            return false;
        }
        return true;
    }

    private void firePropertyChangedEvent(String fieldName, Object oldValue, Object newValue) throws PropertyVetoException {
        this._changeSupport.fireVetoableChange(new PropertyChangeEvent(this, fieldName, oldValue, newValue));
    }

    public void addPropertyChangeListener(VetoableChangeListener listener) {
        this._changeSupport.addVetoableChangeListener(listener);
    }

    public void removePropertyChangeListener(VetoableChangeListener listener) {
        this._changeSupport.removeVetoableChangeListener(listener);
    }

    public void write(Writer out, FieldFormatter ff, boolean write) throws IOException {
        int i;
        out.write("@" + this._type.getName().toUpperCase(Locale.US) + "{");
        String str = Util.shaveString(this.getField("bibtexkey"));
        out.write((str == null ? "" : str) + "," + Globals.NEWLINE);
        HashMap written = new HashMap();
        written.put("bibtexkey", null);
        boolean hasWritten = false;
        String[] s = this.getRequiredFields();
        if (s != null) {
            for (i = 0; i < s.length; ++i) {
                hasWritten |= this.writeField(s[i], out, ff, hasWritten);
                written.put(s[i], null);
            }
        }
        if ((s = this.getOptionalFields()) != null) {
            for (i = 0; i < s.length; ++i) {
                if (written.containsKey(s[i])) continue;
                hasWritten |= this.writeField(s[i], out, ff, hasWritten);
                written.put(s[i], null);
            }
        }
        TreeSet<String> remainingFields = new TreeSet<String>();
        for (String key : this._fields.keySet()) {
            boolean writeIt;
            boolean bl = writeIt = write ? BibtexFields.isWriteableField(key) : BibtexFields.isDisplayableField(key);
            if (written.containsKey(key) || !writeIt) continue;
            remainingFields.add(key);
        }
        for (String field : remainingFields) {
            hasWritten |= this.writeField(field, out, ff, hasWritten);
        }
        out.write((hasWritten ? Globals.NEWLINE : "") + "}" + Globals.NEWLINE);
    }

    private boolean writeField(String name, Writer out, FieldFormatter ff, boolean isFirst) throws IOException {
        String o = this.getField(name);
        if (o != null) {
            if (isFirst) {
                out.write("," + Globals.NEWLINE);
            }
            out.write("  " + name + " = ");
            try {
                out.write(ff.format(o.toString(), name));
            }
            catch (Throwable ex) {
                throw new IOException(Globals.lang("Error in field") + " '" + name + "': " + ex.getMessage());
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        BibtexEntry clone = new BibtexEntry(this._id, this._type);
        clone._fields = new HashMap<String, String>(this._fields);
        return clone;
    }

    public String toString() {
        return this.getType().getName() + ":" + this.getField("bibtexkey");
    }

    public boolean isSearchHit() {
        return this.searchHit;
    }

    public void setSearchHit(boolean searchHit) {
        this.searchHit = searchHit;
    }

    public boolean isGroupHit() {
        return this.groupHit;
    }

    public void setGroupHit(boolean groupHit) {
        this.groupHit = groupHit;
    }

    public String getAuthorTitleYear(int maxCharacters) {
        String[] s = new String[]{this.getField("author"), this.getField("title"), this.getField("year")};
        for (int i = 0; i < s.length; ++i) {
            if (s[i] != null) continue;
            s[i] = "N/A";
        }
        String text = s[0] + ": \"" + s[1] + "\" (" + s[2] + ")";
        if (maxCharacters <= 0 || text.length() <= maxCharacters) {
            return text;
        }
        return text.substring(0, maxCharacters + 1) + "...";
    }
}

