/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message;

import java.nio.ByteBuffer;
import net.sf.jml.MsnContact;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.util.Charset;
import net.sf.jml.util.StringHolder;

public final class MsnEmailActivityMessage
extends MsnMimeMessage {
    private static final String KEY_SRC_FOLDER = "Src-Folder";
    private static final String KEY_DEST_FOLDER = "Dest-Folder";
    private static final String KEY_MESSAGE_DELTA = "Message-Delta";
    protected final StringHolder bodykeys = new StringHolder();
    private String srcFolder;
    private String destFolder;
    private Integer messageDelta;

    public MsnEmailActivityMessage() {
        this.setContentType("text/x-msmsgsemailnotification; charset=UTF-8");
    }

    public String getSrcFolder() {
        return this.srcFolder;
    }

    public void setSrcFolder(String string) {
        this.srcFolder = string;
    }

    public String getDestFolder() {
        return this.destFolder;
    }

    public void setDestFolder(String string) {
        this.destFolder = string;
    }

    public Integer getMessageDelta() {
        return this.messageDelta;
    }

    public void setMessageDelta(Integer n) {
        this.messageDelta = n;
    }

    protected void messageReceived(MsnSession msnSession, MsnContact msnContact) {
        super.messageReceived(msnSession, msnContact);
        ((AbstractMessenger)msnSession.getMessenger()).fireEmailActivityNotificationReceived(msnSession.getSwitchboard(), this, msnContact);
    }

    protected void parseMessage(byte[] byArray) {
        super.parseMessage(byArray);
        this.setSrcFolder(this.bodykeys.getProperty(KEY_SRC_FOLDER));
        this.setDestFolder(this.bodykeys.getProperty(KEY_DEST_FOLDER));
        this.setMessageDelta(this.bodykeys.getIntProperty(KEY_MESSAGE_DELTA));
    }

    protected void parseBuffer(ByteBuffer byteBuffer) {
        super.parseBuffer(byteBuffer);
        this.bodykeys.parseString(Charset.decode(ByteBuffer.wrap(byteBuffer.array())));
    }
}

