/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.awt.Dimension;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.H261Format;
import javax.media.format.H263Format;
import javax.media.format.IndexedColorFormat;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sf.fmj.media.BonusAudioFormatEncodings;
import net.sf.fmj.media.format.GIFFormat;
import net.sf.fmj.media.format.PNGFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatArgUtils {
    private static final char SEP = ':';
    public static final String BYTE_ARRAY = "B";
    public static final String SHORT_ARRAY = "S";
    public static final String INT_ARRAY = "I";
    public static final String NOT_SPECIFIED = "?";
    public static final String BIG_ENDIAN = "B";
    public static final String LITTLE_ENDIAN = "L";
    public static final String SIGNED = "S";
    public static final String UNSIGNED = "U";
    private static final Map<String, String> formatEncodings = new HashMap<String, String>();
    private static final Map<String, Class<?>> formatClasses = new HashMap();

    private static final void addAudioFormat(String s) {
        FormatArgUtils.addFormat(s, AudioFormat.class);
    }

    private static final void addFormat(String s, Class<?> clazz) {
        formatClasses.put(s.toLowerCase(), clazz);
        formatEncodings.put(s.toLowerCase(), s);
    }

    private static final void addVideoFormat(String s) {
        FormatArgUtils.addFormat(s, VideoFormat.class);
    }

    private static final void buildFormatMap() {
        FormatArgUtils.addAudioFormat("LINEAR");
        FormatArgUtils.addAudioFormat("ULAW");
        FormatArgUtils.addAudioFormat("ULAW/rtp");
        FormatArgUtils.addAudioFormat("alaw");
        FormatArgUtils.addAudioFormat("ima4");
        FormatArgUtils.addAudioFormat("ima4/ms");
        FormatArgUtils.addAudioFormat("msadpcm");
        FormatArgUtils.addAudioFormat("dvi");
        FormatArgUtils.addAudioFormat("dvi/rtp");
        FormatArgUtils.addAudioFormat("g723");
        FormatArgUtils.addAudioFormat("g723/rtp");
        FormatArgUtils.addAudioFormat("g728");
        FormatArgUtils.addAudioFormat("g728/rtp");
        FormatArgUtils.addAudioFormat("g729");
        FormatArgUtils.addAudioFormat("g729/rtp");
        FormatArgUtils.addAudioFormat("g729a");
        FormatArgUtils.addAudioFormat("g729a/rtp");
        FormatArgUtils.addAudioFormat("gsm");
        FormatArgUtils.addAudioFormat("gsm/ms");
        FormatArgUtils.addAudioFormat("gsm/rtp");
        FormatArgUtils.addAudioFormat("MAC3");
        FormatArgUtils.addAudioFormat("MAC6");
        FormatArgUtils.addAudioFormat("truespeech");
        FormatArgUtils.addAudioFormat("msnaudio");
        FormatArgUtils.addAudioFormat("mpeglayer3");
        FormatArgUtils.addAudioFormat("voxwareac8");
        FormatArgUtils.addAudioFormat("voxwareac10");
        FormatArgUtils.addAudioFormat("voxwareac16");
        FormatArgUtils.addAudioFormat("voxwareac20");
        FormatArgUtils.addAudioFormat("voxwaremetavoice");
        FormatArgUtils.addAudioFormat("voxwaremetasound");
        FormatArgUtils.addAudioFormat("voxwarert29h");
        FormatArgUtils.addAudioFormat("voxwarevr12");
        FormatArgUtils.addAudioFormat("voxwarevr18");
        FormatArgUtils.addAudioFormat("voxwaretq40");
        FormatArgUtils.addAudioFormat("voxwaretq60");
        FormatArgUtils.addAudioFormat("msrt24");
        FormatArgUtils.addAudioFormat("mpegaudio");
        FormatArgUtils.addAudioFormat("mpegaudio/rtp");
        FormatArgUtils.addAudioFormat("dolbyac3");
        for (String e : BonusAudioFormatEncodings.ALL) {
            FormatArgUtils.addAudioFormat(e);
        }
        FormatArgUtils.addVideoFormat("cvid");
        FormatArgUtils.addFormat("jpeg", JPEGFormat.class);
        FormatArgUtils.addVideoFormat("jpeg/rtp");
        FormatArgUtils.addVideoFormat("mpeg");
        FormatArgUtils.addVideoFormat("mpeg/rtp");
        FormatArgUtils.addFormat("h261", H261Format.class);
        FormatArgUtils.addVideoFormat("h261/rtp");
        FormatArgUtils.addFormat("h263", H263Format.class);
        FormatArgUtils.addVideoFormat("h263/rtp");
        FormatArgUtils.addVideoFormat("h263-1998/rtp");
        FormatArgUtils.addFormat("rgb", RGBFormat.class);
        FormatArgUtils.addFormat("yuv", YUVFormat.class);
        FormatArgUtils.addFormat("irgb", IndexedColorFormat.class);
        FormatArgUtils.addVideoFormat("smc");
        FormatArgUtils.addVideoFormat("rle");
        FormatArgUtils.addVideoFormat("rpza");
        FormatArgUtils.addVideoFormat("mjpg");
        FormatArgUtils.addVideoFormat("mjpa");
        FormatArgUtils.addVideoFormat("mjpb");
        FormatArgUtils.addVideoFormat("iv32");
        FormatArgUtils.addVideoFormat("iv41");
        FormatArgUtils.addVideoFormat("iv50");
        FormatArgUtils.addFormat("gif", GIFFormat.class);
        FormatArgUtils.addFormat("png", PNGFormat.class);
    }

    private static final String dataTypeToStr(Class<?> clazz) {
        if (clazz == null) {
            return NOT_SPECIFIED;
        }
        if (clazz == Format.byteArray) {
            return "B";
        }
        if (clazz == Format.shortArray) {
            return "S";
        }
        if (clazz == Format.intArray) {
            return INT_ARRAY;
        }
        throw new IllegalArgumentException("" + clazz);
    }

    private static final String dimensionToStr(Dimension d) {
        if (d == null) {
            return NOT_SPECIFIED;
        }
        return (int)d.getWidth() + "x" + (int)d.getHeight();
    }

    private static final String endianToStr(int endian) {
        if (endian == -1) {
            return NOT_SPECIFIED;
        }
        if (endian == 1) {
            return "B";
        }
        if (endian == 0) {
            return LITTLE_ENDIAN;
        }
        throw new IllegalArgumentException("Unknown endianness: " + endian);
    }

    private static final String floatToStr(float v) {
        if (v == -1.0f) {
            return NOT_SPECIFIED;
        }
        return "" + v;
    }

    private static final String intToStr(int i) {
        if (i == -1) {
            return NOT_SPECIFIED;
        }
        return "" + i;
    }

    public static Format parse(String s) throws ParseException {
        String[] strings = s.split(":");
        Tokens t = new Tokens(strings);
        boolean ix = false;
        String encodingIgnoreCase = t.nextString(null);
        if (encodingIgnoreCase == null) {
            throw new ParseException("No encoding specified", 0);
        }
        Class<?> formatClass = formatClasses.get(encodingIgnoreCase.toLowerCase());
        if (formatClass == null) {
            throw new ParseException("Unknown encoding: " + encodingIgnoreCase, -1);
        }
        String encoding = formatEncodings.get(encodingIgnoreCase.toLowerCase());
        if (encoding == null) {
            throw new ParseException("Unknown encoding: " + encodingIgnoreCase, -1);
        }
        if (AudioFormat.class.isAssignableFrom(formatClass)) {
            double sampleRate = t.nextDouble();
            int sampleSizeInBits = t.nextInt();
            int channels = t.nextInt();
            int endian = t.nextEndian();
            int signed = t.nextSigned();
            int frameSizeInBits = t.nextInt();
            double frameRate = t.nextDouble();
            Class<?> dataType = t.nextDataType();
            if (dataType == null) {
                dataType = Format.byteArray;
            }
            return new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, endian, signed, frameSizeInBits, frameRate, dataType);
        }
        if (VideoFormat.class.isAssignableFrom(formatClass)) {
            if (formatClass == JPEGFormat.class) {
                Dimension size = t.nextDimension();
                int maxDataLength = t.nextInt();
                Class<?> dataType = t.nextDataType();
                if (dataType == null) {
                    dataType = Format.byteArray;
                }
                float frameRate = t.nextFloat();
                int q = -1;
                int dec = -1;
                return new JPEGFormat(size, maxDataLength, dataType, frameRate, -1, -1);
            }
            if (formatClass == GIFFormat.class) {
                Dimension size = t.nextDimension();
                int maxDataLength = t.nextInt();
                Class<?> dataType = t.nextDataType();
                if (dataType == null) {
                    dataType = Format.byteArray;
                }
                float frameRate = t.nextFloat();
                return new GIFFormat(size, maxDataLength, dataType, frameRate);
            }
            if (formatClass == PNGFormat.class) {
                Dimension size = t.nextDimension();
                int maxDataLength = t.nextInt();
                Class<?> dataType = t.nextDataType();
                if (dataType == null) {
                    dataType = Format.byteArray;
                }
                float frameRate = t.nextFloat();
                return new PNGFormat(size, maxDataLength, dataType, frameRate);
            }
            if (formatClass == VideoFormat.class) {
                Dimension size = t.nextDimension();
                int maxDataLength = t.nextInt();
                Class<?> dataType = t.nextDataType();
                if (dataType == null) {
                    dataType = Format.byteArray;
                }
                float frameRate = t.nextFloat();
                return new VideoFormat(encoding, size, maxDataLength, dataType, frameRate);
            }
            if (formatClass == RGBFormat.class) {
                Dimension size = t.nextDimension();
                int maxDataLength = t.nextInt();
                Class<?> dataType = t.nextDataType();
                if (dataType == null) {
                    dataType = Format.byteArray;
                }
                float frameRate = t.nextFloat();
                int bitsPerPixel = t.nextInt();
                int red = t.nextInt();
                int green = t.nextInt();
                int blue = t.nextInt();
                int pixelStride = t.nextInt();
                int lineStride = t.nextInt();
                int flipped = t.nextInt();
                int endian = t.nextRGBFormatEndian();
                if (pixelStride == -1 && lineStride == -1 && flipped == -1 && endian == -1) {
                    return new RGBFormat(size, maxDataLength, dataType, frameRate, bitsPerPixel, red, green, blue);
                }
                return new RGBFormat(size, maxDataLength, dataType, frameRate, bitsPerPixel, red, green, blue, pixelStride, lineStride, flipped, endian);
            }
            throw new RuntimeException("TODO: Unknown class: " + formatClass);
        }
        throw new RuntimeException("Unknown class: " + formatClass);
    }

    private static final String rgbFormatEndianToStr(int endian) {
        if (endian == -1) {
            return NOT_SPECIFIED;
        }
        if (endian == 0) {
            return "B";
        }
        if (endian == 1) {
            return LITTLE_ENDIAN;
        }
        throw new IllegalArgumentException("Unknown endianness: " + endian);
    }

    private static final String signedToStr(int signed) {
        if (signed == -1) {
            return NOT_SPECIFIED;
        }
        if (signed == 1) {
            return "S";
        }
        if (signed == 0) {
            return UNSIGNED;
        }
        throw new IllegalArgumentException("Unknown signedness: " + signed);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toString(Format f) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(f.getEncoding().toUpperCase());
        if (f instanceof AudioFormat) {
            AudioFormat af = (AudioFormat)f;
            list.add(FormatArgUtils.intToStr((int)af.getSampleRate()));
            list.add(FormatArgUtils.intToStr(af.getSampleSizeInBits()));
            list.add(FormatArgUtils.intToStr(af.getChannels()));
            list.add(FormatArgUtils.endianToStr(af.getEndian()));
            list.add(FormatArgUtils.signedToStr(af.getSigned()));
            list.add(FormatArgUtils.intToStr(af.getFrameSizeInBits()));
            list.add(FormatArgUtils.intToStr((int)af.getFrameRate()));
            if (af.getDataType() != null && af.getDataType() != Format.byteArray) {
                list.add(FormatArgUtils.dataTypeToStr(af.getDataType()));
            }
        } else {
            if (!(f instanceof VideoFormat)) throw new IllegalArgumentException("" + f);
            VideoFormat vf = (VideoFormat)f;
            if (f.getClass() == JPEGFormat.class) {
                JPEGFormat jf = (JPEGFormat)vf;
                list.add(FormatArgUtils.dimensionToStr(jf.getSize()));
                list.add(FormatArgUtils.intToStr(jf.getMaxDataLength()));
                if (jf.getDataType() != null && jf.getDataType() != Format.byteArray) {
                    list.add(FormatArgUtils.dataTypeToStr(jf.getDataType()));
                }
                list.add(FormatArgUtils.floatToStr(jf.getFrameRate()));
            } else if (f.getClass() == GIFFormat.class) {
                GIFFormat gf = (GIFFormat)vf;
                list.add(FormatArgUtils.dimensionToStr(gf.getSize()));
                list.add(FormatArgUtils.intToStr(gf.getMaxDataLength()));
                if (gf.getDataType() != null && gf.getDataType() != Format.byteArray) {
                    list.add(FormatArgUtils.dataTypeToStr(gf.getDataType()));
                }
                list.add(FormatArgUtils.floatToStr(gf.getFrameRate()));
            } else if (f.getClass() == PNGFormat.class) {
                PNGFormat pf = (PNGFormat)vf;
                list.add(FormatArgUtils.dimensionToStr(pf.getSize()));
                list.add(FormatArgUtils.intToStr(pf.getMaxDataLength()));
                if (pf.getDataType() != null && pf.getDataType() != Format.byteArray) {
                    list.add(FormatArgUtils.dataTypeToStr(pf.getDataType()));
                }
                list.add(FormatArgUtils.floatToStr(pf.getFrameRate()));
            } else if (f.getClass() == VideoFormat.class) {
                list.add(FormatArgUtils.dimensionToStr(vf.getSize()));
                list.add(FormatArgUtils.intToStr(vf.getMaxDataLength()));
                if (vf.getDataType() != null && vf.getDataType() != Format.byteArray) {
                    list.add(FormatArgUtils.dataTypeToStr(vf.getDataType()));
                }
                list.add(FormatArgUtils.floatToStr(vf.getFrameRate()));
            } else {
                if (f.getClass() != RGBFormat.class) throw new IllegalArgumentException("Unknown or unsupported format: " + f);
                RGBFormat rf = (RGBFormat)vf;
                list.add(FormatArgUtils.dimensionToStr(vf.getSize()));
                list.add(FormatArgUtils.intToStr(vf.getMaxDataLength()));
                if (vf.getDataType() != null && vf.getDataType() != Format.byteArray) {
                    list.add(FormatArgUtils.dataTypeToStr(vf.getDataType()));
                }
                list.add(FormatArgUtils.floatToStr(vf.getFrameRate()));
                list.add(FormatArgUtils.intToStr(rf.getBitsPerPixel()));
                list.add(FormatArgUtils.intToStr(rf.getRedMask()));
                list.add(FormatArgUtils.intToStr(rf.getGreenMask()));
                list.add(FormatArgUtils.intToStr(rf.getBlueMask()));
                list.add(FormatArgUtils.intToStr(rf.getPixelStride()));
                list.add(FormatArgUtils.intToStr(rf.getLineStride()));
                list.add(FormatArgUtils.intToStr(rf.getFlipped()));
                list.add(FormatArgUtils.rgbFormatEndianToStr(rf.getEndian()));
            }
        }
        while (list.get(list.size() - 1) == null || ((String)list.get(list.size() - 1)).equals(NOT_SPECIFIED)) {
            list.remove(list.size() - 1);
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                b.append(':');
            }
            b.append((String)list.get(i));
        }
        return b.toString();
    }

    static {
        FormatArgUtils.buildFormatMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Tokens {
        private final String[] items;
        private int ix;

        public Tokens(String[] items) {
            this.items = items;
            this.ix = 0;
        }

        public Class<?> nextDataType() throws ParseException {
            String s = this.nextString();
            if (s == null) {
                return null;
            }
            if (s.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return null;
            }
            if ((s = s.toUpperCase()).equals("B")) {
                return Format.byteArray;
            }
            if (s.equals("S")) {
                return Format.shortArray;
            }
            if (s.equals(FormatArgUtils.INT_ARRAY)) {
                return Format.intArray;
            }
            throw new ParseException("Expected one of [B,S,I]: " + s, -1);
        }

        public Dimension nextDimension() throws ParseException {
            int height;
            int width;
            String s = this.nextString();
            if (s == null) {
                return null;
            }
            if (s.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return null;
            }
            String[] strings = (s = s.toUpperCase()).split("X");
            if (strings.length != 2) {
                throw new ParseException("Expected WIDTHxHEIGHT: " + s, -1);
            }
            try {
                width = Integer.parseInt(strings[0]);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Expected integer: " + strings[0], -1);
            }
            try {
                height = Integer.parseInt(strings[1]);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Expected integer: " + strings[1], -1);
            }
            return new Dimension(width, height);
        }

        public double nextDouble() throws ParseException {
            String s = this.nextString();
            if (s == null) {
                return -1.0;
            }
            if (s.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1.0;
            }
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Expected double: " + s, -1);
            }
        }

        public int nextEndian() throws ParseException {
            String s = this.nextString();
            if (s == null) {
                return -1;
            }
            if (s.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1;
            }
            if ((s = s.toUpperCase()).equals("B")) {
                return 1;
            }
            if (s.equals(FormatArgUtils.LITTLE_ENDIAN)) {
                return 0;
            }
            throw new ParseException("Expected one of [B,L]: " + s, -1);
        }

        public float nextFloat() throws ParseException {
            String s = this.nextString();
            if (s == null) {
                return -1.0f;
            }
            if (s.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1.0f;
            }
            try {
                return Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Expected float: " + s, -1);
            }
        }

        public int nextInt() throws ParseException {
            String s = this.nextString();
            if (s == null) {
                return -1;
            }
            if (s.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1;
            }
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Expected integer: " + s, -1);
            }
        }

        public int nextRGBFormatEndian() throws ParseException {
            String s = this.nextString();
            if (s == null) {
                return -1;
            }
            if (s.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1;
            }
            if ((s = s.toUpperCase()).equals("B")) {
                return 0;
            }
            if (s.equals(FormatArgUtils.LITTLE_ENDIAN)) {
                return 1;
            }
            throw new ParseException("Expected one of [B,L]: " + s, -1);
        }

        public int nextSigned() throws ParseException {
            String s = this.nextString();
            if (s == null) {
                return -1;
            }
            if (s.equals(FormatArgUtils.NOT_SPECIFIED)) {
                return -1;
            }
            if ((s = s.toUpperCase()).equals(FormatArgUtils.UNSIGNED)) {
                return 0;
            }
            if (s.equals("S")) {
                return 1;
            }
            throw new ParseException("Expected one of [U,U]: " + s, -1);
        }

        public String nextString() {
            return this.nextString(null);
        }

        public String nextString(String defaultResult) {
            if (this.ix >= this.items.length) {
                return defaultResult;
            }
            String result = this.items[this.ix];
            ++this.ix;
            return result;
        }
    }
}

