/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;

public class RealSetOpResultSetStatistics
extends RealNoPutResultSetStatistics {
    public int opType;
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    public ResultSetStatistics leftResultSetStatistics;
    public ResultSetStatistics rightResultSetStatistics;

    public RealSetOpResultSetStatistics(int n, int n2, int n3, int n4, long l, long l2, long l3, long l4, int n5, int n6, int n7, int n8, double d, double d2, ResultSetStatistics resultSetStatistics, ResultSetStatistics resultSetStatistics2) {
        super(n2, n3, n4, l, l2, l3, l4, n5, d, d2);
        this.opType = n;
        this.rowsSeenLeft = n6;
        this.rowsSeenRight = n7;
        this.rowsReturned = n8;
        this.leftResultSetStatistics = resultSetStatistics;
        this.rightResultSetStatistics = resultSetStatistics2;
    }

    public String getStatementExecutionPlanText(int n) {
        this.initFormatInfo(n);
        String string = this.opType == 1 ? "INTERSECT ResultSet" : "EXCEPT ResultSet";
        return this.indent + MessageService.getTextMessage(string) + ":\n" + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X79.U") + " = " + this.rowsSeenLeft + "\n" + this.indent + MessageService.getTextMessage("43X80.U") + " = " + this.rowsSeenRight + "\n" + this.indent + MessageService.getTextMessage("43X81.U") + " = " + this.rowsReturned + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X82.U") + ":\n" + this.leftResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n" + this.indent + MessageService.getTextMessage("43X83.U") + ":\n" + this.rightResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    public String getScanStatisticsText(String string, int n) {
        return this.leftResultSetStatistics.getScanStatisticsText(string, n) + this.rightResultSetStatistics.getScanStatisticsText(string, n);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public Vector getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.leftResultSetStatistics);
        vector.addElement(this.rightResultSetStatistics);
        return vector;
    }

    public String getNodeName() {
        String string = this.opType == 1 ? "INTERSECT" : "EXCEPT";
        return MessageService.getTextMessage(string);
    }

    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n = 0;
        if (this.leftResultSetStatistics != null) {
            ++n;
        }
        if (this.rightResultSetStatistics != null) {
            ++n;
        }
        xPLAINVisitor.setNumberOfChildren(n);
        xPLAINVisitor.visit(this);
        if (this.leftResultSetStatistics != null) {
            this.leftResultSetStatistics.accept(xPLAINVisitor);
        }
        if (this.rightResultSetStatistics != null) {
            this.rightResultSetStatistics.accept(xPLAINVisitor);
        }
    }

    public String getRSXplainType() {
        return "SET";
    }

    public String getRSXplainDetails() {
        String string = "(" + this.resultSetNumber + ")";
        string = string + (this.opType == 1 ? ", INTERSECT" : ", EXCEPT");
        return string;
    }

    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), new Integer(this.numOpens), null, null, null, (UUID)object2, new Double(this.optimizerEstimatedRowCount), new Double(this.optimizerEstimatedCost), null, null, null, new Integer(this.rowsSeenLeft), new Integer(this.rowsSeenRight), new Integer(this.rowsFiltered), new Integer(this.rowsReturned), null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }
}

