/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import org.glassfish.grizzly.websockets.Broadcaster;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketException;

public class OptimizedBroadcaster
implements Broadcaster {
    @Override
    public void broadcast(Iterable<? extends WebSocket> recipients, String text) {
        byte[] rawDataToSend = null;
        for (WebSocket webSocket : recipients) {
            DefaultWebSocket defaultWebSocket = (DefaultWebSocket)webSocket;
            if (!webSocket.isConnected()) continue;
            if (rawDataToSend == null) {
                rawDataToSend = defaultWebSocket.toRawData(text);
            }
            try {
                defaultWebSocket.sendRaw(rawDataToSend);
            }
            catch (WebSocketException ignored) {}
        }
    }

    @Override
    public void broadcast(Iterable<? extends WebSocket> recipients, byte[] binary) {
        byte[] rawDataToSend = null;
        for (WebSocket webSocket : recipients) {
            DefaultWebSocket defaultWebSocket = (DefaultWebSocket)webSocket;
            if (!webSocket.isConnected()) continue;
            if (rawDataToSend == null) {
                rawDataToSend = defaultWebSocket.toRawData(binary);
            }
            try {
                defaultWebSocket.sendRaw(rawDataToSend);
            }
            catch (WebSocketException ignored) {}
        }
    }

    @Override
    public void broadcastFragment(Iterable<? extends WebSocket> recipients, String text, boolean last) {
        byte[] rawDataToSend = null;
        for (WebSocket webSocket : recipients) {
            DefaultWebSocket defaultWebSocket = (DefaultWebSocket)webSocket;
            if (!webSocket.isConnected()) continue;
            if (rawDataToSend == null) {
                rawDataToSend = defaultWebSocket.toRawData(text, last);
            }
            try {
                defaultWebSocket.sendRaw(rawDataToSend);
            }
            catch (WebSocketException ignored) {}
        }
    }

    @Override
    public void broadcastFragment(Iterable<? extends WebSocket> recipients, byte[] binary, boolean last) {
        byte[] rawDataToSend = null;
        for (WebSocket webSocket : recipients) {
            DefaultWebSocket defaultWebSocket = (DefaultWebSocket)webSocket;
            if (!webSocket.isConnected()) continue;
            if (rawDataToSend == null) {
                rawDataToSend = defaultWebSocket.toRawData(binary, last);
            }
            try {
                defaultWebSocket.sendRaw(rawDataToSend);
            }
            catch (WebSocketException ignored) {}
        }
    }
}

