/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerResource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.admin.cli.resources.ResourceConfigCreator;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@TargetType(value={CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.POST, path="create-resource-ref", description="create-resource-ref")})
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Service(name="create-resource-ref")
@PerLookup
@I18n(value="create.resource.ref")
public class CreateResourceRef
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateResourceRef.class);
    @Param(optional=true, defaultValue="true")
    private Boolean enabled;
    @Param(optional=true)
    private String target = "server";
    @Param(name="reference_name", primary=true)
    private String refName;
    @Inject
    private Domain domain;
    @Inject
    private ServiceLocator locator;
    @Inject
    private ConfigBeansUtilities configBeansUtilities;
    private String commandName = null;
    private CommandTarget[] targets;
    private boolean isTargetValid = false;
    private RefContainer refContainer = null;
    @AccessRequired.To(value={"refer"})
    private Resource resourceOfInterest = null;

    public boolean preAuthorization(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.resourceOfInterest = this.getResourceByIdentity(this.refName);
        if (this.resourceOfInterest == null) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.resourceDoesNotExist", "Resource {0} does not exist", new Object[]{this.refName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        this.refContainer = this.chooseRefContainer(context);
        if (!this.isTargetValid) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.resourceDoesNotHaveValidTarget", "Resource {0} has Invalid target to create resource-ref on {1}.", new Object[]{this.refName, this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return this.refContainer != null;
    }

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanType((ConfigBeanProxy)this.refContainer, null, ResourceRef.class), "create"));
        return accessChecks;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.isResourceRefAlreadyPresent()) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.existsAlready", "Resource ref {0} already exists for target {1}", new Object[]{this.refName, this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            this.createResourceRef();
            if (this.refContainer instanceof Cluster && this.isElegibleResource(this.refName)) {
                Target tgt = this.locator.getService(Target.class, new Annotation[0]);
                List instances = tgt.getInstances(this.target);
                for (Server svr : instances) {
                    svr.createResourceRef(this.enabled.toString(), this.refName);
                }
            }
            ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
            report.setMessage(localStrings.getLocalString("create.resource.ref.success", "resource-ref {0} created successfully.", new Object[]{this.refName}));
            report.setActionExitCode(ec);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.resource.ref.failed", "Resource ref {0} creation failed", new Object[]{this.refName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
    }

    private boolean isElegibleResource(String refName) {
        return this.isBindableResource(refName) || this.isServerResource(refName);
    }

    private boolean isResourceRefAlreadyPresent() {
        for (ResourceRef rr : this.refContainer.getResourceRef()) {
            if (!rr.getRef().equals(this.refName)) continue;
            return true;
        }
        return false;
    }

    private void createResourceRef() throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<RefContainer>(){

            public Object run(RefContainer param) throws PropertyVetoException, TransactionFailure {
                ResourceRef newResourceRef = (ResourceRef)param.createChild(ResourceRef.class);
                newResourceRef.setEnabled(CreateResourceRef.this.enabled.toString());
                newResourceRef.setRef(CreateResourceRef.this.refName);
                param.getResourceRef().add(newResourceRef);
                return newResourceRef;
            }
        }, (ConfigBeanProxy)this.refContainer);
    }

    private RefContainer chooseRefContainer(AdminCommandContext context) {
        Class<?>[] allInterfaces;
        ActionReport report = context.getActionReport();
        for (Class<?> resourceInterface : allInterfaces = this.resourceOfInterest.getClass().getInterfaces()) {
            ResourceConfigCreator resourceConfigCreator = resourceInterface.getAnnotation(ResourceConfigCreator.class);
            if (resourceConfigCreator == null) continue;
            this.commandName = resourceConfigCreator.commandName();
        }
        if (this.commandName != null) {
            List<ServiceHandle<?>> serviceHandles = this.locator.getAllServiceHandles(new Filter(){

                @Override
                public boolean matches(Descriptor arg0) {
                    String name = arg0.getName();
                    return name != null && name.equals(CreateResourceRef.this.commandName);
                }
            });
            for (ServiceHandle<?> handle : serviceHandles) {
                AdminCommand service;
                ActiveDescriptor<?> descriptor = handle.getActiveDescriptor();
                if (!descriptor.getName().equals(this.commandName)) continue;
                if (!descriptor.isReified()) {
                    this.locator.reifyDescriptor(descriptor);
                }
                if ((service = (AdminCommand)this.locator.getService((Type)descriptor.getImplementationClass(), new Annotation[0])) == null) continue;
                TargetType targetType = descriptor.getImplementationClass().getAnnotation(TargetType.class);
                this.targets = targetType.value();
                break;
            }
            if (!(this.isTargetValid = this.validateTarget(this.target, this.targets))) {
                return null;
            }
            Config config = this.domain.getConfigs().getConfigByName(this.target);
            if (config != null) {
                return config;
            }
            Server server = this.configBeansUtilities.getServerNamed(this.target);
            if (server != null) {
                return server;
            }
            Cluster cluster = this.domain.getClusterNamed(this.target);
            return cluster;
        }
        report.setMessage(localStrings.getLocalString("create.resource.ref.failed", "Resource ref {0} creation failed", new Object[]{this.refName}));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        return null;
    }

    private boolean isBindableResource(String name) {
        return this.domain.getResources().getResourceByName(BindableResource.class, name) != null;
    }

    private boolean isServerResource(String name) {
        return this.domain.getResources().getResourceByName(ServerResource.class, name) != null;
    }

    private Resource getResourceByIdentity(String id) {
        for (Resource resource : this.domain.getResources().getResources()) {
            if (!resource.getIdentity().equals(id)) continue;
            return resource;
        }
        return null;
    }

    private boolean validateTarget(String target, CommandTarget[] targets) {
        ArrayList<String> validTarget = new ArrayList<String>();
        for (CommandTarget commandTarget : targets) {
            validTarget.add(commandTarget.name());
        }
        if (target.equals("domain")) {
            return validTarget.contains(CommandTarget.DOMAIN.name());
        }
        if (target.equals("server")) {
            return validTarget.contains(CommandTarget.DAS.name());
        }
        if (this.domain.getConfigNamed(target) != null) {
            return validTarget.contains(CommandTarget.CONFIG.name());
        }
        if (this.domain.getClusterNamed(target) != null) {
            return validTarget.contains(CommandTarget.CLUSTER.name());
        }
        if (this.domain.getServerNamed(target) != null) {
            return validTarget.contains(CommandTarget.STANDALONE_INSTANCE.name());
        }
        if (this.domain.getClusterForInstance(target) != null) {
            return validTarget.contains(CommandTarget.CLUSTERED_INSTANCE.name());
        }
        if (this.domain.getNodeNamed(target) != null) {
            return validTarget.contains(CommandTarget.NODE.name());
        }
        return false;
    }
}

