/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.extension;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.web.WebContainer;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.j2ee.statistics.Stats;
import org.glassfish.logging.annotation.LogMessageInfo;

public class GrizzlyConfig
implements MonitoringLevelListener {
    private static final Logger logger = WebContainer.logger;
    private static final ResourceBundle rb = logger.getResourceBundle();
    @LogMessageInfo(message="Exception when initializing monitoring for network-listener [{0}]", level="WARNING")
    public static final String INIT_MONITORING_EXCEPTION = "AS-WEB-GLUE-00081";
    @LogMessageInfo(message="InvokeGrizzly method={0} objectName={1}", level="FINE")
    public static final String INVOKE_GRIZZLY = "AS-WEB-GLUE-00082";
    @LogMessageInfo(message="Exception while invoking mebean server operation [{0}]", level="WARNING")
    public static final String INVOKE_MBEAN_EXCEPTION = "AS-WEB-GLUE-00083";
    private boolean isMonitoringEnabled = false;
    private String domain;
    private int port;
    private static ArrayList<GrizzlyConfig> grizzlyConfigList = new ArrayList();
    private ServiceLocator services = null;

    public GrizzlyConfig(WebContainer webContainer, String domain, int port) {
        this.domain = domain;
        this.port = port;
        this.services = webContainer.getServerContext().getDefaultServices();
        grizzlyConfigList.add(this);
    }

    public void destroy() {
        this.unregisterMonitoringLevelEvents();
        grizzlyConfigList.remove(this);
    }

    public void initConfig() {
        this.initMonitoringLevel();
    }

    private void initMonitoringLevel() {
        try {
            ModuleMonitoringLevels levels;
            Config cfg = (Config)this.services.getService(Config.class, "default-instance-name", new Annotation[0]);
            MonitoringLevel monitoringLevel = MonitoringLevel.OFF;
            if (cfg.getMonitoringService() != null && (levels = cfg.getMonitoringService().getModuleMonitoringLevels()) != null) {
                monitoringLevel = MonitoringLevel.instance((String)levels.getHttpService());
            }
            this.isMonitoringEnabled = !MonitoringLevel.OFF.equals((Object)monitoringLevel);
            String methodToInvoke = this.isMonitoringEnabled ? "enableMonitoring" : "disableMonitoring";
            this.invokeGrizzly(methodToInvoke);
        }
        catch (Exception ex) {
            String msg = rb.getString(INIT_MONITORING_EXCEPTION);
            msg = MessageFormat.format(msg, this.port);
            logger.log(Level.WARNING, msg, ex);
        }
    }

    public void registerMonitoringLevelEvents() {
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this.services.getService(MonitoringRegistry.class, new Annotation[0]);
        if (monitoringRegistry != null) {
            monitoringRegistry.registerMonitoringLevelListener((MonitoringLevelListener)this, MonitoredObjectType.HTTP_LISTENER);
        }
    }

    private void unregisterMonitoringLevelEvents() {
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this.services.getService(MonitoringRegistry.class, new Annotation[0]);
        if (monitoringRegistry != null) {
            monitoringRegistry.unregisterMonitoringLevelListener((MonitoringLevelListener)this);
        }
    }

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (MonitoredObjectType.HTTP_LISTENER.equals(type)) {
            this.isMonitoringEnabled = !MonitoringLevel.OFF.equals((Object)to);
        }
        String methodToInvoke = this.isMonitoringEnabled ? "enableMonitoring" : "disabledMonitoring";
        this.invokeGrizzly(methodToInvoke);
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    protected final void invokeGrizzly(String methodToInvoke) {
        this.invokeGrizzly(methodToInvoke, null, null);
    }

    protected final void invokeGrizzly(String methodToInvoke, Object[] objects, String[] signature) {
        try {
            String onStr = this.domain + ":type=Selector,name=http" + this.port;
            ObjectName objectName = new ObjectName(onStr);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, INVOKE_GRIZZLY, new Object[]{methodToInvoke, objectName});
            }
        }
        catch (Exception ex) {
            String msg = rb.getString(INVOKE_MBEAN_EXCEPTION);
            msg = MessageFormat.format(msg, methodToInvoke);
            logger.log(Level.SEVERE, msg, ex);
        }
    }

    public final void setEnableCallFlow(boolean enableCallFlow) {
        String methodToInvoke = enableCallFlow ? "enableMonitoring" : "disabledMonitoring";
        this.invokeGrizzly(methodToInvoke);
    }

    public static ArrayList<GrizzlyConfig> getGrizzlyConfigInstances() {
        return grizzlyConfigList;
    }

    public int getPort() {
        return this.port;
    }
}

