/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.session.PersistenceType;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.deployment.runtime.ManagerProperties;
import org.glassfish.web.deployment.runtime.SessionManager;
import org.glassfish.web.deployment.runtime.StoreProperties;
import org.glassfish.web.deployment.runtime.WebProperty;

public class SessionManagerConfigurationHelper {
    private static final Logger _logger = WebContainer.logger;
    @LogMessageInfo(message="Web App Distributable {0}: {1}", level="FINEST")
    public static final String WEB_APP_DISTRIBUTABLE = "AS-WEB-GLUE-00123";
    @LogMessageInfo(message="AvailabilityGloballyEnabled = {0}", level="FINEST")
    public static final String AVAILABILITY_GLOBALLY_ENABLED = "AS-WEB-GLUE-00124";
    @LogMessageInfo(message="instance-level persistence-type = {0} instance-level persistenceFrequency = {1} instance-level persistenceScope = {2}", level="FINEST")
    public static final String INSTANCE_LEVEL_INFO = "AS-WEB-GLUE-00125";
    @LogMessageInfo(message="webAppLevelPersistenceType = {0} webAppLevelPersistenceFrequency = {1} webAppLevelPersistenceScope = {2}", level="FINEST")
    public static final String WEB_APP_LEVEL_INFO = "AS-WEB-GLUE-00126";
    @LogMessageInfo(message="IN WebContainer>>ConfigureSessionManager after web level check AFTER_WEB_PERSISTENCE-TYPE IS = {0} AFTER_WEB_PERSISTENCE_FREQUENCY IS = {1} AFTER_WEB_PERSISTENCE_SCOPE IS = {2}", level="FINEST")
    public static final String AFTER_WEB_LEVEL_CHECK_INFO = "AS-WEB-GLUE-00127";
    @LogMessageInfo(message="Is {0} a system app: {1}", level="FINEST")
    public static final String IS_SYSTEM_APP = "AS-WEB-GLUE-00128";
    @LogMessageInfo(message="SessionConfigurationHelper: Is AppDistributable {0}", level="FINEST")
    public static final String IS_APP_DISTRIBUTABLE = "AS-WEB-GLUE-00129";
    @LogMessageInfo(message="Invalid Session Management Configuration for non-distributable app [{0}] - defaulting to memory: persistence-type = [{1}] / persistenceFrequency = [{2}] / persistenceScope = [{3}]", level="INFO")
    public static final String INVALID_SESSION_MANAGER_CONFIG = "AS-WEB-GLUE-00130";
    @LogMessageInfo(message="IN WebContainer>>ConfigureSessionManager before builder factory FINAL_PERSISTENCE-TYPE IS = {0} FINAL_PERSISTENCE_FREQUENCY IS = {1} FINAL_PERSISTENCE_SCOPE IS = {2}", level="FINEST")
    public static final String CONFIGURE_SESSION_MANAGER_FINAL = "AS-WEB-GLUE-00131";
    protected WebModule _ctx = null;
    protected SessionManager _smBean = null;
    protected WebBundleDescriptor _wbd = null;
    protected WebModuleConfig _wmInfo = null;
    protected PersistenceType _persistence = PersistenceType.MEMORY;
    protected String _persistenceFrequency = null;
    protected String _persistenceScope = null;
    private boolean _initialized = false;
    private ArrayList<String> _systemApps = new ArrayList();
    protected ServerConfigLookup serverConfigLookup;

    public SessionManagerConfigurationHelper(WebModule ctx, SessionManager smBean, WebBundleDescriptor wbd, WebModuleConfig wmInfo, ServerConfigLookup serverConfigLookup) {
        this._ctx = ctx;
        this._smBean = smBean;
        this._wbd = wbd;
        this._wmInfo = wmInfo;
        this.serverConfigLookup = serverConfigLookup;
        this._systemApps.add("com_sun_web_ui");
        this._systemApps.add("__default-admingui");
        this._systemApps.add("adminapp");
        this._systemApps.add("admingui");
    }

    protected boolean isSystemApp(String appName) {
        return this._systemApps.contains(appName);
    }

    protected void initializeConfiguration() {
        PersistenceType serverDefaultPersistenceType;
        boolean isAppDistributable = false;
        if (this._wbd != null) {
            isAppDistributable = this._wbd.isDistributable();
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, WEB_APP_DISTRIBUTABLE, new Object[]{this.getApplicationId(this._ctx), isAppDistributable});
        }
        PersistenceType persistence = PersistenceType.MEMORY;
        String persistenceFrequency = null;
        String persistenceScope = null;
        boolean isAvailabilityEnabled = this.serverConfigLookup.calculateWebAvailabilityEnabledFromConfig(this._ctx);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, AVAILABILITY_GLOBALLY_ENABLED, isAvailabilityEnabled);
        }
        if (isAvailabilityEnabled) {
            persistence = PersistenceType.REPLICATED;
            persistenceFrequency = "web-method";
            persistenceScope = "session";
        }
        if ((serverDefaultPersistenceType = this.serverConfigLookup.getPersistenceTypeFromConfig()) != null) {
            persistence = serverDefaultPersistenceType;
            persistenceFrequency = this.serverConfigLookup.getPersistenceFrequencyFromConfig();
            persistenceScope = this.serverConfigLookup.getPersistenceScopeFromConfig();
        }
        String insLevelPersistenceTypeString = null;
        if (persistence != null) {
            insLevelPersistenceTypeString = persistence.getType();
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, INSTANCE_LEVEL_INFO, new Object[]{insLevelPersistenceTypeString, persistenceFrequency, persistenceScope});
        }
        String webAppLevelPersistenceFrequency = null;
        String webAppLevelPersistenceScope = null;
        if (this._smBean != null) {
            String pType = this._smBean.getAttributeValue("PersistenceType");
            persistence = PersistenceType.parseType(pType, persistence);
            webAppLevelPersistenceFrequency = this.getPersistenceFrequency(this._smBean);
            webAppLevelPersistenceScope = this.getPersistenceScope(this._smBean);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, WEB_APP_LEVEL_INFO, new Object[]{pType, webAppLevelPersistenceFrequency, webAppLevelPersistenceScope});
            }
        }
        if (webAppLevelPersistenceFrequency != null) {
            persistenceFrequency = webAppLevelPersistenceFrequency;
        }
        if (webAppLevelPersistenceScope != null) {
            persistenceScope = webAppLevelPersistenceScope;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, AFTER_WEB_LEVEL_CHECK_INFO, new Object[]{persistence.getType(), persistenceFrequency, persistenceScope});
        }
        String frequency = null;
        String scope = null;
        if (persistence != PersistenceType.MEMORY && persistence != PersistenceType.FILE && persistence != PersistenceType.CUSTOM) {
            frequency = persistenceFrequency;
            scope = persistenceScope;
        }
        if (!isAppDistributable && persistence != PersistenceType.MEMORY) {
            String wmName = this.getApplicationId(this._ctx);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, IS_SYSTEM_APP, new Object[]{wmName, this.isSystemApp(wmName)});
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, IS_APP_DISTRIBUTABLE, isAppDistributable);
            }
            if (isAvailabilityEnabled && !wmName.equals("__default-web-module") && !this.isSystemApp(wmName) && _logger.isLoggable(Level.INFO)) {
                Object[] params = new Object[]{this.getApplicationId(this._ctx), persistence.getType(), frequency, scope};
                _logger.log(Level.INFO, INVALID_SESSION_MANAGER_CONFIG, params);
            }
            persistence = PersistenceType.MEMORY;
            frequency = null;
            scope = null;
        }
        if (!isAvailabilityEnabled && persistence != PersistenceType.FILE && persistence != PersistenceType.COOKIE && persistence != PersistenceType.COHERENCE_WEB) {
            persistence = PersistenceType.MEMORY;
            frequency = null;
            scope = null;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, CONFIGURE_SESSION_MANAGER_FINAL, new Object[]{persistence.getType(), frequency, scope});
        }
        this._persistence = persistence;
        this._persistenceFrequency = frequency;
        this._persistenceScope = scope;
    }

    public String getApplicationId(WebModule ctx) {
        return ctx.getID();
    }

    protected String getPersistenceFrequency(SessionManager smBean) {
        String persistenceFrequency = null;
        ManagerProperties mgrBean = smBean.getManagerProperties();
        if (mgrBean != null && mgrBean.sizeWebProperty() > 0) {
            WebProperty[] props = mgrBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase("persistenceFrequency")) continue;
                persistenceFrequency = value;
            }
        }
        return persistenceFrequency;
    }

    protected String getPersistenceScope(SessionManager smBean) {
        String persistenceScope = null;
        StoreProperties storeBean = smBean.getStoreProperties();
        if (storeBean != null && storeBean.sizeWebProperty() > 0) {
            WebProperty[] props = storeBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase("persistenceScope")) continue;
                persistenceScope = value;
            }
        }
        return persistenceScope;
    }

    protected void checkInitialization() {
        if (!this._initialized) {
            this.initializeConfiguration();
            this._initialized = true;
        }
    }

    public PersistenceType getPersistenceType() {
        this.checkInitialization();
        return this._persistence;
    }

    public String getPersistenceFrequency() {
        this.checkInitialization();
        return this._persistenceFrequency;
    }

    public String getPersistenceScope() {
        this.checkInitialization();
        return this._persistenceScope;
    }
}

