/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.newsaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.INewsAction;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.newsaction.CopyNewsAction;
import org.rssowl.core.internal.newsaction.DeleteNewsAction;
import org.rssowl.core.internal.newsaction.Messages;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.util.CoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveNewsAction
implements INewsAction {
    public static final String ID = "org.rssowl.core.MoveNewsAction";

    @Override
    public List<IEntity> run(List<INews> news, Map<INews, INews> replacements, Object data) {
        news = CoreUtils.replace(news, replacements);
        ArrayList<IEntity> entitiesToSave = new ArrayList<IEntity>(news.size());
        Long[] binIds = (Long[])data;
        List<INewsBin> bins = CoreUtils.toBins(binIds);
        if (bins.isEmpty()) {
            return Collections.emptyList();
        }
        for (INewsBin bin : bins) {
            ArrayList<INews> copiedNews = new ArrayList<INews>(news.size());
            for (INews newsitem : news) {
                if (newsitem.getParentId() == bin.getId().longValue()) continue;
                INews newsCopy = Owl.getModelFactory().createNews(newsitem, bin);
                copiedNews.add(newsCopy);
                if (entitiesToSave.contains(newsitem)) continue;
                entitiesToSave.add(newsitem);
                replacements.put(newsitem, newsCopy);
            }
            if (copiedNews.isEmpty()) continue;
            DynamicDAO.saveAll(copiedNews);
            DynamicDAO.save(bin);
        }
        for (IEntity entity : entitiesToSave) {
            ((INews)entity).setState(INews.State.DELETED);
        }
        return entitiesToSave;
    }

    @Override
    public boolean conflictsWith(INewsAction otherAction) {
        return otherAction instanceof DeleteNewsAction || otherAction instanceof MoveNewsAction || otherAction instanceof CopyNewsAction;
    }

    @Override
    public String getLabel(Object data) {
        Long[] binIds;
        List<INewsBin> bins;
        if (data != null && data instanceof Long[] && !(bins = CoreUtils.toBins(binIds = (Long[])data)).isEmpty()) {
            StringBuilder binBuilder = new StringBuilder();
            for (INewsBin bin : bins) {
                binBuilder.append("'").append(bin.getName()).append("', ");
            }
            if (binBuilder.length() > 0) {
                binBuilder.delete(binBuilder.length() - 2, binBuilder.length());
            }
            return NLS.bind((String)Messages.MoveNewsAction_MOVE_NEWS_TO_N, (Object)binBuilder.toString());
        }
        return null;
    }
}

