/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal;

import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IStatus;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;

public class LogBridge
implements Log {
    private static final String DEBUG_PROPERTY = "rssowl.http.debug";
    private static final String TRACE_PROPERTY = "rssowl.http.trace";
    private static final String INFO_PROPERTY = "rssowl.http.info";
    private static final String WARN_PROPERTY = "rssowl.http.warn";
    private final boolean fDebug = System.getProperty("rssowl.http.debug") != null;
    private final boolean fTrace = System.getProperty("rssowl.http.trace") != null;
    private final boolean fInfo = System.getProperty("rssowl.http.info") != null;
    private final boolean fWarn = System.getProperty("rssowl.http.warn") != null;
    private final String fNl;

    public LogBridge() {
        this(null);
    }

    public LogBridge(String str) {
        String nl = System.getProperty("line.separator");
        if (!StringUtils.isSet(nl)) {
            nl = "\n";
        }
        this.fNl = nl;
    }

    public void error(Object message, Throwable t) {
        this.logError(message, t);
    }

    public void error(Object message) {
        this.logError(message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.logError(message, t);
    }

    public void fatal(Object message) {
        this.logError(message, null);
    }

    private void logInfo(Object message, Throwable t) {
        this.logStatus(message, t, Level.INFO);
    }

    private void logWarning(Object message, Throwable t) {
        this.logStatus(message, t, Level.WARNING);
    }

    private void logError(Object message, Throwable t) {
        this.logStatus(message, t, Level.ERROR);
    }

    private void logStatus(Object message, Throwable t, Level level) {
        if (message instanceof String || t instanceof Exception) {
            String msg = null;
            if (message instanceof String) {
                msg = message.toString();
            }
            Exception e = null;
            if (t instanceof Exception) {
                e = (Exception)t;
            }
            if (msg == null && e != null && e.getMessage() != null) {
                msg = e.getMessage();
            }
            if (level == Level.INFO || level == Level.WARNING) {
                if (StringUtils.isSet(msg)) {
                    CoreUtils.appendLogMessage(msg);
                    CoreUtils.appendLogMessage(this.fNl);
                }
            } else {
                Activator activator = Activator.getDefault();
                if (activator != null) {
                    IStatus status = activator.createErrorStatus(msg, e);
                    activator.getLog().log(status);
                }
            }
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.logInfo(message, null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.logInfo(message, t);
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.logInfo(message, null);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logInfo(message, t);
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.logWarning(message, null);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.logWarning(message, t);
        }
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.logInfo(message, null);
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.logInfo(message, t);
        }
    }

    public boolean isDebugEnabled() {
        return this.fDebug;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return this.fInfo;
    }

    public boolean isTraceEnabled() {
        return this.fTrace;
    }

    public boolean isWarnEnabled() {
        return this.fWarn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Level {
        INFO,
        WARNING,
        ERROR;

    }
}

