/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.EntityGroupItem;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.NewsFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    private ModelUtils() {
    }

    public static Long[][] toPrimitive(Collection<IFolderChild> entities) {
        ArrayList<Long> folderIds = null;
        ArrayList<Long> bookmarkIds = null;
        ArrayList<Long> newsbinIds = null;
        int folderCounter = 0;
        int bookmarkCounter = 0;
        int newsbinCounter = 0;
        for (IEntity iEntity : entities) {
            if (iEntity instanceof IFolder) {
                if (folderIds == null) {
                    folderIds = new ArrayList<Long>();
                }
                folderIds.add(iEntity.getId());
                ++folderCounter;
                continue;
            }
            if (iEntity instanceof FolderNewsMark) {
                if (folderIds == null) {
                    folderIds = new ArrayList();
                }
                folderIds.add(((FolderNewsMark)iEntity).getFolder().getId());
                ++folderCounter;
                continue;
            }
            if (iEntity instanceof IBookMark) {
                if (bookmarkIds == null) {
                    bookmarkIds = new ArrayList<Long>();
                }
                bookmarkIds.add(iEntity.getId());
                ++bookmarkCounter;
                continue;
            }
            if (iEntity instanceof INewsBin) {
                if (newsbinIds == null) {
                    newsbinIds = new ArrayList<Long>();
                }
                newsbinIds.add(iEntity.getId());
                ++newsbinCounter;
                continue;
            }
            throw new IllegalArgumentException("Only Folders, Feeds and News Bins are allowed!");
        }
        if (folderIds == null && bookmarkIds == null && newsbinIds == null) {
            return null;
        }
        Long[][] longArray = new Long[3][];
        int maxEntityCount = Math.max(folderCounter, Math.max(bookmarkCounter, newsbinCounter));
        longArray[0] = ModelUtils.toArray(folderIds, maxEntityCount);
        longArray[1] = ModelUtils.toArray(bookmarkIds, maxEntityCount);
        longArray[2] = ModelUtils.toArray(newsbinIds, maxEntityCount);
        return longArray;
    }

    private static Long[] toArray(List<Long> values, int fillFactor) {
        Long[] array = new Long[fillFactor];
        int i = 0;
        while (i < fillFactor) {
            array[i] = values != null && i < values.size() ? values.get(i) : Long.valueOf(0L);
            ++i;
        }
        return array;
    }

    public static List<IEntity> getEntities(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new ArrayList<IEntity>(0);
        }
        List elements = selection.toList();
        ArrayList<IEntity> entities = new ArrayList<IEntity>(elements.size());
        for (Object object : elements) {
            if (object instanceof IEntity && !entities.contains(object)) {
                entities.add((IEntity)object);
                continue;
            }
            if (!(object instanceof EntityGroup)) continue;
            List<EntityGroupItem> items = ((EntityGroup)object).getItems();
            for (EntityGroupItem item : items) {
                if (entities.contains(item.getEntity())) continue;
                entities.add(item.getEntity());
            }
        }
        return entities;
    }

    public static List<IFolderChild> getFoldersBookMarksBins(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new ArrayList<IFolderChild>(0);
        }
        List elements = selection.toList();
        ArrayList<IFolderChild> entities = new ArrayList<IFolderChild>(elements.size());
        for (Object object : elements) {
            if (!(object instanceof IFolder) && !(object instanceof IBookMark) && !(object instanceof INewsBin)) continue;
            entities.add((IFolderChild)object);
        }
        return entities;
    }

    public static <T extends IEntity> List<T> getEntities(IStructuredSelection selection, Class<T> entityClass) {
        if (selection.isEmpty()) {
            return new ArrayList(0);
        }
        List elements = selection.toList();
        ArrayList<IEntity> entities = new ArrayList<IEntity>(elements.size());
        for (Object object : elements) {
            if (entityClass.isInstance(object) && !entities.contains(entityClass.cast(object))) {
                entities.add((IEntity)entityClass.cast(object));
                continue;
            }
            if (!(object instanceof EntityGroup)) continue;
            List<EntityGroupItem> items = ((EntityGroup)object).getItems();
            for (EntityGroupItem item : items) {
                if (!entityClass.isInstance(item.getEntity()) || entities.contains(entityClass.cast(item.getEntity()))) continue;
                entities.add((IEntity)entityClass.cast(item.getEntity()));
            }
        }
        return entities;
    }

    public static Collection<INews> normalize(List<?> objects) {
        ArrayList<INews> normalizedNews = new ArrayList<INews>(objects.size());
        for (Object object : objects) {
            EntityGroup group;
            if (object instanceof INews && !normalizedNews.contains(object)) {
                normalizedNews.add((INews)object);
                continue;
            }
            if (!(object instanceof EntityGroup) || !"org.rssowl.ui.internal.editors.feed.NewsGrouping".equals((group = (EntityGroup)object).getCategory())) continue;
            List<IEntity> entities = group.getEntities();
            for (IEntity entity : entities) {
                if (normalizedNews.contains(entity)) continue;
                normalizedNews.add((INews)entity);
            }
        }
        return normalizedNews;
    }

    public static Set<ILabel> getLabelsForAll(IStructuredSelection selection) {
        HashSet<ILabel> labelsForAll = new HashSet<ILabel>(5);
        List<INews> selectedNews = ModelUtils.getEntities(selection, INews.class);
        block0: for (INews news : selectedNews) {
            Set newsLabels = news.getLabels();
            for (ILabel newsLabel : newsLabels) {
                if (labelsForAll.contains(newsLabel)) continue;
                for (INews news2 : selectedNews) {
                    if (!news2.getLabels().contains(newsLabel)) continue block0;
                }
                labelsForAll.add(newsLabel);
            }
        }
        return labelsForAll;
    }

    public static List<Pair<IAttachment, URI>> getAttachmentLinks(IStructuredSelection selection) {
        ArrayList<Pair<IAttachment, URI>> attachmentLinks = new ArrayList<Pair<IAttachment, URI>>();
        Collection<INews> news = ModelUtils.normalize(selection.toList());
        for (INews newsitem : news) {
            List attachments = newsitem.getAttachments();
            for (IAttachment attachment : attachments) {
                URI link = attachment.getLink();
                if (link == null) continue;
                if (!link.isAbsolute()) {
                    try {
                        link = URIUtils.resolve((URI)URIUtils.toHTTP((URI)newsitem.getFeedReference().getLink()), (URI)link);
                    }
                    catch (URISyntaxException e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                        continue;
                    }
                }
                attachmentLinks.add((Pair<IAttachment, URI>)Pair.create((Object)attachment, (Object)link));
            }
        }
        return attachmentLinks;
    }

    public static int loadIntegerValueWithFallback(IPreferenceScope preferences, String key, IPreferenceScope fallback, String fallbackKey) {
        int iVal = preferences.getInteger(key);
        if (iVal >= 0) {
            return iVal;
        }
        return Math.max(0, fallback.getInteger(fallbackKey));
    }

    public static int countNews(IBookMark bookmark) {
        ISearchField locationField = Owl.getModelFactory().createSearchField(19, INews.class.getName());
        ISearchCondition condition = Owl.getModelFactory().createSearchCondition(locationField, SearchSpecifier.SCOPE, (Object)ModelUtils.toPrimitive(Arrays.asList(bookmark)));
        List result = Owl.getPersistenceService().getModelSearch().searchNews(Collections.singleton(condition), false);
        return result.size();
    }

    public static Pair<IFolder, IFolderChild> getLocationAndPosition(IStructuredSelection selection) {
        IFolder folder = null;
        IFolderChild position = null;
        if (!selection.isEmpty()) {
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IFolder) {
                folder = (IFolder)firstElement;
            } else if (firstElement instanceof IFolderChild) {
                folder = ((IFolderChild)firstElement).getParent();
                position = (IFolderChild)firstElement;
            }
        }
        if (folder == null) {
            folder = OwlUI.getSelectedBookMarkSet();
        }
        return Pair.create((Object)folder, position);
    }

    public static boolean isEntityGroupSelected(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)selection).toList();
            for (Object object : list) {
                if (!(object instanceof EntityGroup)) continue;
                return true;
            }
        }
        return false;
    }

    public static ISearchCondition getConditionForFilter(NewsFilter.Type type) {
        IModelFactory factory = Owl.getModelFactory();
        switch (type) {
            case SHOW_ALL: {
                return null;
            }
            case SHOW_NEW: {
                ISearchField field = factory.createSearchField(14, INews.class.getName());
                return factory.createSearchCondition(field, SearchSpecifier.IS, EnumSet.of(INews.State.NEW));
            }
            case SHOW_UNREAD: {
                ISearchField field = factory.createSearchField(14, INews.class.getName());
                return factory.createSearchCondition(field, SearchSpecifier.IS, EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED));
            }
            case SHOW_STICKY: {
                ISearchField field = factory.createSearchField(13, INews.class.getName());
                return factory.createSearchCondition(field, SearchSpecifier.IS, (Object)true);
            }
            case SHOW_LABELED: {
                ISearchField field = factory.createSearchField(15, INews.class.getName());
                return factory.createSearchCondition(field, SearchSpecifier.IS, (Object)"*");
            }
            case SHOW_LAST_5_DAYS: {
                long now = System.currentTimeMillis();
                long lastFiveDays = DateUtils.getToday().getTimeInMillis() - 432000000L;
                long minutes = (now - lastFiveDays) / 60000L;
                ISearchField field = factory.createSearchField(21, INews.class.getName());
                return factory.createSearchCondition(field, SearchSpecifier.IS_LESS_THAN, (Object)((int)(minutes * -1L)));
            }
            case SHOW_RECENT: {
                long now = System.currentTimeMillis();
                long recent = DateUtils.getToday().getTimeInMillis() - 86400000L;
                long minutes = (now - recent) / 60000L;
                ISearchField field = factory.createSearchField(21, INews.class.getName());
                return factory.createSearchCondition(field, SearchSpecifier.IS_LESS_THAN, (Object)((int)(minutes * -1L)));
            }
        }
        return null;
    }
}

