/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.rssowl.ui.internal.Application;

public class ContentAssistAdapter
implements IControlContentAdapter,
IControlContentAdapter2 {
    private TextContentAdapter fTextAdapter;
    private ComboContentAdapter fComboAdapter;
    private Control fControl;
    private final char fSeparator;
    private String fSeparatorStr;
    private final boolean fExpectMultiValues;

    public ContentAssistAdapter(Control control, char separator, boolean expectMultiValues) {
        this.fControl = control;
        this.fSeparator = separator;
        this.fExpectMultiValues = expectMultiValues;
        this.fSeparatorStr = new String(new char[]{this.fSeparator});
        if (this.fSeparator != ' ') {
            this.fSeparatorStr = String.valueOf(this.fSeparatorStr) + " ";
        }
        if (control instanceof Text) {
            this.fTextAdapter = new TextContentAdapter(){

                public Rectangle getInsertionBounds(Control control) {
                    Rectangle bounds = super.getInsertionBounds(control);
                    if (Application.IS_MAC) {
                        bounds.y += 10;
                    }
                    return bounds;
                }
            };
        } else if (control instanceof Combo) {
            this.fComboAdapter = new ComboContentAdapter(){

                public Rectangle getInsertionBounds(Control control) {
                    Rectangle bounds = super.getInsertionBounds(control);
                    if (Application.IS_MAC) {
                        bounds.x -= 10;
                    }
                    return bounds;
                }
            };
        } else {
            throw new IllegalArgumentException("Can only be used for Text and Combo Widgets");
        }
    }

    public String getControlContents(Control control) {
        String text = this.getText();
        int selectionOffset = this.getSelection().x;
        if (selectionOffset == 0) {
            return "";
        }
        int previousSeparatorIndex = this.getPreviousSeparatorIndex(text, selectionOffset);
        if (previousSeparatorIndex == -1) {
            return text.substring(0, selectionOffset).trim();
        }
        return text.substring(previousSeparatorIndex + 1, selectionOffset).trim();
    }

    private int getPreviousSeparatorIndex(String text, int selectionOffset) {
        int previousSeparatorIndex = -1;
        int i = 0;
        while (i < text.length()) {
            if (i == selectionOffset) break;
            if (text.charAt(i) == this.fSeparator) {
                previousSeparatorIndex = i;
            }
            ++i;
        }
        return previousSeparatorIndex;
    }

    private int getNextSeparatorIndex(String text, int selectionOffset) {
        int nextSeparatorIndex = -1;
        int i = selectionOffset + 1;
        while (i < text.length()) {
            if (text.charAt(i) == this.fSeparator) {
                return i;
            }
            ++i;
        }
        return nextSeparatorIndex;
    }

    public void insertControlContents(Control control, String textToInsert, int cursorPosition) {
        String text = this.getText();
        int selectionOffset = this.getSelection().x;
        int previousSeparatorIndex = this.getPreviousSeparatorIndex(text, selectionOffset);
        int nextSeparatorIndex = this.getNextSeparatorIndex(text, selectionOffset);
        if (previousSeparatorIndex == -1 && nextSeparatorIndex == -1) {
            text = this.fExpectMultiValues ? String.valueOf(textToInsert) + this.fSeparatorStr : textToInsert;
        } else if (previousSeparatorIndex != -1 && nextSeparatorIndex == -1) {
            text = text.substring(0, previousSeparatorIndex);
            text = String.valueOf(text) + this.fSeparatorStr + textToInsert + this.fSeparatorStr;
        } else if (previousSeparatorIndex == -1 && nextSeparatorIndex != -1) {
            text = String.valueOf(textToInsert) + text.substring(nextSeparatorIndex);
        } else {
            String leftHand = text.substring(0, previousSeparatorIndex);
            String rightHand = text.substring(nextSeparatorIndex);
            text = String.valueOf(leftHand) + this.fSeparatorStr + textToInsert + rightHand;
        }
        this.setText(text);
        this.setSelection(new Point(this.getText().length(), this.getText().length()));
    }

    public int getCursorPosition(Control control) {
        if (control instanceof Text) {
            return this.fTextAdapter.getCursorPosition(control);
        }
        return this.fComboAdapter.getCursorPosition(control);
    }

    public Rectangle getInsertionBounds(Control control) {
        if (control instanceof Text) {
            return this.fTextAdapter.getInsertionBounds(control);
        }
        return this.fComboAdapter.getInsertionBounds(control);
    }

    public void setControlContents(Control control, String contents, int cursorPosition) {
        if (control instanceof Text) {
            this.fTextAdapter.setControlContents(control, contents, cursorPosition);
        } else {
            this.fComboAdapter.setControlContents(control, contents, cursorPosition);
        }
    }

    public void setCursorPosition(Control control, int index) {
        if (control instanceof Text) {
            this.fTextAdapter.setCursorPosition(control, index);
        } else {
            this.fComboAdapter.setCursorPosition(control, index);
        }
    }

    public Point getSelection(Control control) {
        if (control instanceof Text) {
            return this.fTextAdapter.getSelection(control);
        }
        return this.fComboAdapter.getSelection(control);
    }

    public void setSelection(Control control, Point range) {
        if (control instanceof Text) {
            this.fTextAdapter.setSelection(control, range);
        } else {
            this.fComboAdapter.setSelection(control, range);
        }
    }

    private String getText() {
        if (this.fControl instanceof Text) {
            return ((Text)this.fControl).getText();
        }
        return ((Combo)this.fControl).getText();
    }

    private Point getSelection() {
        if (this.fControl instanceof Text) {
            return ((Text)this.fControl).getSelection();
        }
        return ((Combo)this.fControl).getSelection();
    }

    private void setText(String text) {
        if (this.fControl instanceof Text) {
            ((Text)this.fControl).setText(text);
        } else {
            ((Combo)this.fControl).setText(text);
        }
    }

    private void setSelection(Point selection) {
        if (this.fControl instanceof Text) {
            ((Text)this.fControl).setSelection(selection);
        } else {
            ((Combo)this.fControl).setSelection(selection);
        }
    }
}

