/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.util.BrowserUtils;

public class SendLinkAction
implements IObjectActionDelegate {
    public static final String ID = "org.rssowl.ui.SendLinkAction";
    private IStructuredSelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        StringBuilder str = new StringBuilder();
        if (!this.fSelection.isEmpty()) {
            List list = this.fSelection.toList();
            int i = 0;
            for (Object element : list) {
                if (element instanceof IBookMark) {
                    IBookMark bookmark = (IBookMark)element;
                    String title = bookmark.getName();
                    str.append(i > 0 ? "\n\n" : "").append(title).append("\n").append(URIUtils.toHTTP((String)bookmark.getFeedLinkReference().getLinkAsText()));
                    ++i;
                    continue;
                }
                if (element instanceof INews) {
                    INews news = (INews)element;
                    String link = CoreUtils.getLink((INews)news);
                    if (link == null) continue;
                    String title = String.valueOf(CoreUtils.getHeadline((INews)news, (boolean)true)) + "\n";
                    str.append(i > 0 ? "\n\n" : "").append(title).append(link);
                    ++i;
                    continue;
                }
                if (!(element instanceof String)) continue;
                str.append(element);
            }
        }
        if (str.length() > 0) {
            BrowserUtils.sendMail(null, str.toString());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }
}

