/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.actions.MoveCopyNewsToBinAction;
import org.rssowl.ui.internal.dialogs.ArchiveNewsDialog;
import org.rssowl.ui.internal.editors.feed.NewsGrouping;
import org.rssowl.ui.internal.util.ModelUtils;
import org.rssowl.ui.internal.views.explorer.BookMarkExplorer;

public class ArchiveNewsAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String ID = "org.rssowl.ui.ArchiveCommand";
    private IStructuredSelection fSelection;

    public ArchiveNewsAction() {
        this((IStructuredSelection)StructuredSelection.EMPTY);
    }

    public ArchiveNewsAction(IStructuredSelection selection) {
        this.fSelection = selection;
        this.setId(ID);
        this.setActionDefinitionId(ID);
    }

    public ImageDescriptor getImageDescriptor() {
        return OwlUI.ARCHIVE;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return OwlUI.ARCHIVE_DISABLED;
    }

    public String getText() {
        IBindingService bs = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence binding = bs.getBestActiveBindingFor(ID);
        return binding != null ? NLS.bind((String)Messages.ArchiveNewsAction_ARCHIVE_NEWS_BINDING, (Object)binding.format()) : Messages.ArchiveNewsAction_ARCHIVE_NEWS;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        List<INews> newsList = ModelUtils.getEntities(this.fSelection, INews.class);
        if (newsList.isEmpty()) {
            return;
        }
        INewsBin archive = CoreUtils.findArchive();
        if (archive == null) {
            this.handleFirstArchive();
        } else {
            this.archiveNews(archive);
        }
    }

    private void archiveNews(INewsBin archive) {
        MoveCopyNewsToBinAction action = MoveCopyNewsToBinAction.createArchiveAction(this.fSelection, archive);
        action.run();
    }

    private void handleFirstArchive() {
        ArchiveNewsDialog dialog = new ArchiveNewsDialog(OwlUI.getActiveShell());
        int res = dialog.open();
        if (res == 1) {
            return;
        }
        IFolder selectedSet = OwlUI.getSelectedBookMarkSet();
        if (selectedSet != null) {
            INewsBin archive = Owl.getModelFactory().createNewsBin(null, selectedSet, Messages.ArchiveNewsAction_ARCHIVE);
            Map properties = selectedSet.getProperties();
            for (Map.Entry property : properties.entrySet()) {
                archive.setProperty((String)property.getKey(), (Serializable)property.getValue());
            }
            IPreferenceScope archivePreferences = Owl.getPreferenceService().getEntityScope((IEntity)archive);
            archivePreferences.putInteger(DefaultPreferences.BM_NEWS_GROUPING, NewsGrouping.Type.GROUP_BY_DATE.ordinal());
            archivePreferences.putBoolean(DefaultPreferences.ARCHIVE_BIN_MARKER, true);
            DynamicDAO.save((IPersistable)selectedSet);
            this.archiveNews(archive);
            StructuredSelection selection = new StructuredSelection((Object)archive);
            BookMarkExplorer explorer = OwlUI.getOpenedBookMarkExplorer();
            if (explorer != null) {
                explorer.getViewSite().getSelectionProvider().setSelection((ISelection)selection);
            }
            OwlUI.openInFeedView(OwlUI.getPage(), (IStructuredSelection)selection);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

