/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.Messages;

public class StatusLineUpdater
implements ISelectionChangedListener {
    private IStatusLineManager fStatusLineManager;

    public StatusLineUpdater(IStatusLineManager statusLineManager) {
        this.fStatusLineManager = statusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        String text = this.formatElements(selection.toArray());
        this.fStatusLineManager.setMessage(text);
    }

    private String formatElements(Object[] elements) {
        if (elements.length == 0) {
            return "";
        }
        if (elements.length == 1) {
            Object element = elements[0];
            if (element instanceof IFolder) {
                return ((IFolder)element).getName();
            }
            if (element instanceof IMark) {
                return ((IMark)element).getName();
            }
            if (element instanceof EntityGroup) {
                return ((EntityGroup)element).getName();
            }
            if (element instanceof INews) {
                return "";
            }
            return Messages.StatusLineUpdater_ITEM_SELECTED;
        }
        int newsCount = 0;
        int folderCount = 0;
        int bookMarkCount = 0;
        int newsBinCount = 0;
        int searchMarkCount = 0;
        int viewerGroupCount = 0;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IFolder) {
                ++folderCount;
            } else if (element instanceof IBookMark) {
                ++bookMarkCount;
            } else if (element instanceof INewsBin) {
                ++newsBinCount;
            } else if (element instanceof ISearchMark) {
                ++searchMarkCount;
            } else if (element instanceof EntityGroup) {
                ++viewerGroupCount;
            } else if (element instanceof INews) {
                ++newsCount;
            }
            ++n2;
        }
        StringBuilder itemsBuf = new StringBuilder();
        if (folderCount > 0) {
            itemsBuf.append(folderCount == 1 ? NLS.bind((String)Messages.StatusLineUpdater_N_FOLDER, (Object)folderCount) : NLS.bind((String)Messages.StatusLineUpdater_N_FOLDERS, (Object)folderCount)).append(", ");
        }
        if (bookMarkCount > 0) {
            itemsBuf.append(bookMarkCount == 1 ? NLS.bind((String)Messages.StatusLineUpdater_N_BOOKMARK, (Object)bookMarkCount) : NLS.bind((String)Messages.StatusLineUpdater_N_BOOKMARKS, (Object)bookMarkCount)).append(", ");
        }
        if (newsBinCount > 0) {
            itemsBuf.append(newsBinCount == 1 ? NLS.bind((String)Messages.StatusLineUpdater_N_BIN, (Object)newsBinCount) : NLS.bind((String)Messages.StatusLineUpdater_N_BINS, (Object)newsBinCount)).append(", ");
        }
        if (searchMarkCount > 0) {
            itemsBuf.append(searchMarkCount == 1 ? NLS.bind((String)Messages.StatusLineUpdater_N_SEARCH, (Object)searchMarkCount) : NLS.bind((String)Messages.StatusLineUpdater_N_SEARCHES, (Object)searchMarkCount)).append(", ");
        }
        if (viewerGroupCount > 0) {
            itemsBuf.append(viewerGroupCount == 1 ? NLS.bind((String)Messages.StatusLineUpdater_N_GROUP, (Object)viewerGroupCount) : NLS.bind((String)Messages.StatusLineUpdater_N_GROUPS, (Object)viewerGroupCount)).append(", ");
        }
        if (newsCount > 0) {
            itemsBuf.append(NLS.bind((String)Messages.StatusLineUpdater_N_NEWS, (Object)newsCount)).append(", ");
        }
        if (itemsBuf.length() > 0) {
            itemsBuf.delete(itemsBuf.length() - 2, itemsBuf.length());
        }
        StringBuilder buf = new StringBuilder();
        buf.append(NLS.bind((String)Messages.StatusLineUpdater_N_ITEMS_SELECTED, (Object)elements.length, (Object)itemsBuf.toString()));
        return buf.toString();
    }
}

